/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.factory;

import com.arm.streamline.analysis.database.api.IAnalysisReaderFactoryV2;
import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseReaderFactoryV2;
import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseReaderFactoryV3;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.xml.counters.BadXmlException;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNull;

public class AnalysisDatabaseFactory {
    public static final boolean ENABLE_V3_LOGGING = NullChecking.equalsNullable((Object)System.getenv("STREAMLINE_ENABLE_DBV3_DEMO_LOGGING"), (Object)"true");
    private static final @NonNull AtomicBoolean enableV3 = new AtomicBoolean(NullChecking.equalsNullable((Object)System.getenv("STREAMLINE_ENABLE_DBV3_DEMO"), (Object)"true"));
    private static final @NonNull AtomicBoolean enableV3FirstCall = new AtomicBoolean(true);

    public static @NonNull IAnalysisReaderFactoryV2 create(@NonNull File dbDirectory, @NonNull DeviceTypeCalculator deviceTypeCalculator) throws IOException, BadXmlException {
        if (AnalysisDatabaseFactory.useDbV3()) {
            File indexFile = new File(dbDirectory, "index.db");
            File dataFile = new File(dbDirectory, "data.db");
            if (indexFile.isFile() && dataFile.isFile()) {
                return new AnalysisDatabaseReaderFactoryV3(dbDirectory, deviceTypeCalculator);
            }
        }
        return new AnalysisDatabaseReaderFactoryV2(dbDirectory, deviceTypeCalculator);
    }

    public static boolean isValidVersion(@NonNull File dbDirectory) {
        boolean hasDbv3;
        File indexFile = new File(dbDirectory, "index.db");
        File dataFile = new File(dbDirectory, "data.db");
        boolean bl = hasDbv3 = indexFile.isFile() && dataFile.isFile();
        return AnalysisDatabaseFactory.useDbV3() == hasDbv3;
    }

    public static void updateDBV3EnableFlag(boolean userEnabled) {
        String envVar = System.getenv("STREAMLINE_ENABLE_DBV3_DEMO");
        String setBy = "";
        if (envVar != null) {
            userEnabled = NullChecking.equalsNullable((Object)envVar, (Object)"true");
            setBy = " (set by environment)";
        }
        if (enableV3.getAndSet(userEnabled) != userEnabled && !enableV3FirstCall.getAndSet(false)) {
            CommonPlugin.info((String)String.format("Switching to %s backend%s", userEnabled ? "new" : "old", setBy), null);
        }
    }

    public static boolean useDbV3() {
        return enableV3.get();
    }
}

