/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.counters;

import com.arm.streamline.analysis.database.api.idle.IdleState;
import com.arm.streamline.analysis.database.stream.UtidToLong;
import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisCounterValueConsumer;
import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisDeltaThreadStreamWriter;
import com.arm.streamline.analysis.database.stream.counters.IDatabaseThreadCounterChannelWriter;
import com.arm.streamline.analysis.processing.idle.IAnalysisIdleStateStreamModifierWriter;
import com.arm.utils.function.IThrowingFunction;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class DatabaseSuppliedThreadCounterChannelWriter
implements IDatabaseThreadCounterChannelWriter {
    private long sequenceCount;
    private long activeThreadKey;
    private final @NonNull IThrowingFunction<@NonNull IAnalysisCounterValueConsumer, @NonNull IAnalysisIdleStateStreamModifierWriter, IOException> idleModifierFactory;
    private final @NonNull TLongObjectMap<IAnalysisIdleStateStreamModifierWriter> perThreadStream;
    private final @NonNull IAnalysisDeltaThreadStreamWriter streamWriter;

    public DatabaseSuppliedThreadCounterChannelWriter(@NonNull IAnalysisDeltaThreadStreamWriter streamWriter, @NonNull IThrowingFunction<@NonNull IAnalysisCounterValueConsumer, @NonNull IAnalysisIdleStateStreamModifierWriter, IOException> idleModifierFactory) {
        this.streamWriter = streamWriter;
        this.idleModifierFactory = idleModifierFactory;
        this.perThreadStream = new TLongObjectHashMap(10, 0.5f, Long.MIN_VALUE);
        this.activeThreadKey = UtidToLong.mapUtid(null);
    }

    @Override
    public void close() throws IOException {
        this.streamWriter.close();
    }

    @Override
    public void consumeIdleEvent(long time, @NonNull IdleState state) throws IOException {
        boolean idle = IAnalysisIdleStateStreamModifierWriter.mapStateToIdleFlag(state);
        this.markIdle(time, this.activeThreadKey, idle);
    }

    @Override
    public void consumeCounterValue(long time, long key, long value) throws IOException {
        if (key != this.activeThreadKey) {
            throw new IllegalStateException();
        }
        IAnalysisIdleStateStreamModifierWriter stream = this.getPerThreadStream(key);
        stream.consumeCounterValue(time, ++this.sequenceCount, value);
    }

    @Override
    public void consumeSchedFree(long timestamp, long key) throws IOException {
        this.markIdle(timestamp, key, true);
    }

    @Override
    public void consumeSchedSwitch(long time, long key) throws IOException {
        this.markIdle(time, this.activeThreadKey, true);
        this.markIdle(time, key, false);
        this.activeThreadKey = key;
    }

    private @NonNull IAnalysisIdleStateStreamModifierWriter getPerThreadStream(long key) throws IOException {
        IAnalysisIdleStateStreamModifierWriter result = (IAnalysisIdleStateStreamModifierWriter)this.perThreadStream.get(key);
        if (result == null) {
            result = (IAnalysisIdleStateStreamModifierWriter)this.idleModifierFactory.apply((Object)this.streamWriter.get(key));
            this.perThreadStream.put(key, (Object)result);
        }
        return result;
    }

    private void markIdle(long timestamp, long key, boolean idle) throws IOException {
        IAnalysisIdleStateStreamModifierWriter stream = this.getPerThreadStream(key);
        stream.consumeIdleEvent(timestamp, ++this.sequenceCount, idle);
    }
}

