/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.counters;

import com.arm.streamline.analysis.database.api.idle.IdleState;
import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisCounterValueConsumer;
import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisDeltaThreadStreamWriter;
import com.arm.streamline.analysis.database.stream.counters.IDatabaseThreadCounterChannelWriter;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class DatabaseSchedDerviedIncidentThreadCounterChannelWriter
implements IDatabaseThreadCounterChannelWriter {
    private long activeThreadKey;
    private long lastActiveThreadKey;
    private long lastThreadSwitchTime;
    private final @NonNull TLongObjectMap<IAnalysisCounterValueConsumer> perThreadStream;
    private long sequenceCount;
    private final @NonNull IAnalysisDeltaThreadStreamWriter streamWriter;

    public DatabaseSchedDerviedIncidentThreadCounterChannelWriter(@NonNull IAnalysisDeltaThreadStreamWriter streamWriter) {
        this.streamWriter = streamWriter;
        this.perThreadStream = new TLongObjectHashMap(10, 0.5f, Long.MIN_VALUE);
        this.activeThreadKey = -1L;
        this.lastActiveThreadKey = -1L;
        this.lastThreadSwitchTime = 0L;
    }

    @Override
    public void close() throws IOException {
        this.streamWriter.close();
    }

    @Override
    public void consumeCounterValue(long time, long key, long value) throws IOException {
        if (key != this.activeThreadKey) {
            throw new IllegalStateException();
        }
        long keyToUse = time > this.lastThreadSwitchTime ? this.activeThreadKey : this.lastActiveThreadKey;
        IAnalysisCounterValueConsumer result = (IAnalysisCounterValueConsumer)this.perThreadStream.get(keyToUse);
        if (result == null) {
            result = this.streamWriter.get(keyToUse);
            this.perThreadStream.put(keyToUse, (Object)result);
        }
        result.consumeCounterValue(time, ++this.sequenceCount, value);
    }

    @Override
    public void consumeIdleEvent(long time, @NonNull IdleState state) throws IOException {
    }

    @Override
    public void consumeSchedFree(long timestamp, long key) throws IOException {
    }

    @Override
    public void consumeSchedSwitch(long time, long key) throws IOException {
        this.lastActiveThreadKey = this.activeThreadKey;
        this.lastThreadSwitchTime = time;
        this.activeThreadKey = key;
    }
}

