/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.counters;

import com.arm.streamline.analysis.database.api.idle.IdleState;
import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisCounterValueConsumer;
import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisDeltaThreadStreamWriter;
import com.arm.streamline.analysis.database.stream.counters.IDatabaseThreadCounterChannelWriter;
import com.arm.streamline.analysis.processing.idle.IAnalysisIdleStateStreamModifierWriter;
import com.arm.utils.function.IThrowingFunction;
import gnu.trove.iterator.TLongLongIterator;
import gnu.trove.map.TLongLongMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongLongHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class DatabaseSchedDerviedDeltaThreadCounterChannelWriter
implements IDatabaseThreadCounterChannelWriter {
    private long activeThreadKey;
    private final @NonNull IThrowingFunction<@NonNull IAnalysisCounterValueConsumer, @NonNull IAnalysisIdleStateStreamModifierWriter, IOException> idleModifierFactory;
    private final @NonNull TLongLongMap lastIdleEventByThread = new TLongLongHashMap(10, 0.5f, Long.MIN_VALUE, 0L);
    private long lastTimestampForDeltaAccumulation;
    private final @NonNull TLongObjectMap<IAnalysisIdleStateStreamModifierWriter> perThreadStream;
    private long sequenceCount;
    private final @NonNull IAnalysisDeltaThreadStreamWriter streamWriter;
    private final @NonNull TLongLongMap timeAccumulationByThread = new TLongLongHashMap(10, 0.5f, Long.MIN_VALUE, 0L);
    private long timeDeltaRunningTotal;
    private long lastTimestampForCounter;
    private boolean inIdle;

    public DatabaseSchedDerviedDeltaThreadCounterChannelWriter(@NonNull IAnalysisDeltaThreadStreamWriter streamWriter, @NonNull IThrowingFunction<@NonNull IAnalysisCounterValueConsumer, @NonNull IAnalysisIdleStateStreamModifierWriter, IOException> idleModifierFactory) throws IOException {
        this.streamWriter = streamWriter;
        this.idleModifierFactory = idleModifierFactory;
        this.perThreadStream = new TLongObjectHashMap(10, 0.5f, Long.MIN_VALUE);
        this.activeThreadKey = -1L;
        this.lastTimestampForDeltaAccumulation = 0L;
        this.lastTimestampForCounter = 0L;
    }

    @Override
    public void close() throws IOException {
        this.streamWriter.close();
    }

    @Override
    public void consumeCounterValue(long time, long key, long value) throws IOException {
        if (key != this.activeThreadKey) {
            throw new IllegalStateException();
        }
        this.updateSwitchAccounting(time, key);
        if (this.timeAccumulationByThread.isEmpty()) {
            IAnalysisIdleStateStreamModifierWriter stream = this.getPerThreadStream(key);
            stream.consumeCounterValue(time, ++this.sequenceCount, value);
        } else {
            assert (this.timeDeltaRunningTotal != 0L);
            long accumulatedTime = 0L;
            long amountBefore = 0L;
            TLongLongIterator it = this.timeAccumulationByThread.iterator();
            while (it.hasNext()) {
                it.advance();
                long targetKey = it.key();
                long targetTime = it.value();
                long nextTime = targetTime + accumulatedTime;
                long amountAfter = nextTime < this.timeDeltaRunningTotal ? (long)((double)nextTime / (double)this.timeDeltaRunningTotal * (double)value) : value;
                long amountToAllocate = amountAfter - amountBefore;
                amountBefore = amountAfter;
                accumulatedTime = nextTime;
                long counterTime = targetKey != key ? this.lastIdleEventByThread.get(targetKey) : time;
                IAnalysisIdleStateStreamModifierWriter stream = this.getPerThreadStream(targetKey);
                stream.consumeCounterValue(counterTime, ++this.sequenceCount, amountToAllocate);
            }
            assert (accumulatedTime == this.timeDeltaRunningTotal);
            assert (amountBefore == value);
        }
        this.lastIdleEventByThread.clear();
        this.lastIdleEventByThread.put(key, time);
        this.timeAccumulationByThread.clear();
        this.timeDeltaRunningTotal = 0L;
        this.lastTimestampForCounter = time;
    }

    @Override
    public void consumeIdleEvent(long time, @NonNull IdleState state) throws IOException {
        boolean idle = IAnalysisIdleStateStreamModifierWriter.mapStateToIdleFlag(state);
        this.markIdle(time, this.activeThreadKey, idle);
        if (idle && !this.inIdle) {
            this.updateSwitchAccounting(time, this.activeThreadKey);
            this.inIdle = true;
        } else if (!idle && this.inIdle) {
            this.lastTimestampForDeltaAccumulation = time;
            this.inIdle = false;
        }
    }

    @Override
    public void consumeSchedFree(long timestamp, long key) throws IOException {
        this.markIdle(timestamp, key, true);
    }

    @Override
    public void consumeSchedSwitch(long time, long key) throws IOException {
        this.markIdle(time, this.activeThreadKey, true);
        this.markIdle(time, key, false);
        this.updateSwitchAccounting(time, this.activeThreadKey);
        this.activeThreadKey = key;
    }

    private @NonNull IAnalysisIdleStateStreamModifierWriter getPerThreadStream(long key) throws IOException {
        IAnalysisIdleStateStreamModifierWriter result = (IAnalysisIdleStateStreamModifierWriter)this.perThreadStream.get(key);
        if (result == null) {
            result = (IAnalysisIdleStateStreamModifierWriter)this.idleModifierFactory.apply((Object)this.streamWriter.get(key));
            this.perThreadStream.put(key, (Object)result);
        }
        return result;
    }

    private void markIdle(long timestamp, long key, boolean idle) throws IOException {
        IAnalysisIdleStateStreamModifierWriter stream = this.getPerThreadStream(key);
        if (this.lastTimestampForCounter > 0L && !this.lastIdleEventByThread.containsKey(key)) {
            stream.consumeCounterValue(this.lastTimestampForCounter, ++this.sequenceCount, 0L);
        }
        this.lastIdleEventByThread.put(key, timestamp);
        stream.consumeIdleEvent(timestamp, ++this.sequenceCount, idle);
    }

    private void updateSwitchAccounting(long time, long key) {
        long delta;
        if (time > this.lastTimestampForDeltaAccumulation && !this.inIdle && (delta = Math.max(time, 0L) - this.lastTimestampForDeltaAccumulation) > 0L) {
            this.timeAccumulationByThread.adjustOrPutValue(key, delta, delta);
            this.timeDeltaRunningTotal += delta;
        }
        this.lastTimestampForDeltaAccumulation = time;
    }
}

