/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.counters;

import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterWriter;
import com.arm.streamline.analysis.database.stream.AbstractDynamicAllocatedChannelWriter;
import com.arm.streamline.analysis.database.stream.counters.DatabaseCounterChannelWriter;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.NullChecking;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseCounterWriter
extends AbstractDynamicAllocatedChannelWriter<IDatabaseHardwareCounterChannelWriter, ProcessingElementReference>
implements IAnalysisHardwareCounterWriter {
    private static final String ATTR_VERSION = "version";
    private static final String TAG_COUNTER = "counter";
    private final @NonNull File dbPath;
    private final @NonNull DeviceType deviceType;

    public static void writeChart(@NonNull File path, @NonNull CounterRecord counter, @NonNull ProcessingElementReference @NonNull [] channels) throws IOException {
        path.mkdirs();
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)new File(path, "counter.xml"));){
            xml.startDocument();
            xml.startTag(TAG_COUNTER);
            xml.addAttribute(ATTR_VERSION, 1);
            counter.setChannelDescriptions(channels);
            counter.write(xml);
            assert (Arrays.stream(channels).allMatch(c -> NullChecking.equalsNullable((Object)c.deviceType, (Object)counter.getDeviceTypeOrDefault())));
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public DatabaseCounterWriter(@NonNull File dbPath, @NonNull DeviceType deviceType) {
        super(ProcessingElementReference.class);
        this.dbPath = dbPath;
        this.deviceType = deviceType;
    }

    DatabaseCounterWriter(@NonNull Map<@NonNull ProcessingElementReference, @NonNull IDatabaseHardwareCounterChannelWriter> channels, @NonNull File dbPath, @NonNull DeviceType deviceType) {
        super(ProcessingElementReference.class, channels);
        this.dbPath = dbPath;
        this.deviceType = deviceType;
    }

    @Override
    public void consumerCounterValue(@NonNull ProcessingElementReference channel, long time, @Nullable IUniqueThreadID utid, long value) throws IOException {
        @NonNull IDatabaseHardwareCounterChannelWriter channelWriter = (IDatabaseHardwareCounterChannelWriter)this.getOrCreateChannel(channel);
        channelWriter.consumeCounterValue(time, utid, value);
    }

    @Override
    protected @NonNull Comparator<@NonNull ProcessingElementReference> comparator() {
        return Comparator.naturalOrder();
    }

    @Override
    protected @NonNull DatabaseCounterChannelWriter createNewChannel(@NonNull ProcessingElementReference peReference) throws IOException {
        return new DatabaseCounterChannelWriter(this.dbPath, peReference.vmUID, peReference.deviceNumber);
    }

    @Override
    protected boolean validChannel(@NonNull ProcessingElementReference peReference) {
        return this.deviceType.equals((Object)peReference.deviceType);
    }

    public static interface IDatabaseHardwareCounterChannelWriter
    extends Closeable {
        public void consumeCounterValue(long var1, @Nullable IUniqueThreadID var3, long var4) throws IOException;
    }
}

