/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.counters;

import com.arm.streamline.analysis.database.stream.UtidToLong;
import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisCounterValueConsumer;
import com.arm.streamline.analysis.database.stream.chunkwriter.IAnalysisDeltaThreadStreamWriter;
import com.arm.streamline.analysis.database.stream.chunkwriter.ThreadStreamWriter;
import com.arm.streamline.analysis.database.stream.counters.DatabaseCounterWriter;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseCounterChannelWriter
implements DatabaseCounterWriter.IDatabaseHardwareCounterChannelWriter {
    private final @NonNull IAnalysisDeltaThreadStreamWriter streamWriter;
    private final long vmUID;
    private long sequenceNo;

    public static @NonNull File makeFile(@NonNull File parentPath, long vmUID, int deviceNumber, boolean index) {
        return new File(parentPath, String.format("%d-%d.%s", vmUID, deviceNumber, index ? "ndx" : "bin"));
    }

    public static @NonNull IAnalysisDeltaThreadStreamWriter makeStreamWriter(@NonNull File parentPath, long vmUID, int deviceNumber) throws IOException {
        return new ThreadStreamWriter(DatabaseCounterChannelWriter.makeFile(parentPath, vmUID, deviceNumber, false), DatabaseCounterChannelWriter.makeFile(parentPath, vmUID, deviceNumber, true));
    }

    public DatabaseCounterChannelWriter(@NonNull File parentPath, long vmUID, int deviceNumber) throws IOException {
        this(vmUID, DatabaseCounterChannelWriter.makeStreamWriter(parentPath, vmUID, deviceNumber));
    }

    DatabaseCounterChannelWriter(long vmUID, @NonNull IAnalysisDeltaThreadStreamWriter streamWriter) {
        this.vmUID = vmUID;
        this.streamWriter = streamWriter;
    }

    @Override
    public void close() throws IOException {
        this.streamWriter.close();
    }

    @Override
    public void consumeCounterValue(long time, @Nullable IUniqueThreadID utid, long value) throws IOException {
        assert (utid == null || utid.getVmUID() == this.vmUID);
        long utidVal = UtidToLong.mapUtid(utid);
        IAnalysisCounterValueConsumer chunkWriter = this.streamWriter.get(utidVal);
        chunkWriter.consumeCounterValue(time, ++this.sequenceNo, value);
    }
}

