/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.cam;

import com.arm.streamline.analysis.database.api.cam.IAnalysisCAMWriter;
import com.arm.streamline.analysis.database.stream.factory.CAMTrack;
import com.arm.streamline.common.utility.io.CompressedOutputStream;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.set.TIntSet;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DatabaseCAMJobEventWriter
implements IAnalysisCAMWriter {
    public static final @NonNull String JOBS_FILE = "db.gz";
    public static final @NonNull String XML_FILE = "view.xml";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_PARENT = "parent";
    protected static final String ATTR_UID = "uid";
    protected static final String ATTR_VMUID = "vm";
    protected static final String TAG_ROOT = "view";
    protected static final String TAG_TRACK = "track";
    private long lastTimestamp;
    private final @NonNull OutputStream outputStream;

    public static void writeState(@NonNull File directory, long vmUID, int viewUID, @Nullable String name, @NonNull TIntObjectMap<CAMTrack> tracks) throws IOException {
        Throwable throwable = null;
        Object var7_7 = null;
        try (XMLGenerator generator = XMLGenerator.create((File)new File(directory, XML_FILE));){
            generator.startDocument();
            generator.startTag(TAG_ROOT);
            generator.addAttribute(ATTR_VMUID, vmUID);
            generator.addAttribute(ATTR_UID, viewUID);
            generator.addAttributeNot(ATTR_NAME, name, null);
            for (CAMTrack track : tracks.valueCollection()) {
                generator.startEmptyTag(TAG_TRACK);
                generator.addAttribute(ATTR_PARENT, track.parentUID);
                generator.addAttribute(ATTR_UID, track.trackUID);
                generator.addAttribute(ATTR_NAME, track.name);
            }
            generator.endTag();
            generator.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public DatabaseCAMJobEventWriter(@NonNull File directory) throws FileNotFoundException, IOException {
        File file = new File(directory, JOBS_FILE);
        ((File)NullChecking.neverNull((Object)file.getParentFile())).mkdirs();
        this.outputStream = (OutputStream)Throwing.closeIfThrows(gos -> new BufferedOutputStream((OutputStream)gos), (Object)((CompressedOutputStream)Throwing.closeIfThrows(fos -> new CompressedOutputStream((OutputStream)fos), (Object)new FileOutputStream(file), (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0]);
    }

    DatabaseCAMJobEventWriter(@NonNull OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    public void consumeCAMJob(int jobUID, long time, String name, int track, long stopTime, int primaryDependency, @Nullable TIntSet dependencies, int color, @NonNull String detailText) throws IOException {
        long delta = time - this.lastTimestamp;
        this.lastTimestamp = time;
        long duration = stopTime - time;
        Compression.packInt((long)jobUID, (OutputStream)this.outputStream);
        Compression.packInt((long)delta, (OutputStream)this.outputStream);
        Compression.packInt((long)track, (OutputStream)this.outputStream);
        Compression.packInt((long)duration, (OutputStream)this.outputStream);
        Compression.packInt((long)color, (OutputStream)this.outputStream);
        Compression.packInt((long)primaryDependency, (OutputStream)this.outputStream);
        if (dependencies != null) {
            Compression.packInt((long)dependencies.size(), (OutputStream)this.outputStream);
            for (int dependency : dependencies) {
                Compression.packInt((long)dependency, (OutputStream)this.outputStream);
            }
        } else {
            Compression.packInt((long)0L, (OutputStream)this.outputStream);
        }
        Compression.writeString((String)name, (OutputStream)this.outputStream);
        Compression.writeString((String)detailText, (OutputStream)this.outputStream);
    }
}

