/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.cam;

import com.arm.streamline.analysis.database.api.cam.IAnalysisCAMReader;
import com.arm.streamline.analysis.database.stream.factory.CAMTrack;
import com.arm.streamline.analysis.database.stream.factory.CAMView;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.NullChecking;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DatabaseCAMJobEventReader
implements IAnalysisCAMReader {
    private final @NonNull InputStream inputStream;
    private long lastTimestamp = 0L;
    private final int viewUID;
    private final long vmUID;

    public static @Nullable CAMView readState(@NonNull File directory) throws IOException {
        CAMView result = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (XMLParser in = XMLParser.create((File)new File(directory, "view.xml"));){
                String tag;
                String marker = in.getMarker();
                while ((tag = in.nextTag(marker)) != null) {
                    if ("view".equals(tag)) {
                        if (result != null) {
                            throw new IOException("Invalid tag " + tag);
                        }
                        long vmUID = in.getLongAttribute("vm");
                        int viewUID = in.getIntegerAttribute("uid");
                        @NonNull String name = (String)NullChecking.neverNullOr((Object)in.getAttribute("name"), (Object)"");
                        result = new CAMView(vmUID, viewUID, name, directory);
                        String innerMarker = in.getMarker();
                        while ((tag = in.nextTag(innerMarker)) != null) {
                            if ("track".equals(tag)) {
                                int parentUID = in.getIntegerAttribute("parent");
                                int trackUID = in.getIntegerAttribute("uid");
                                @NonNull String trackName = (String)NullChecking.neverNull((Object)in.getAttribute("name"));
                                result.tracks.put(trackUID, (Object)new CAMTrack(parentUID, trackUID, trackName));
                                continue;
                            }
                            throw new IOException("Invalid tag " + tag);
                        }
                        continue;
                    }
                    throw new IOException("Invalid tag " + tag);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return result;
    }

    public DatabaseCAMJobEventReader(@NonNull File dataFile, long vmUID, int viewUID) throws IOException {
        this.vmUID = vmUID;
        this.viewUID = viewUID;
        this.inputStream = new BufferedInputStream(new GZIPInputStream(new FileInputStream(dataFile)));
    }

    DatabaseCAMJobEventReader(@NonNull InputStream inputStream, long vmUID, int viewUID) {
        this.inputStream = inputStream;
        this.vmUID = vmUID;
        this.viewUID = viewUID;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public int getViewUID() {
        return this.viewUID;
    }

    @Override
    public long getVmUID() {
        return this.vmUID;
    }

    @Override
    public @Nullable IAnalysisCAMReader.Value read() throws IOException {
        try {
            long timestamp;
            int jobUID = (int)Compression.unpackInt((InputStream)this.inputStream);
            long delta = Compression.unpackInt((InputStream)this.inputStream);
            int track = (int)Compression.unpackInt((InputStream)this.inputStream);
            long duration = Compression.unpackInt((InputStream)this.inputStream);
            int colour = (int)Compression.unpackInt((InputStream)this.inputStream);
            int primaryDependency = (int)Compression.unpackInt((InputStream)this.inputStream);
            int numDependencies = (int)Compression.unpackInt((InputStream)this.inputStream);
            int @NonNull [] dependencies = new int[numDependencies];
            int i = 0;
            while (i < dependencies.length) {
                dependencies[i] = (int)Compression.unpackInt((InputStream)this.inputStream);
                ++i;
            }
            @NonNull String name = Compression.readString((InputStream)this.inputStream);
            @NonNull String detailText = Compression.readString((InputStream)this.inputStream);
            this.lastTimestamp = timestamp = this.lastTimestamp + delta;
            return new IAnalysisCAMReader.Value(duration, jobUID, track, colour, timestamp, primaryDependency, dependencies, name, detailText);
        }
        catch (EOFException e) {
            return null;
        }
    }
}

