/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.annotations;

import com.arm.streamline.analysis.database.api.annotations.AnnotationTextGroupChannelIdentifier;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsPerChannelWriter;
import com.arm.streamline.common.utility.io.CompressedOutputStream;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.streamline.report.model.uids.IUniqueThreadID;
import com.arm.utils.NullChecking;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DatabaseAnnotationPerChannelEventWriter
implements IAnalysisAnnotationsPerChannelWriter {
    public static final int EVENT_BOOKMARK = 0;
    public static final int EVENT_ERROR = 1;
    public static final int EVENT_MAP_IDENTIFIER = 6;
    public static final int EVENT_NAME_CHANNEL = 2;
    public static final int EVENT_NAME_GROUP = 3;
    public static final int EVENT_STRING = 4;
    public static final int EVENT_VISUAL = 5;
    public static final @NonNull String FILE_FORMAT = "%d.db.gz";
    public static final @NonNull Pattern FILE_PATTERN = Pattern.compile("(\\d+)\\.db\\.gz");
    public static final int NO_ENTRY_VALUE = -1;
    private boolean first = true;
    private final @NonNull TObjectIntMap<AnnotationTextGroupChannelIdentifier> identifierMap = new TObjectIntHashMap(10, 0.5f, -1);
    private long lastTimestamp;
    private final @NonNull OutputStream outputStream;
    private final long vmUID;

    public DatabaseAnnotationPerChannelEventWriter(@NonNull File annotationsPath, long vmUID) throws IOException {
        this.vmUID = vmUID;
        File file = new File(annotationsPath, String.format(FILE_FORMAT, vmUID));
        ((File)NullChecking.neverNull((Object)file.getParentFile())).mkdirs();
        this.outputStream = (OutputStream)Throwing.closeIfThrows(gos -> new BufferedOutputStream((OutputStream)gos), (Object)((CompressedOutputStream)Throwing.closeIfThrows(fos -> new CompressedOutputStream((OutputStream)fos), (Object)new FileOutputStream(file), (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0]);
    }

    DatabaseAnnotationPerChannelEventWriter(@NonNull OutputStream outputStream, long vmUID) throws IOException {
        this.vmUID = vmUID;
        this.outputStream = outputStream;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    public void consumeAnnotationError(@NonNull IUniqueThreadID utid, long timestamp, @NonNull String message) throws IOException {
        this.writeHeader(1, utid, timestamp);
        Compression.writeString((String)message, (OutputStream)this.outputStream);
    }

    @Override
    public void consumeAnnotationMarker(@NonNull IUniqueThreadID utid, long timestamp, int colour, @Nullable String message) throws IOException {
        this.writeHeader(0, utid, timestamp);
        Compression.packInt((long)colour, (OutputStream)this.outputStream);
        Compression.writeString((String)message, (OutputStream)this.outputStream);
    }

    @Override
    public void consumeAnnotationNameChannel(@NonNull IUniqueThreadID utid, long timestamp, @NonNull AnnotationTextGroupChannelIdentifier channel, @NonNull AnnotationTextGroupChannelIdentifier group, @NonNull String name) throws IOException {
        if (!utid.equals(group.utid())) {
            throw new IllegalArgumentException();
        }
        if (!group.sameDomainAs(channel)) {
            throw new IllegalArgumentException();
        }
        int groupId = this.map(group, timestamp);
        int channelId = this.map(channel, timestamp);
        this.writeHeader(2, utid, timestamp);
        Compression.packInt((long)channelId, (OutputStream)this.outputStream);
        Compression.packInt((long)groupId, (OutputStream)this.outputStream);
        Compression.writeString((String)name, (OutputStream)this.outputStream);
    }

    @Override
    public void consumeAnnotationNameGroup(@NonNull IUniqueThreadID utid, long timestamp, @NonNull AnnotationTextGroupChannelIdentifier group, @NonNull String name) throws IOException {
        if (!utid.equals(group.utid())) {
            throw new IllegalArgumentException();
        }
        int groupId = this.map(group, timestamp);
        this.writeHeader(3, utid, timestamp);
        Compression.packInt((long)groupId, (OutputStream)this.outputStream);
        Compression.writeString((String)name, (OutputStream)this.outputStream);
    }

    @Override
    public void consumeAnnotationText(@NonNull IUniqueThreadID utid, long timestamp, @NonNull AnnotationTextGroupChannelIdentifier channel, int colour, @NonNull String message) throws IOException {
        if (!utid.equals(channel.utid())) {
            throw new IllegalArgumentException();
        }
        int channelId = this.map(channel, timestamp);
        this.writeHeader(4, utid, timestamp);
        Compression.packInt((long)channelId, (OutputStream)this.outputStream);
        Compression.packInt((long)colour, (OutputStream)this.outputStream);
        Compression.writeString((String)message, (OutputStream)this.outputStream);
    }

    @Override
    public void consumeAnnotationVisual(@NonNull IUniqueThreadID utid, long timestamp, @Nullable String msg, byte @NonNull [] imageData) throws IOException {
        this.writeHeader(5, utid, timestamp);
        Compression.writeString((String)msg, (OutputStream)this.outputStream);
        Compression.packInt((long)imageData.length, (OutputStream)this.outputStream);
        this.outputStream.write(imageData);
    }

    private int map(@NonNull AnnotationTextGroupChannelIdentifier identifier, long timestamp) throws IOException {
        int result = this.identifierMap.get((Object)identifier);
        if (result == -1) {
            result = this.identifierMap.size();
            this.identifierMap.put((Object)identifier, result);
            if (identifier.namespace() == AnnotationTextGroupChannelIdentifier.Namespace.USER) {
                this.writeHeader(6, identifier.utid(), timestamp);
                Compression.packInt((long)result, (OutputStream)this.outputStream);
                Compression.packInt((long)identifier.value(), (OutputStream)this.outputStream);
            }
        }
        return result;
    }

    private void writeHeader(int type, @NonNull IUniqueThreadID utid, long timestamp) throws IOException {
        if (utid.getVmUID() != this.vmUID) {
            throw new IllegalArgumentException();
        }
        assert (this.first || this.lastTimestamp <= timestamp);
        this.first = false;
        long delta = timestamp - this.lastTimestamp;
        this.lastTimestamp = timestamp;
        Compression.packInt((long)type, (OutputStream)this.outputStream);
        Compression.packInt((long)delta, (OutputStream)this.outputStream);
        Compression.packInt((long)utid.getUID(), (OutputStream)this.outputStream);
    }
}

