/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.annotations;

import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsPerChannelReader;
import com.arm.streamline.analysis.model.AnnotationType;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.utils.io.InputStreamUtils;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DatabaseAnnotationPerChannelEventReader
implements IAnalysisAnnotationsPerChannelReader {
    private final @NonNull TIntObjectMap<TIntIntMap> utidToIdentifierMap = new TIntObjectHashMap(10, 0.5f, -1);
    private final @NonNull InputStream inputStream;
    private final long vmUID;
    private long lastTimestamp = 0L;

    public DatabaseAnnotationPerChannelEventReader(@NonNull File dataFile, long vmUID) throws IOException {
        this.inputStream = new BufferedInputStream(new GZIPInputStream(new FileInputStream(dataFile)));
        this.vmUID = vmUID;
    }

    DatabaseAnnotationPerChannelEventReader(@NonNull InputStream inputStream, long vmUID) {
        this.inputStream = inputStream;
        this.vmUID = vmUID;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public @Nullable IAnalysisAnnotationsPerChannelReader.Value read() throws IOException {
        try {
            int type;
            block11: while (true) {
                long timestamp;
                type = (int)Compression.unpackInt((InputStream)this.inputStream);
                long delta = Compression.unpackInt((InputStream)this.inputStream);
                int utid = (int)Compression.unpackInt((InputStream)this.inputStream);
                this.lastTimestamp = timestamp = this.lastTimestamp + delta;
                switch (type) {
                    case 0: {
                        return this.readMarker(timestamp, utid);
                    }
                    case 1: {
                        return this.readError(timestamp, utid);
                    }
                    case 2: {
                        return this.readNameChannel(timestamp, utid);
                    }
                    case 3: {
                        return this.readNameGroup(timestamp, utid);
                    }
                    case 4: {
                        return this.readText(timestamp, utid);
                    }
                    case 5: {
                        return this.readVisual(timestamp, utid);
                    }
                    case 6: {
                        this.readMapIdentifier(utid);
                        continue block11;
                    }
                }
                break;
            }
            throw new AssertionError(type);
        }
        catch (EOFException e) {
            return null;
        }
    }

    private @Nullable Integer getOriginalId(int utid, int mappedId) {
        TIntIntMap identifierMap = (TIntIntMap)this.utidToIdentifierMap.get(utid);
        if (identifierMap == null) {
            return null;
        }
        int result = identifierMap.get(mappedId);
        if (result == -1) {
            return null;
        }
        return result;
    }

    private @Nullable IAnalysisAnnotationsPerChannelReader.Value readError(long timestamp, int utid) throws IOException {
        String message = Compression.readString((InputStream)this.inputStream);
        return new IAnalysisAnnotationsPerChannelReader.Value(this.vmUID, AnnotationType.ERROR, utid, timestamp, 0, null, 0, null, message, 0, null);
    }

    private void readMapIdentifier(int utid) throws IOException {
        TIntIntMap identifierMap = (TIntIntMap)this.utidToIdentifierMap.get(utid);
        if (identifierMap == null) {
            identifierMap = new TIntIntHashMap(10, 0.5f, -1, -1);
            this.utidToIdentifierMap.put(utid, (Object)identifierMap);
        }
        int mappedValue = (int)Compression.unpackInt((InputStream)this.inputStream);
        int originalValue = (int)Compression.unpackInt((InputStream)this.inputStream);
        identifierMap.put(mappedValue, originalValue);
    }

    private @Nullable IAnalysisAnnotationsPerChannelReader.Value readMarker(long timestamp, int utid) throws IOException {
        int colour = (int)Compression.unpackInt((InputStream)this.inputStream);
        String message = Compression.readString((InputStream)this.inputStream);
        return new IAnalysisAnnotationsPerChannelReader.Value(this.vmUID, AnnotationType.BOOKMARK, utid, timestamp, 0, null, 0, null, message, colour, null);
    }

    private @Nullable IAnalysisAnnotationsPerChannelReader.Value readNameChannel(long timestamp, int utid) throws IOException {
        int mappedChannel = (int)Compression.unpackInt((InputStream)this.inputStream);
        int mappedGroup = (int)Compression.unpackInt((InputStream)this.inputStream);
        String name = Compression.readString((InputStream)this.inputStream);
        @Nullable Integer originalGroup = this.getOriginalId(utid, mappedGroup);
        @Nullable Integer originalChannel = this.getOriginalId(utid, mappedChannel);
        return new IAnalysisAnnotationsPerChannelReader.Value(this.vmUID, AnnotationType.CHANNEL_NAME, utid, timestamp, mappedGroup, originalGroup, mappedChannel, originalChannel, name, 0, null);
    }

    private @Nullable IAnalysisAnnotationsPerChannelReader.Value readNameGroup(long timestamp, int utid) throws IOException {
        int mappedGroup = (int)Compression.unpackInt((InputStream)this.inputStream);
        String name = Compression.readString((InputStream)this.inputStream);
        @Nullable Integer originalGroup = this.getOriginalId(utid, mappedGroup);
        return new IAnalysisAnnotationsPerChannelReader.Value(this.vmUID, AnnotationType.GROUP_NAME, utid, timestamp, mappedGroup, originalGroup, 0, null, name, 0, null);
    }

    private @Nullable IAnalysisAnnotationsPerChannelReader.Value readText(long timestamp, int utid) throws IOException {
        int mappedChannel = (int)Compression.unpackInt((InputStream)this.inputStream);
        int colour = (int)Compression.unpackInt((InputStream)this.inputStream);
        String message = Compression.readString((InputStream)this.inputStream);
        @Nullable Integer originalChannel = this.getOriginalId(utid, mappedChannel);
        return new IAnalysisAnnotationsPerChannelReader.Value(this.vmUID, AnnotationType.STRING, utid, timestamp, 0, null, mappedChannel, originalChannel, message, colour, null);
    }

    private @Nullable IAnalysisAnnotationsPerChannelReader.Value readVisual(long timestamp, int utid) throws IOException {
        String message = Compression.readString((InputStream)this.inputStream);
        int length = (int)Compression.unpackInt((InputStream)this.inputStream);
        byte[] data = new byte[length];
        InputStreamUtils.readFully((InputStream)this.inputStream, (byte[])data);
        return new IAnalysisAnnotationsPerChannelReader.Value(this.vmUID, AnnotationType.VISUAL, utid, timestamp, 0, null, 0, null, message, 0, data);
    }
}

