/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.annotations;

import com.arm.streamline.analysis.database.api.IEventReader;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsPerChannelReader;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsReader;
import com.arm.streamline.analysis.database.stream.AbstractEventReader;
import com.arm.streamline.analysis.database.stream.annotations.DatabaseAnnotationPerChannelEventReader;
import com.arm.streamline.analysis.database.stream.annotations.DatabaseAnnotationPerChannelEventWriter;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IThrowingObjLongBiFunction;
import com.arm.utils.function.Throwing;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseAnnotationEventReader
extends AbstractEventReader<IAnalysisAnnotationsPerChannelReader.Value, IAnalysisAnnotationsPerChannelReader.Value, IAnalysisAnnotationsPerChannelReader>
implements IAnalysisAnnotationsReader {
    protected static @NonNull IAnalysisAnnotationsPerChannelReader @NonNull [] createChannelReadersFor(@NonNull File annotationsPath, @NonNull IThrowingObjLongBiFunction<@NonNull File, @NonNull IAnalysisAnnotationsPerChannelReader, IOException> factory) throws IOException {
        @NonNull File @Nullable [] allFiles = annotationsPath.listFiles();
        @NonNull ArrayList<@NonNull IAnalysisAnnotationsPerChannelReader> channelReaders = new ArrayList<IAnalysisAnnotationsPerChannelReader>();
        try {
            if (allFiles != null) {
                File[] fileArray = allFiles;
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    Matcher matcher;
                    File file = fileArray[n2];
                    if (file.isFile() && (matcher = DatabaseAnnotationPerChannelEventWriter.FILE_PATTERN.matcher(file.getName())).matches()) {
                        @NonNull String uidStr = (String)NullChecking.neverNull((Object)matcher.group(1));
                        long vmUID = Long.parseLong(uidStr);
                        channelReaders.add((IAnalysisAnnotationsPerChannelReader)factory.apply((Object)file, vmUID));
                    }
                    ++n2;
                }
            }
            return channelReaders.toArray(new IAnalysisAnnotationsPerChannelReader[channelReaders.size()]);
        }
        catch (Throwable t) {
            Throwing.closeAll((Iterable[])new Iterable[]{channelReaders});
            throw t;
        }
    }

    public DatabaseAnnotationEventReader(@NonNull File annotationsPath) throws IOException {
        this(DatabaseAnnotationEventReader.createChannelReadersFor(annotationsPath, (IThrowingObjLongBiFunction<File, IAnalysisAnnotationsPerChannelReader, IOException>)((IThrowingObjLongBiFunction)DatabaseAnnotationPerChannelEventReader::new)));
    }

    DatabaseAnnotationEventReader(@NonNull IAnalysisAnnotationsPerChannelReader @NonNull [] channelReaders) {
        super((IEventReader[])channelReaders);
    }

    @Override
    protected @NonNull IAnalysisAnnotationsPerChannelReader.Value adaptPerChannelValue(int channelIndex, @NonNull IAnalysisAnnotationsPerChannelReader.Value readValue) throws IOException {
        return readValue;
    }
}

