/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.activity;

import com.arm.streamline.analysis.database.stream.activity.DatabaseActivityPerChannelWriter;
import com.arm.streamline.analysis.database.stream.activity.IAnalysisActivityPerChannelReader;
import com.arm.streamline.common.utility.io.Compression;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DatabaseActivityPerChannelReader
implements IAnalysisActivityPerChannelReader {
    private final @NonNull InputStream inputStream;
    private long lastTimestamp = 0L;

    public DatabaseActivityPerChannelReader(@NonNull File parentPath, long vmUID, int deviceNumber) throws IOException {
        @NonNull File file = DatabaseActivityPerChannelWriter.makeFile(parentPath, vmUID, deviceNumber);
        this.inputStream = file.isFile() ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))) : new ByteArrayInputStream(new byte[0]);
    }

    DatabaseActivityPerChannelReader(@NonNull InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public @Nullable IAnalysisActivityPerChannelReader.IValue read() throws IOException {
        try {
            long timestamp;
            int type = (int)Compression.unpackInt((InputStream)this.inputStream);
            long delta = Compression.unpackInt((InputStream)this.inputStream);
            this.lastTimestamp = timestamp = this.lastTimestamp + delta;
            switch (type) {
                case 0: {
                    return this.readFree(timestamp);
                }
                case 1: {
                    return this.readStop(timestamp);
                }
                case 2: {
                    return this.readSwitch(timestamp, false);
                }
                case 3: {
                    return this.readSwitch(timestamp, true);
                }
            }
            throw new AssertionError(type);
        }
        catch (EOFException e) {
            return null;
        }
    }

    private @Nullable IAnalysisActivityPerChannelReader.IValue readFree(final long timestamp) throws IOException {
        final int utid = (int)Compression.unpackInt((InputStream)this.inputStream);
        return new IAnalysisActivityPerChannelReader.IValue(){

            @Override
            public boolean accept(@NonNull IAnalysisActivityPerChannelReader.IValueVisitor visitor) throws IOException {
                return visitor.free(timestamp, utid);
            }

            @Override
            public long getTimestamp() {
                return timestamp;
            }

            @Override
            public boolean isSwitch() {
                return false;
            }
        };
    }

    private @Nullable IAnalysisActivityPerChannelReader.IValue readStop(final long timestamp) throws IOException {
        final int state = (int)Compression.unpackInt((InputStream)this.inputStream);
        return new IAnalysisActivityPerChannelReader.IValue(){

            @Override
            public boolean accept(@NonNull IAnalysisActivityPerChannelReader.IValueVisitor visitor) throws IOException {
                return visitor.stop(timestamp, state);
            }

            @Override
            public long getTimestamp() {
                return timestamp;
            }

            @Override
            public boolean isSwitch() {
                return false;
            }
        };
    }

    private @Nullable IAnalysisActivityPerChannelReader.IValue readSwitch(final long timestamp, boolean hasUtid) throws IOException {
        Integer utid;
        final int activity = (int)Compression.unpackInt((InputStream)this.inputStream);
        final int state = (int)Compression.unpackInt((InputStream)this.inputStream);
        if (hasUtid) {
            int utidV = (int)Compression.unpackInt((InputStream)this.inputStream);
            utid = utidV;
        } else {
            utid = null;
        }
        return new IAnalysisActivityPerChannelReader.IValue(){

            @Override
            public boolean accept(@NonNull IAnalysisActivityPerChannelReader.IValueVisitor visitor) throws IOException {
                return visitor.swtch(timestamp, utid, activity, state);
            }

            @Override
            public long getTimestamp() {
                return timestamp;
            }

            @Override
            public boolean isSwitch() {
                return true;
            }
        };
    }
}

