/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream.activity;

import com.arm.streamline.analysis.database.api.IEventReader;
import com.arm.streamline.analysis.database.api.activity.IAnalysisActivityReader;
import com.arm.streamline.analysis.database.stream.AbstractEventReader;
import com.arm.streamline.analysis.database.stream.activity.DatabaseActivityPerChannelReader;
import com.arm.streamline.analysis.database.stream.activity.IAnalysisActivityPerChannelReader;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class DatabaseActivityEventReader<T>
extends AbstractEventReader<IAnalysisActivityReader.IValue<T>, IAnalysisActivityPerChannelReader.IValue, IAnalysisActivityPerChannelReader>
implements IAnalysisActivityReader<T> {
    private final @NonNull T @NonNull [] channels;

    private static @NonNull IAnalysisActivityPerChannelReader @NonNull [] createPerChannelReaders(@NonNull File directory, @NonNull ProcessingElementReference @NonNull [] channels) throws IOException {
        @NonNull IAnalysisActivityPerChannelReader @NonNull [] result = new IAnalysisActivityPerChannelReader[channels.length];
        int i = 0;
        while (i < channels.length) {
            result[i] = new DatabaseActivityPerChannelReader(directory, channels[i].vmUID, channels[i].deviceNumber);
            ++i;
        }
        return result;
    }

    public static @NonNull DatabaseActivityEventReader<ProcessingElementReference> create(@NonNull File directory, @NonNull ProcessingElementReference @NonNull [] channels) throws IOException {
        return new DatabaseActivityEventReader<ProcessingElementReference>(channels, DatabaseActivityEventReader.createPerChannelReaders(directory, channels));
    }

    public DatabaseActivityEventReader(@NonNull T @NonNull [] channels, @NonNull IAnalysisActivityPerChannelReader @NonNull [] channelReaders) {
        super((IEventReader[])channelReaders);
        if (channels.length != channelReaders.length) {
            throw new IllegalArgumentException();
        }
        this.channels = channels;
    }

    @Override
    public @NonNull List<@NonNull T> getChannels() {
        return Collections.unmodifiableList(Arrays.asList(this.channels));
    }

    @Override
    protected @NonNull IAnalysisActivityReader.IValue<T> adaptPerChannelValue(final int channelIndex, final @NonNull IAnalysisActivityPerChannelReader.IValue readValue) throws IOException {
        final @NonNull T channel = this.channels[channelIndex];
        return new IAnalysisActivityReader.IValue<T>(){

            @Override
            public boolean accept(final @NonNull IAnalysisActivityReader.IValueVisitor<T> visitor) throws IOException {
                return readValue.accept(new IAnalysisActivityPerChannelReader.IValueVisitor(){

                    @Override
                    public boolean free(long timestamp, int utid) throws IOException {
                        return visitor.free(timestamp, utid);
                    }

                    @Override
                    public boolean stop(long timestamp, int state) throws IOException {
                        return visitor.stop(channel, timestamp, state);
                    }

                    @Override
                    public boolean swtch(long timestamp, @Nullable Integer utid, int activity, int state) throws IOException {
                        return visitor.swtch(channel, timestamp, utid, activity, state);
                    }
                });
            }

            @Override
            public @NonNull T getChannel() {
                return channel;
            }

            @Override
            public int getChannelIndex() {
                return channelIndex;
            }

            @Override
            public long getTimestamp() {
                return readValue.getTimestamp();
            }

            @Override
            public boolean isSwitch() {
                return readValue.isSwitch();
            }
        };
    }
}

