/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.stream;

import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.common.utility.io.Compression;
import com.arm.utils.collections.Pair;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ChannelExecutablePathWriter {
    public static final int BACKTRACE_COOKIE_DEFINE_MAGIC = 1;
    public static final int TYPE_FILE = 0;
    public static final int TYPE_ZIP = 1;
    private final @NonNull TObjectIntMap<Pair<@NonNull String, @Nullable String>> fileOrZipToCookieMap = new TObjectIntHashMap(10, 0.5f, 1);

    public void writeExecutablePath(@Nullable IExecutablePath executablePath, @NonNull OutputStream outputStream) throws IOException {
        if (executablePath == null) {
            Compression.packInt((long)-1L, (OutputStream)outputStream);
        } else {
            switch (executablePath.getType()) {
                case FILE_OR_ZIP: {
                    this.writeFileOrZipExecutablePath(executablePath, outputStream);
                    break;
                }
                case SPECIAL_IDLE: {
                    Compression.packInt((long)-2L, (OutputStream)outputStream);
                    break;
                }
                case SPECIAL_KERNEL: {
                    Compression.packInt((long)-3L, (OutputStream)outputStream);
                    break;
                }
                case SPECIAL_NONE: {
                    Compression.packInt((long)0L, (OutputStream)outputStream);
                    break;
                }
                default: {
                    throw new AssertionError(executablePath);
                }
            }
        }
    }

    private void writeFileOrZipExecutablePath(@NonNull IExecutablePath executablePath, @NonNull OutputStream outputStream) throws IOException {
        String entry;
        String path = executablePath.getFullPath();
        Pair key = new Pair((Object)path, (Object)(entry = executablePath.getEntryPath()));
        int cookie = this.fileOrZipToCookieMap.get((Object)key);
        if (cookie == 1) {
            int newCookie = 1 + this.fileOrZipToCookieMap.size() + 1;
            int type = entry == null ? 0 : 1;
            this.fileOrZipToCookieMap.put((Object)key, newCookie);
            Compression.packInt((long)1L, (OutputStream)outputStream);
            Compression.packInt((long)type, (OutputStream)outputStream);
            Compression.packInt((long)newCookie, (OutputStream)outputStream);
            Compression.writeString((String)path, (OutputStream)outputStream);
            if (entry != null) {
                Compression.writeString((String)entry, (OutputStream)outputStream);
            }
        } else {
            Compression.packInt((long)cookie, (OutputStream)outputStream);
        }
    }
}

