/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.api.profiling;

import com.arm.streamline.analysis.database.api.profiling.IProfileSource;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public interface IProfileEvent {
    public @NonNull InstructionCounterMetadataXml getProfileEventMetadata();

    public @NonNull IProfileSource getSource();

    public static final class SimpleProfileEvent
    implements IProfileEvent {
        private final @NonNull InstructionCounterMetadataXml metadata;
        private final @NonNull IProfileSource source;

        public SimpleProfileEvent(@NonNull IProfileSource source, @NonNull InstructionCounterMetadataXml metadata) {
            this.source = source;
            this.metadata = metadata;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleProfileEvent other = (SimpleProfileEvent)obj;
            return Objects.equals(this.metadata, other.metadata) && Objects.equals(this.source, other.source);
        }

        @Override
        public @NonNull InstructionCounterMetadataXml getProfileEventMetadata() {
            return this.metadata;
        }

        @Override
        public @NonNull IProfileSource getSource() {
            return this.source;
        }

        public int hashCode() {
            return Objects.hash(this.metadata, this.source);
        }

        public String toString() {
            return String.format("SimpleProfileEvent [metadata=%s, source=%s]", this.metadata, this.source);
        }
    }
}

