/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database.api.profiling;

import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.database.api.profiling.IProfileSource;
import com.arm.streamline.analysis.database.stream.profiling.Messages;
import com.arm.streamline.common.model.icounters.InstructionCounterSourceMetadata;
import com.arm.streamline.report.shared.icounter.InstructionCounterMetadataXml;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;

public final class BacktraceSource
implements IBacktraceSource {
    public static final @NonNull InstructionCounterMetadataXml EVENT_METADATA = new InstructionCounterMetadataXml.RatioInstructionCounterMetadata(Messages.BacktraceSource_PC_SAMPLE_TITLE, Messages.BacktraceSource_PC_SAMPLE_DESCRIPTION, "", null, null, Arrays.asList(new InstructionCounterMetadataXml.RatioInstructionCounterDataPoint(0, Messages.BacktraceSource_SAMPLE_DATA_POINT, null)));
    public static final @NonNull InstructionCounterSourceMetadata SOURCE_METADATA = new InstructionCounterSourceMetadata(Messages.BacktraceSource_PERIODIC_SAMPLING_TITLE, Messages.BacktraceSource_PERIODIC_SAMPLING_DESCRIPTION, InstructionCounterSourceMetadata.Type.PERIODIC);
    private final @NonNull String name;
    private final @NonNull IBacktraceSource.Type type;

    public static @NonNull IBacktraceSource ebs(@NonNull String name) {
        return new BacktraceSource(IBacktraceSource.Type.EBS, name);
    }

    private BacktraceSource(@NonNull IBacktraceSource.Type type, @NonNull String name) {
        this.type = type;
        this.name = name;
    }

    BacktraceSource() {
        this(IBacktraceSource.Type.PERIODIC, "Periodic Sampling");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BacktraceSource) {
            BacktraceSource that = (BacktraceSource)obj;
            return this.type == that.type && this.name.equals(that.name);
        }
        return false;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull InstructionCounterMetadataXml getProfileEventMetadata() {
        return EVENT_METADATA;
    }

    @Override
    public @NonNull InstructionCounterSourceMetadata getProfileSourceMetadata() {
        switch (this.type) {
            case EBS: {
                return new InstructionCounterSourceMetadata(this.name, MessageFormat.format(Messages.BacktraceSource_EBS_DESCRIPTION, this.name), InstructionCounterSourceMetadata.Type.EBS);
            }
            case PERIODIC: {
                assert (this == IBacktraceSource.PERIODIC_SAMPLES);
                return SOURCE_METADATA;
            }
        }
        throw new AssertionError((Object)this.type);
    }

    @Override
    public @NonNull IProfileSource getSource() {
        return this;
    }

    @Override
    public @NonNull IBacktraceSource.Type getType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

