/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.analysis.model.topology.CoresFile;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.report.model.pe.ProcessingElementDescriptor;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.model.topology.ICores;
import com.arm.utils.NullChecking;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CoresReaderWriter {
    private static final String ATTR_CPUID = "cpuid";
    private static final String ATTR_DT_NAME = "name";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DEVICE_NUMBER = "pe";
    private static final String ATTR_TOPO_CLUSTER_ID = "cluster";
    private static final String ATTR_TOPO_CORE_ID = "core";
    private static final String ATTR_TOPO_OS_ID = "osid";
    private static final String ATTR_TOPO_THREAD_ID = "thread";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_VMUID = "vm";
    private static final String TAG_CLUSTER = "cluster";
    private static final String TAG_CLUSTERS = "clusters";
    private static final String TAG_CORE = "core";
    private static final String TAG_TOPOLOGY = "topology";

    public static @NonNull ICores read(@NonNull File fullPath, @NonNull ProcessingElementReferenceSet processingElementReferences) throws IOException {
        TIntArrayList cpuIDs;
        ArrayList<ProcessingElementTopology> processingElementTopology;
        ArrayList<ProcessingElementReference> processingElementReference;
        ArrayList<String> uniqueClusterNames;
        ArrayList<String> coreNames;
        block18: {
            coreNames = new ArrayList<String>();
            uniqueClusterNames = new ArrayList<String>();
            processingElementReference = new ArrayList<ProcessingElementReference>();
            processingElementTopology = new ArrayList<ProcessingElementTopology>();
            cpuIDs = new TIntArrayList();
            XMLParser in = null;
            try {
                String tag;
                File coresFile = CommonFileUtils.getFile((File)fullPath);
                if (!coresFile.isFile()) break block18;
                in = XMLParser.create((File)coresFile);
                while ((tag = in.nextTag()) != null) {
                    if (TAG_CLUSTERS.equals(tag)) {
                        String marker = in.getMarker();
                        while ((tag = in.nextTag(marker)) != null) {
                            if ("cluster".equals(tag)) {
                                String clusterName = (String)NullChecking.neverNull((Object)in.getAttribute("name"));
                                String marker2 = in.getMarker();
                                while ((tag = in.nextTag(marker2)) != null) {
                                    if ("core".equals(tag)) {
                                        int index = in.getIntegerAttribute(ATTR_ID, -1);
                                        long vmUID = in.getLongAttribute(ATTR_VMUID, 0L);
                                        int cpuID = in.getIntegerAttribute(ATTR_CPUID, 1048575);
                                        int deviceNumber = in.getIntegerAttribute(ATTR_DEVICE_NUMBER, index);
                                        @Nullable String dtName = in.getAttribute("name");
                                        @NonNull DeviceType deviceType = DeviceType.cpu((String)dtName);
                                        while (coreNames.size() <= index) {
                                            coreNames.add(null);
                                        }
                                        while (processingElementReference.size() <= index) {
                                            processingElementReference.add(null);
                                        }
                                        while (processingElementTopology.size() <= index) {
                                            processingElementTopology.add(null);
                                        }
                                        while (cpuIDs.size() <= index) {
                                            cpuIDs.add(1048575);
                                        }
                                        coreNames.set(index, clusterName);
                                        processingElementReference.set(index, processingElementReferences.get(deviceType, vmUID, deviceNumber));
                                        cpuIDs.set(index, cpuID);
                                        if (!uniqueClusterNames.contains(clusterName)) {
                                            uniqueClusterNames.add(clusterName);
                                        }
                                        String marker3 = in.getMarker();
                                        while ((tag = in.nextTag(marker3)) != null) {
                                            if (TAG_TOPOLOGY.equals(tag)) {
                                                int osID = in.getIntegerAttribute(ATTR_TOPO_OS_ID);
                                                int clusterID = in.getIntegerAttribute("cluster");
                                                int coreID = in.getIntegerAttribute("core");
                                                int threadID = in.getIntegerAttribute(ATTR_TOPO_THREAD_ID);
                                                processingElementTopology.set(index, new ProcessingElementTopology(osID, clusterID, coreID, threadID));
                                                continue;
                                            }
                                            in.skip();
                                        }
                                        continue;
                                    }
                                    in.skip();
                                }
                                continue;
                            }
                            in.skip();
                        }
                        continue;
                    }
                    in.skip();
                }
            }
            finally {
                CommonFileUtils.ignoredClose(in);
            }
        }
        int i = 0;
        while (i < coreNames.size()) {
            if (coreNames.get(i) == null || processingElementReference.get(i) == null) {
                throw new AssertionError();
            }
            ++i;
        }
        return new CoresFile(coreNames, uniqueClusterNames, processingElementReference, processingElementTopology, cpuIDs.toArray());
    }

    public static void write(@NonNull File file, @NonNull ICores coresFile, @NonNull IClustersInfo clustersInfo) throws IOException {
        ArrayList<ProcessingElementReference> processingElementList = new ArrayList<ProcessingElementReference>();
        HashMap<ProcessingElementReference, ProcessingElementDescriptor> processingElementProperties = new HashMap<ProcessingElementReference, ProcessingElementDescriptor>();
        int nCores = coresFile.getNumCores();
        int i = 0;
        while (i < nCores) {
            ProcessingElementReference peRef = coresFile.getProcessingElementReference(i);
            ProcessingElementTopology topo = coresFile.getProcessingElementTopology(i);
            int cpuID = coresFile.getCpuID(i);
            String name = coresFile.getCoreClusterLabel(i);
            processingElementList.add(peRef);
            processingElementProperties.put(peRef, new ProcessingElementDescriptor(cpuID, name, topo));
            ++i;
        }
        CoresReaderWriter.write(file, processingElementList, processingElementProperties, clustersInfo);
    }

    public static void write(@NonNull File file, @NonNull List<@NonNull ProcessingElementReference> processingElementList, @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> processingElementProperties, @NonNull IClustersInfo clusterInfo) throws IOException {
        TIntObjectHashMap clusterToCoresMap = new TIntObjectHashMap();
        int coreId = 0;
        while (coreId < processingElementList.size()) {
            int clusterId = clusterInfo.getClusterIndex(coreId);
            TIntSet set = (TIntSet)clusterToCoresMap.get(clusterId);
            if (set == null) {
                set = new TIntHashSet();
                clusterToCoresMap.put(clusterId, (Object)set);
            }
            set.add(coreId);
            ++coreId;
        }
        Throwable throwable = null;
        Object var6_9 = null;
        try (XMLGenerator xml = XMLGenerator.create((File)file);){
            xml.startDocument();
            xml.startTag(TAG_CLUSTERS);
            xml.addAttribute(ATTR_VERSION, 2);
            TIntObjectIterator it = clusterToCoresMap.iterator();
            while (it.hasNext()) {
                it.advance();
                int clusterId = it.key();
                @NonNull TIntSet set = (TIntSet)NullChecking.neverNull((Object)((TIntSet)it.value()));
                int[] cores = set.toArray();
                Arrays.sort(cores);
                xml.startTag("cluster");
                String clusterName = (String)NullChecking.neverNull((Object)clusterInfo.getClusterName(clusterId));
                String prettyName = (String)NullChecking.neverNullOr((Object)ClusterNameUtils.getPrettyName((String)clusterName), (Object)clusterName);
                xml.addAttribute("name", prettyName);
                int[] nArray = cores;
                int n = cores.length;
                int n2 = 0;
                while (n2 < n) {
                    int core = nArray[n2];
                    @NonNull ProcessingElementReference peReference = processingElementList.get(core);
                    @NonNull ProcessingElementDescriptor record = (ProcessingElementDescriptor)NullChecking.neverNull((Object)processingElementProperties.get(peReference));
                    @Nullable ProcessingElementTopology topology = record.getTopology();
                    assert (peReference.deviceType.isCPU());
                    if (topology != null) {
                        xml.startTag("core");
                    } else {
                        xml.startEmptyTag("core");
                    }
                    xml.addAttribute(ATTR_ID, core);
                    xml.addAttribute(ATTR_CPUID, "0x" + Integer.toHexString(record.getCpuid()));
                    xml.addAttribute(ATTR_VMUID, peReference.vmUID);
                    xml.addAttribute(ATTR_DEVICE_NUMBER, peReference.deviceNumber);
                    xml.addAttributeNot("name", peReference.deviceType.getName(), DeviceType.CPU.getName());
                    if (topology != null) {
                        xml.startEmptyTag(TAG_TOPOLOGY);
                        xml.addAttribute(ATTR_TOPO_OS_ID, topology.osID);
                        xml.addAttribute("cluster", topology.clusterID);
                        xml.addAttribute("core", topology.coreID);
                        xml.addAttribute(ATTR_TOPO_THREAD_ID, topology.threadID);
                        xml.endTag();
                    }
                    ++n2;
                }
                xml.endTag();
            }
            xml.endTag();
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

