/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_astf.viewmodel;

import com.arm.databinding.PropertyOnObservable;
import com.arm.streamline.wizard.import_astf.Messages;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFImportFileModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ASTFAddFileViewModel {
    private final @NonNull ComputedList<@NonNull ASTFImportFileModel> observableAllASTFfiles;
    private final @NonNull WritableList<@NonNull ASTFImportFileModel> observableAddNewFiles;
    private final @NonNull WritableList<@NonNull ASTFImportFileModel> observableSelectedFiles;
    private final @NonNull WritableList<@NonNull ASTFImportFileModel> observableAstfFilesFromDialogList;
    private final @NonNull IObservableValue<@Nullable String> observableTooltipText;
    private final @NonNull WritableValue<@NonNull ASTFFileActions> observableFileActionMode = new WritableValue();
    private final @NonNull WritableValue<@NonNull Boolean> observableValidatePage = new WritableValue((Object)Boolean.FALSE, Boolean.TYPE);
    private @NonNull List<@NonNull ASTFImportFileModel> previousList = new ArrayList<ASTFImportFileModel>();

    public ASTFAddFileViewModel() {
        this.observableAddNewFiles = new WritableList(new ArrayList(), ASTFImportFileModel.class);
        this.observableSelectedFiles = new WritableList(new ArrayList(), ASTFImportFileModel.class);
        this.observableAstfFilesFromDialogList = new WritableList(new ArrayList(), ASTFImportFileModel.class);
        this.observableFileActionMode.setValue((Object)ASTFFileActions.NONE);
        this.observableAllASTFfiles = new ComputedList<ASTFImportFileModel>(){

            protected @NonNull List<@NonNull ASTFImportFileModel> calculate() {
                @NonNull ArrayList<@NonNull ASTFImportFileModel> astfFiles = new ArrayList<ASTFImportFileModel>(ASTFAddFileViewModel.this.previousList);
                switch ((ASTFFileActions)((Object)ASTFAddFileViewModel.this.observableFileActionMode.getValue())) {
                    case ADD: {
                        if (ASTFAddFileViewModel.this.observableAddNewFiles.isEmpty()) break;
                        ASTFAddFileViewModel.this.observableAddNewFiles.stream().forEach(c -> {
                            if (!astfFiles.contains(c)) {
                                astfFiles.add((ASTFImportFileModel)c);
                            }
                        });
                        ASTFAddFileViewModel.this.observableAddNewFiles.clear();
                        break;
                    }
                    case UP: {
                        int indexOf;
                        int indexPrevious;
                        if (ASTFAddFileViewModel.this.observableSelectedFiles.isEmpty() || ASTFAddFileViewModel.this.observableSelectedFiles.size() != 1 || (indexPrevious = (indexOf = astfFiles.indexOf(ASTFAddFileViewModel.this.observableSelectedFiles.get(0))) - 1) < 0) break;
                        Collections.swap(astfFiles, indexPrevious, indexOf);
                        break;
                    }
                    case REMOVE: {
                        if (ASTFAddFileViewModel.this.observableSelectedFiles.isEmpty()) break;
                        ASTFAddFileViewModel.this.observableSelectedFiles.stream().forEach(c -> astfFiles.remove(c));
                        break;
                    }
                    case DOWN: {
                        if (ASTFAddFileViewModel.this.observableSelectedFiles.isEmpty() || ASTFAddFileViewModel.this.observableSelectedFiles.size() != 1) break;
                        int indexOf = astfFiles.indexOf(ASTFAddFileViewModel.this.observableSelectedFiles.get(0));
                        int indexNext = indexOf + 1;
                        if (indexOf < 0 || indexNext >= astfFiles.size()) break;
                        Collections.swap(astfFiles, indexNext, indexOf);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value: " + String.valueOf(ASTFAddFileViewModel.this.observableFileActionMode));
                    }
                }
                ASTFAddFileViewModel.this.previousList = astfFiles.stream().collect(Collectors.toList());
                ASTFAddFileViewModel.this.observableFileActionMode.setValue((Object)ASTFFileActions.NONE);
                ASTFAddFileViewModel.this.observableValidatePage.setValue((Object)(astfFiles.size() > 0 ? Boolean.TRUE : Boolean.FALSE));
                return astfFiles;
            }
        };
        this.observableTooltipText = ComputedValue.create(() -> this.observableAllASTFfiles.isEmpty() ? Messages.ImportASTF_AstfFilesToolTip : null);
    }

    public @NonNull ComputedList<@NonNull ASTFImportFileModel> getPropertyAllItems() {
        return this.observableAllASTFfiles;
    }

    public @NonNull IObservableValue<@Nullable String> getPropertyTooltipText() {
        return this.observableTooltipText;
    }

    public @NonNull WritableList<@NonNull ASTFImportFileModel> getPropertyNewFilesAdded() {
        return this.observableAddNewFiles;
    }

    public static @NonNull IValueProperty<@NonNull ASTFImportFileModel, @NonNull String> getFileInputProperty() {
        return new PropertyOnObservable<ASTFImportFileModel, String>(String.class){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected @NonNull IObservableValue<@NonNull String> getObservable(@NonNull ASTFImportFileModel source) {
                @NonNull WritableValue writableValue = new WritableValue();
                writableValue.setValue((Object)source.getFileName());
                return writableValue;
            }
        };
    }

    public @NonNull WritableList<@NonNull ASTFImportFileModel> getPropertySelectedASTFFiles() {
        return this.observableSelectedFiles;
    }

    public @NonNull IObservableValue<@NonNull ASTFFileActions> getASTFFileActionMode() {
        return this.observableFileActionMode;
    }

    public @NonNull ValidationStatusProvider getValidationStatusProvider() {
        return new MultiValidator(){

            protected IStatus validate() {
                if (!((Boolean)ASTFAddFileViewModel.this.observableValidatePage.getValue()).booleanValue()) {
                    return ValidationStatus.error((String)Messages.ImportASTF_AtleastOne_ASTF_file);
                }
                return ValidationStatus.ok();
            }
        };
    }

    public @NonNull IObservableValue<@NonNull Boolean> canEnableRemoveButton() {
        return ComputedValue.create(() -> !this.observableSelectedFiles.isEmpty());
    }

    public @NonNull IObservableValue<@NonNull Boolean> canEnableUpDownButton() {
        return ComputedValue.create(() -> !this.observableSelectedFiles.isEmpty() && this.observableSelectedFiles.size() == 1);
    }

    public @NonNull WritableList<@NonNull ASTFImportFileModel> getAstfFilesFromDialogList() {
        return this.observableAstfFilesFromDialogList;
    }

    public void addFilesFromDialog(@NonNull List<@NonNull ASTFImportFileModel> astfFiles) {
        HashSet<ASTFImportFileModel> uniqueListOfFiles = new HashSet<ASTFImportFileModel>(astfFiles);
        this.observableAstfFilesFromDialogList.clear();
        this.observableAstfFilesFromDialogList.addAll(0, uniqueListOfFiles);
    }

    public void setFileActionMode(@NonNull ASTFFileActions mode) {
        this.observableFileActionMode.setValue((Object)mode);
    }

    public static enum ASTFFileActions {
        ADD,
        REMOVE,
        UP,
        DOWN,
        NONE;

    }
}

