/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.wizard.import_astf;

import com.arm.streamline.wizard.import_astf.Messages;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFAddFileViewModel;
import com.arm.streamline.wizard.import_astf.viewmodel.ASTFImportFileModel;
import com.arm.utils.NullChecking;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public final class ASTFAddFileWizardPage
extends WizardPage {
    private TableViewer astfFilesTableViewer;
    private Button addAstfFileBtn;
    private Button removeAstfFileBtn;
    private Button moveUpAstfFileBtn;
    private Button moveDownAstfFileBtn;
    private FileDialog openFiles;
    private static final @NonNull String ASTF_EXTN_FILTER = "*.astf";
    private @NonNull ASTFAddFileViewModel viewModel;

    public ASTFAddFileWizardPage(@NonNull ASTFAddFileViewModel viewModel, int currentPageNumber, int totalPages) {
        super("", MessageFormat.format(Messages.ImportASTFWizard_Add_ASTF_Title, currentPageNumber, totalPages), null);
        this.setDescription(Messages.ImportASTFWizard_Description);
        this.viewModel = viewModel;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createASTFFilesLists(composite);
        this.createButtonGroup(composite);
        this.createFileDialog();
        this.initDataBindings();
    }

    private void createFileDialog() {
        this.openFiles = new FileDialog(Display.getCurrent().getActiveShell(), 4098);
        this.openFiles.setFilterExtensions(new String[]{ASTF_EXTN_FILTER});
    }

    private void createButtonGroup(@NonNull Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).applyTo(buttonComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)buttonComposite);
        this.addAstfFileBtn = new Button(buttonComposite, 8);
        this.addAstfFileBtn.setText(Messages.ImportASTFFile_Add_Button);
        this.addAstfFileBtn.setToolTipText(Messages.ImportASTFFile_Add_Button_tooltip);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.addAstfFileBtn);
        this.removeAstfFileBtn = new Button(buttonComposite, 8);
        this.removeAstfFileBtn.setText(Messages.ImportASTFFile_Remove_Button);
        this.removeAstfFileBtn.setToolTipText(Messages.ImportASTFFile_Remove_Button_tooltip);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.removeAstfFileBtn);
        Label label = new Label(buttonComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        this.moveUpAstfFileBtn = new Button(buttonComposite, 8);
        this.moveUpAstfFileBtn.setText(Messages.ImportASTFFile_Up_Button);
        this.moveUpAstfFileBtn.setToolTipText(Messages.ImportASTFFile_Up_Button_tooltip);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.moveUpAstfFileBtn);
        this.moveDownAstfFileBtn = new Button(buttonComposite, 8);
        this.moveDownAstfFileBtn.setText(Messages.ImportASTFFile_Down_Button);
        this.moveDownAstfFileBtn.setToolTipText(Messages.ImportASTFFile_Down_Button_tooltip);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.moveDownAstfFileBtn);
    }

    private void createASTFFilesLists(@NonNull Composite composite) {
        Composite fileListComposite = new Composite(composite, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).applyTo(fileListComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fileListComposite);
        this.astfFilesTableViewer = new TableViewer(fileListComposite, 2818);
        assert (this.astfFilesTableViewer != null);
        GridDataFactory.fillDefaults().grab(true, true).hint(400, 300).applyTo((Control)this.astfFilesTableViewer.getTable());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.astfFilesTableViewer, (int)1);
    }

    private void initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider observableListContentProvider = new ObservableListContentProvider();
        this.astfFilesTableViewer.setContentProvider((IContentProvider)observableListContentProvider);
        IValueProperty<ASTFImportFileModel, String> valueProperty = ASTFAddFileViewModel.getFileInputProperty();
        ViewerSupport.bind((StructuredViewer)this.astfFilesTableViewer, this.viewModel.getPropertyAllItems(), valueProperty);
        IViewerObservableList observeMutipleSelection = ViewerProperties.multipleSelection().observe((Viewer)this.astfFilesTableViewer);
        bindingContext.bindList((IObservableList)observeMutipleSelection, this.viewModel.getPropertySelectedASTFFiles(), null, null);
        bindingContext.bindList(this.viewModel.getPropertyNewFilesAdded(), this.viewModel.getAstfFilesFromDialogList());
        bindingContext.addValidationStatusProvider(this.viewModel.getValidationStatusProvider());
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)bindingContext);
        ISWTObservableValue observeRemoveButtonEnable = WidgetProperties.enabled().observe((Widget)NullChecking.neverNull((Object)this.removeAstfFileBtn));
        bindingContext.bindValue((IObservableValue)observeRemoveButtonEnable, this.viewModel.canEnableRemoveButton());
        ISWTObservableValue observeUpButtonEnable = WidgetProperties.enabled().observe((Widget)NullChecking.neverNull((Object)this.moveUpAstfFileBtn));
        bindingContext.bindValue((IObservableValue)observeUpButtonEnable, this.viewModel.canEnableUpDownButton());
        ISWTObservableValue observeDownButtonEnable = WidgetProperties.enabled().observe((Widget)NullChecking.neverNull((Object)this.moveDownAstfFileBtn));
        bindingContext.bindValue((IObservableValue)observeDownButtonEnable, this.viewModel.canEnableUpDownButton());
        this.addAstfFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ASTFAddFileWizardPage.this.openFiles.open() != null) {
                    String[] fileNames = ASTFAddFileWizardPage.this.openFiles.getFileNames();
                    String filterPath = ASTFAddFileWizardPage.this.openFiles.getFilterPath();
                    @NonNull ArrayList<@NonNull ASTFImportFileModel> astfFiles = new ArrayList<ASTFImportFileModel>();
                    String[] stringArray = fileNames;
                    int n = fileNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String astf = stringArray[n2];
                        File astfFile = new File(filterPath, astf);
                        if (astfFile.isFile()) {
                            astfFiles.add(new ASTFImportFileModel(astfFile));
                        }
                        ++n2;
                    }
                    if (!astfFiles.isEmpty()) {
                        ASTFAddFileWizardPage.this.viewModel.addFilesFromDialog(astfFiles);
                    }
                }
                ASTFAddFileWizardPage.this.viewModel.setFileActionMode(ASTFAddFileViewModel.ASTFFileActions.ADD);
            }
        });
        this.removeAstfFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASTFAddFileWizardPage.this.viewModel.setFileActionMode(ASTFAddFileViewModel.ASTFFileActions.REMOVE);
            }
        });
        this.moveUpAstfFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASTFAddFileWizardPage.this.viewModel.setFileActionMode(ASTFAddFileViewModel.ASTFFileActions.UP);
            }
        });
        this.moveDownAstfFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ASTFAddFileWizardPage.this.viewModel.setFileActionMode(ASTFAddFileViewModel.ASTFFileActions.DOWN);
            }
        });
    }
}

