/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.selection;

import com.arm.streamline.widget.selection.IStdSelectionOwner;
import com.arm.streamline.widget.selection.ReadOnlyStdSelection;
import java.util.BitSet;

public class StdSelection
extends ReadOnlyStdSelection {
    public static final int MOUSE_NONE = 0;
    public static final int MOUSE_EXTEND = 1;
    public static final int MOUSE_FLIP = 2;
    private int mAnchor;
    private boolean mNotify;

    public StdSelection(IStdSelectionOwner owner) {
        super(owner);
        this.mAnchor = -1;
        this.mNotify = true;
    }

    public StdSelection(IStdSelectionOwner owner, int size) {
        super(owner, size);
        this.mAnchor = -1;
        this.mNotify = true;
    }

    public StdSelection(StdSelection other) {
        super(other);
        this.mAnchor = other.mAnchor;
        this.mNotify = other.mNotify;
    }

    public boolean canNotify() {
        return this.mNotify;
    }

    public boolean canSelectAll() {
        return this.mSize != this.getCount();
    }

    public void deselect() {
        if (!this.isEmpty()) {
            this.selectionAboutToChange();
            this.mSelection.clear();
            this.mAnchor = -1;
            this.selectionDidChange();
        }
    }

    public void deselect(int index) {
        if (this.mSelection.get(index)) {
            this.selectionAboutToChange();
            this.mSelection.clear(index);
            if (this.mAnchor == index) {
                this.mAnchor = this.firstSelectedIndex();
            }
            this.selectionDidChange();
        }
    }

    public void deselect(int fromIndex, int toIndex) {
        BitSet newSel = (BitSet)this.mSelection.clone();
        if (fromIndex > toIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        newSel.clear(fromIndex, toIndex + 1);
        if (this.mAnchor >= fromIndex && this.mAnchor <= toIndex) {
            int index = newSel.nextSetBit(0);
            this.mAnchor = index < this.mSize ? index : -1;
        }
        this.applySelectionChange(newSel);
    }

    public void deselect(int[] indexes) {
        BitSet newSel = (BitSet)this.mSelection.clone();
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            newSel.clear(element);
            if (this.mAnchor == element) {
                this.mAnchor = -1;
            }
            ++n2;
        }
        if (this.mAnchor == -1) {
            int index = newSel.nextSetBit(0);
            this.mAnchor = index < this.mSize ? index : -1;
        }
        this.applySelectionChange(newSel);
    }

    public int getAnchor() {
        return this.mAnchor;
    }

    @Override
    public IStdSelectionOwner getOwner() {
        return (IStdSelectionOwner)super.getOwner();
    }

    public void select() {
        if (this.mSize > 0 && this.canSelectAll()) {
            this.selectionAboutToChange();
            this.mSelection.set(0, this.mSize);
            this.mAnchor = 0;
            this.selectionDidChange();
        }
    }

    public void select(int index, boolean add) {
        int last;
        BitSet newSel = (BitSet)this.mSelection.clone();
        if (!add) {
            newSel.clear();
        }
        int n = last = (last = newSel.length() - 1) < this.mSize ? last : -1;
        if (last == -1) {
            int n2 = this.mAnchor = index < 0 || index >= this.mSize ? -1 : index;
        }
        if (index >= 0 && index < this.mSize) {
            newSel.set(index);
        }
        this.applySelectionChange(newSel);
    }

    public void select(int fromIndex, int toIndex, boolean add) {
        int index;
        BitSet newSel = (BitSet)this.mSelection.clone();
        if (!add) {
            newSel.clear();
        }
        int n = index = (index = newSel.length() - 1) < this.mSize ? index : -1;
        if (index == -1) {
            int n2 = this.mAnchor = fromIndex < 0 || fromIndex >= this.mSize ? -1 : fromIndex;
        }
        if (fromIndex > toIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex < this.mSize) {
            if (toIndex >= this.mSize) {
                toIndex = this.mSize - 1;
            }
            newSel.set(fromIndex, toIndex + 1);
        }
        this.applySelectionChange(newSel);
    }

    public void select(int[] indexes, boolean add) {
        int index;
        BitSet newSel = (BitSet)this.mSelection.clone();
        if (!add) {
            newSel.clear();
        }
        int n = index = (index = newSel.length() - 1) < this.mSize ? index : -1;
        if (index == -1) {
            this.mAnchor = indexes.length > 0 ? ((index = indexes[0]) < 0 || index >= this.mSize ? -1 : index) : -1;
        }
        int[] nArray = indexes;
        int n2 = indexes.length;
        int n3 = 0;
        while (n3 < n2) {
            int element = nArray[n3];
            index = element;
            if (index > -1 && index < this.mSize) {
                newSel.set(index);
            }
            ++n3;
        }
        this.applySelectionChange(newSel);
    }

    public void select(ReadOnlyStdSelection selection) {
        BitSet newSel = (BitSet)selection.mSelection.clone();
        this.mAnchor = Math.min(newSel.nextSetBit(0), this.mSize);
        this.applySelectionChange(newSel);
    }

    public int selectByMouse(int index, int method) {
        return this.selectByMouse(index, method, false);
    }

    public int selectByMouse(int index, int method, boolean selectOnMouseUpWithSingleOK) {
        if (index != -1) {
            if (this.mAnchor >= 0 && (method & 1) == 1) {
                this.select(this.mAnchor, index, true);
            } else if ((method & 2) == 2) {
                if (this.isSelected(index)) {
                    this.deselect(index);
                } else {
                    this.select(index, true);
                    this.mAnchor = index;
                }
            } else if (!this.isSelected(index)) {
                this.select(index, false);
            } else if (selectOnMouseUpWithSingleOK || this.getCount() != 1) {
                return index;
            }
        } else {
            this.deselect();
        }
        return -1;
    }

    public int selectDown(boolean extend, boolean wrap) {
        int index = -1;
        if (this.mSize > 0) {
            int count = this.getCount();
            if (extend && count > 0) {
                index = this.firstSelectedIndex();
                if (index < this.mAnchor) {
                    this.deselect(index++);
                } else {
                    index = this.lastSelectedIndex() + 1;
                    if (index < this.mSize) {
                        this.select(index, true);
                    }
                }
            } else {
                if (count == 0) {
                    index = 0;
                } else {
                    index = this.lastSelectedIndex();
                    if (count == 1 && ++index >= this.mSize) {
                        int n = index = wrap ? 0 : -1;
                    }
                }
                if (index >= 0 && index < this.mSize) {
                    this.select(index, false);
                }
            }
        }
        return index < 0 || index >= this.mSize ? -1 : index;
    }

    public int selectToEnd(boolean extend) {
        if (this.mSize > 0) {
            if (extend && !this.isEmpty()) {
                if (this.mAnchor < 0) {
                    this.mAnchor = this.firstSelectedIndex();
                }
                this.select(this.mAnchor, this.mSize - 1, true);
            } else {
                this.select(this.mSize - 1, false);
            }
            return this.mSize - 1;
        }
        return -1;
    }

    public int selectToHome(boolean extend) {
        if (this.mSize > 0) {
            if (extend && !this.isEmpty()) {
                if (this.mAnchor < 0) {
                    this.mAnchor = this.lastSelectedIndex();
                }
                this.select(0, this.mAnchor, true);
            } else {
                this.select(0, false);
            }
            return 0;
        }
        return -1;
    }

    public int selectToPageDown(int pageSize, boolean extend) {
        if (this.mSize > 0) {
            int base;
            boolean notEmpty;
            boolean bl = notEmpty = !this.isEmpty();
            if (notEmpty) {
                if (this.mAnchor < 0) {
                    this.mAnchor = this.firstSelectedIndex();
                }
                base = Math.min(this.mSelection.nextClearBit(this.mAnchor), this.mSize - 1);
            } else {
                base = Math.max(this.mAnchor, 0);
            }
            int target = Math.min(base + pageSize, this.mSize - 1);
            if (extend && notEmpty) {
                this.select(base, target, true);
            } else {
                this.select(target, false);
            }
            return target;
        }
        return -1;
    }

    public int selectToPageUp(int pageSize, boolean extend) {
        if (this.mSize > 0) {
            int base;
            boolean notEmpty;
            boolean bl = notEmpty = !this.isEmpty();
            if (notEmpty) {
                if (this.mAnchor < 0) {
                    this.mAnchor = this.lastSelectedIndex();
                }
                base = Math.max(this.mAnchor, 0);
                while (base > 0 && this.mSelection.get(base)) {
                    --base;
                }
            } else {
                base = this.mAnchor < 0 ? this.mSize - 1 : this.mAnchor;
            }
            int target = Math.max(base - pageSize, 0);
            if (extend && notEmpty) {
                this.select(base, target, true);
            } else {
                this.select(target, false);
            }
            return target;
        }
        return -1;
    }

    public int selectUp(boolean extend, boolean wrap) {
        int index = -1;
        if (this.mSize > 0) {
            int count = this.getCount();
            if (extend && count > 0) {
                index = this.lastSelectedIndex();
                if (index > this.mAnchor) {
                    this.deselect(index--);
                } else {
                    index = this.firstSelectedIndex() - 1;
                    if (index >= 0) {
                        this.select(index, true);
                    }
                }
            } else {
                if (count == 0) {
                    index = this.mSize - 1;
                } else {
                    index = this.firstSelectedIndex();
                    if (count == 1 && --index < 0) {
                        int n = index = wrap ? this.mSize - 1 : -1;
                    }
                }
                if (index >= 0 && index < this.mSize) {
                    this.select(index, false);
                }
            }
        }
        return index < 0 || index >= this.mSize ? -1 : index;
    }

    public void setAnchor(int index) {
        this.mAnchor = index < 0 || index >= this.mSize ? -1 : index;
    }

    public void setNotify(boolean notify) {
        this.mNotify = notify;
    }

    public void setSize(int size) {
        int lastPlusOne = this.mSelection.length();
        if (size < 0) {
            size = 0;
        }
        if (lastPlusOne >= size) {
            this.mSelection.clear(size, lastPlusOne);
        }
        this.mSize = size;
        if (this.mAnchor >= this.mSize) {
            this.mAnchor = this.firstSelectedIndex();
        }
    }

    private void applySelectionChange(BitSet newSel) {
        if (!newSel.equals(this.mSelection)) {
            this.selectionAboutToChange();
            this.mSelection = newSel;
            this.selectionDidChange();
        }
    }

    private void selectionAboutToChange() {
        if (this.mNotify) {
            this.getOwner().selectionAboutToChange();
        }
    }

    private void selectionDidChange() {
        if (this.mNotify) {
            this.getOwner().selectionDidChange();
        }
    }
}

