/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.selection;

import com.arm.streamline.widget.selection.IReadOnlyStdSelectionOwner;
import com.arm.streamline.widget.selection.ReadOnlyStdSelectionIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ReadOnlyStdSelection
implements IStructuredSelection {
    protected BitSet mSelection;
    protected int mSize;
    private IReadOnlyStdSelectionOwner mOwner;

    public ReadOnlyStdSelection(ReadOnlyStdSelection other) {
        this.mOwner = other.mOwner;
        this.mSelection = (BitSet)other.mSelection.clone();
        this.mSize = other.mSize;
    }

    protected ReadOnlyStdSelection(IReadOnlyStdSelectionOwner owner) {
        this.mOwner = owner;
        this.mSelection = new BitSet();
    }

    protected ReadOnlyStdSelection(IReadOnlyStdSelectionOwner owner, int size) {
        this(owner);
        this.mSize = size;
    }

    public int firstSelectedIndex() {
        return this.nextSelectedIndex(0);
    }

    public int getCount() {
        if (this.mSelection.length() > this.mSize) {
            this.mSelection = this.mSelection.get(0, this.mSize);
        }
        return this.mSelection.cardinality();
    }

    public int getCountOfSelectedIndexesAfter(int afterIndex) {
        int count = 0;
        int index = afterIndex;
        while ((index = this.nextSelectedIndex(index + 1)) != -1) {
            ++count;
        }
        return count;
    }

    public int getCountOfSelectedIndexesBefore(int beforeIndex) {
        int count = 0;
        int index = -1;
        while ((index = this.nextSelectedIndex(index + 1)) != -1 && index < beforeIndex) {
            ++count;
        }
        return count;
    }

    public Object getFirstElement() {
        int index = this.firstSelectedIndex();
        if (index < 0) {
            return null;
        }
        return this.getObjectAtIndex(index);
    }

    public Object getObjectAtIndex(int index) {
        return this.mOwner.getSelectableObjectAtIndex(index);
    }

    public IReadOnlyStdSelectionOwner getOwner() {
        return this.mOwner;
    }

    public int[] getSelectedIndexes() {
        int[] array = new int[this.getCount()];
        int i = 0;
        int index = this.firstSelectedIndex();
        while (index != -1) {
            array[i++] = index;
            index = this.nextSelectedIndex(index + 1);
        }
        return array;
    }

    public int getSize() {
        return this.mSize;
    }

    public boolean isEmpty() {
        return this.lastSelectedIndex() == -1;
    }

    public boolean isSelected(int index) {
        if (index < 0 || index >= this.mSize) {
            return false;
        }
        return this.mSelection.get(index);
    }

    public Iterator<Object> iterator() {
        return new ReadOnlyStdSelectionIterator(this);
    }

    public int lastSelectedIndex() {
        int index = this.mSelection.length() - 1;
        return index < this.mSize ? index : -1;
    }

    public int nextSelectedIndex(int fromIndex) {
        int index = this.mSelection.nextSetBit(fromIndex);
        return index < this.mSize ? index : -1;
    }

    public int size() {
        return this.getCount();
    }

    public Object[] toArray() {
        return this.toList().toArray();
    }

    public List<?> toList() {
        ArrayList<Object> list = new ArrayList<Object>();
        int index = this.firstSelectedIndex();
        while (index != -1) {
            Object obj = this.getObjectAtIndex(index);
            if (obj != null) {
                list.add(obj);
            }
            index = this.nextSelectedIndex(index + 1);
        }
        return list;
    }
}

