/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.BoxCell;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.Row;
import java.util.function.IntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class HistogramCell<C extends Column<C>>
implements ICell<C> {
    private final @NonNull IHistogramCellDataProvider<C> dataProvider;

    public static void drawBarsAndText(boolean scaleByGlobalLimit, GC gc, Rectangle bounds, @NonNull IntFunction<@Nullable IHistogramData> dataProvider, boolean selected, boolean active, @Nullable Integer rgb) {
        Color baseColor;
        Color color;
        if (rgb == null) {
            color = Colors.getDarkMagenta();
            baseColor = Colors.getWhite();
        } else {
            color = Colors.create(rgb);
            baseColor = Colors.isDark(color) ? Colors.getWhite() : Colors.getDarkGray();
        }
        BoxCell.drawBorderAround(bounds, innerBounds -> {
            int textWidth;
            String text;
            Font font = Fonts.getNormal();
            gc.setFont(font);
            gc.setForeground(color);
            FontInfo fi = FontInfo.get(font);
            int left = innerBounds.x;
            int top = innerBounds.y;
            int textTop = innerBounds.y + (innerBounds.height - fi.getHeight()) / 2;
            int barHeight = innerBounds.height - 1;
            int boxWidth = innerBounds.width;
            Color binDivisionColor = Colors.getGray();
            Color outlineColor = Colors.getDarkGray();
            @Nullable IHistogramData data = (IHistogramData)dataProvider.apply(boxWidth);
            if (data == null) {
                return;
            }
            int binCount = data.getBinCount();
            double maxValue = scaleByGlobalLimit ? 1.0 : data.getMaxValue();
            int lastX = left;
            int lastY = -1;
            int offset = 0;
            int bin = 0;
            while (bin < binCount) {
                int width = data.getBinWidth(bin);
                int binOffset = Math.max(offset, data.getBinOffset(bin));
                double binValue = data.getBinValue(bin);
                double scaledBinValue = binValue / maxValue;
                int thisHeight = (int)(scaledBinValue * (double)barHeight);
                int thisTop = top + barHeight - thisHeight;
                int x = left + offset;
                int w = Math.min(width, boxWidth - offset);
                int nextX = x + w;
                if (w > 0) {
                    gc.setForeground(binDivisionColor);
                    gc.drawLine(nextX, top, nextX, top + barHeight);
                    gc.setForeground(outlineColor);
                    if (scaleByGlobalLimit) {
                        gc.setBackground(color);
                    } else {
                        double q = Math.log1p(binValue) / Math.log1p(1.0);
                        gc.setBackground(Colors.blend(baseColor, color, (int)(q * 100.0)));
                    }
                    gc.fillRectangle(x, thisTop + 1, w, thisHeight);
                    if (!scaleByGlobalLimit) {
                        int dY;
                        if (lastY < 0) {
                            lastY = top + barHeight + 1;
                        }
                        if ((dY = thisTop - lastY) > 0) {
                            gc.drawLine(lastX, lastY, lastX, thisTop);
                            gc.drawLine(lastX, thisTop, nextX, thisTop);
                        } else if (dY < 0) {
                            gc.drawLine(lastX - 1, lastY, lastX - 1, thisTop);
                            gc.drawLine(lastX - 1, thisTop, nextX, thisTop);
                        } else {
                            assert (lastY == thisTop);
                            gc.drawLine(lastX - 1, lastY, nextX, thisTop);
                        }
                        lastX = nextX;
                        lastY = thisTop;
                    }
                    offset = Math.max(binOffset, offset + width);
                }
                ++bin;
            }
            if (binCount > 0 && !scaleByGlobalLimit) {
                gc.drawLine(lastX, lastY, left + boxWidth, top + barHeight);
            }
            if ((text = data.getText()) != null && boxWidth >= (textWidth = fi.getWidth(text))) {
                int textHorizontalCenter = left + boxWidth / 2;
                gc.setForeground(Colors.getText(selected && active));
                TextDrawing.drawString(gc, text, textHorizontalCenter, textTop, 0x1000000);
            }
        });
    }

    private static @NonNull Rectangle getBoxBounds(Rectangle bounds) {
        return new Rectangle(bounds.x + 4, bounds.y + 2, bounds.width - 8, bounds.height - 4);
    }

    public HistogramCell(@NonNull IHistogramCellDataProvider<C> dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public int compare(C column, Row<C> one, Row<C> two) {
        return this.dataProvider.compare(column, one, two);
    }

    @Override
    public void drawCell(GC gc, Rectangle bounds, Row<C> row, C column, boolean selected, boolean active) {
        HistogramCell.drawBarsAndText(this.dataProvider.shouldScaleRelativeToLimit(), gc, bounds, maxBins -> this.dataProvider.get((Column)column, (Row<Column>)row, maxBins), selected, active, this.dataProvider.getColor(column, row));
    }

    @Override
    public int getMinimumContentWidth() {
        return 0;
    }

    @Override
    public Point getPreferredSize(Row<C> row, C column) {
        Font font = Fonts.getNormal();
        Point size = FontInfo.get(font).getExtent("100");
        size.x += 8;
        size.y += 4;
        return size;
    }

    @Override
    public String getToolTipText(Outline<C> outline, Point where, Row<C> row, C column) {
        IHistogramData data;
        @NonNull Rectangle bounds = HistogramCell.getBoxBounds(outline.getCellBounds(row, column));
        if (bounds.width > 0 && bounds.contains(where) && (data = this.dataProvider.get(column, row, bounds.width)) != null) {
            int binCount = data.getBinCount();
            int offset = 0;
            int bin = 0;
            while (bin < binCount) {
                if ((offset += data.getBinWidth(bin)) > where.x - bounds.x) {
                    return data.getLabelForBin(bin);
                }
                ++bin;
            }
        }
        return this.dataProvider.getTooltip(column, row);
    }

    public static interface IHistogramCellDataProvider<C extends Column<C>> {
        public int compare(C var1, Row<C> var2, Row<C> var3);

        public @Nullable IHistogramData get(C var1, Row<C> var2, int var3);

        public @Nullable Integer getColor(C var1, Row<C> var2);

        public @Nullable String getTooltip(C var1, Row<C> var2);

        public boolean shouldScaleRelativeToLimit();
    }

    public static interface IHistogramData {
        public int getBinCount();

        public int getBinOffset(int var1);

        public double getBinValue(int var1);

        public int getBinWidth(int var1);

        public @NonNull String getLabelForBin(int var1);

        public double getMaxValue();

        public @Nullable String getText();
    }
}

