/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.outline;

import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuContributor;
import com.arm.streamline.widget.contextmenu.IContextMenuSelectionResolver;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineMessages;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import com.arm.utils.text.BasicNumberUtils;
import com.arm.utils.text.SWTLabelFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;

public class Header<C extends Column<C>>
extends Canvas
implements IContextMenuSelectionResolver,
IContextMenuContributor,
ControlListener,
PaintListener,
MouseListener,
MouseMoveListener,
MouseTrackListener {
    private static final String ID_PARENT_COLUMN = "PARENT_COLUMN_";
    private static final String ID_SHOW_COLUMN = "SHOW_COLUMN_";
    private static final String ID_SHOW_ALL_COLUMNS = "SHOW_ALL_COLUMNS";
    private static final String ID_RESET_COLUMNS = "RESET_COLUMNS";
    private @Nullable Outline<C> mOwner;
    private @Nullable C mSortColumn;
    private int mResizeColumn = -1;
    private int mResizeColumnBaseline;
    private int mResizeColumnSize;

    public Header(Composite parent) {
        super(parent, 0x20000000);
        ControlHacks.setBackground((Control)this, Colors.getWidgetBackground());
        this.addPaintListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        new ContextMenu((Control)this).add(this);
    }

    @Override
    public void cleanup(ContextMenu cm) {
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        @Nullable Outline<C> mOwner = this.mOwner;
        Point size = new Point(wHint, hHint);
        if (mOwner != null && (wHint == -1 || hHint == -1)) {
            size.y = 0;
            for (Column col : mOwner.getModel().getColumns()) {
                if (!col.isVisible()) continue;
                int width = col.getWidth();
                if (width == -1) {
                    width = col.getPreferredWidth(mOwner);
                    col.setWidth(width);
                }
                if ((width = col.getPreferredHeaderSize().y) <= size.y) continue;
                size.y = width;
            }
            size.y += 2;
            size.x = mOwner.getClientArea().width;
        }
        return size;
    }

    public void controlMoved(ControlEvent event) {
    }

    public void controlResized(ControlEvent event) {
        SafeUpdate.pack((Composite)this);
    }

    public Rectangle getColumnBounds(@NonNull C column) {
        @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
        Rectangle bounds = this.getClientArea();
        bounds.x = mOwner.fromVirtual((Point)new Point((int)mOwner.getColumnStart(column), (int)0)).x;
        bounds.width = mOwner.getColumnWidth(column);
        return bounds;
    }

    public @Nullable Outline<C> getOwner() {
        return this.mOwner;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public @NonNull ISelection getSelection(Control control, Point where) {
        return new StructuredSelection((Object)this);
    }

    @Override
    public void handleCommand(ContextMenu cm, MenuItem menuItem, String menuID, String commandID) {
        Object column;
        @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
        if (ID_SHOW_ALL_COLUMNS.equals(commandID)) {
            for (Column column2 : mOwner.getModel().getColumns()) {
                if (column2.isHiddenFromUi()) continue;
                column2.setVisible(true);
            }
            mOwner.lazyAdjust();
        } else if (ID_RESET_COLUMNS.equals(commandID)) {
            mOwner.applyConfig(mOwner.getDefaultConfig(), false, true);
            mOwner.lazyAdjust();
        } else if (commandID.startsWith(ID_SHOW_COLUMN) && (column = mOwner.getModel().getColumnWithID(BasicNumberUtils.getNonLocalizedInteger((String)commandID.substring(ID_SHOW_COLUMN.length()), (int)0))) != null) {
            ((Column)column).setVisible(!((Column)column).isVisible());
            mOwner.lazyAdjust();
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
        if (this.mResizeColumn != -1) {
            @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
            @NonNull Column column = (Column)mOwner.getModel().getColumns().get(this.mResizeColumn);
            int maxWidth = column.getMaxWidth();
            column.setNoMaxWidth();
            column.setPreferredWidth(column.getDefaultPreferredWidth());
            column.setWidth(column.getPreferredWidth(mOwner));
            column.setMaxWidth(maxWidth);
            mOwner.adjustScrollBarsForContent();
            mOwner.redrawAll();
        }
    }

    public void mouseDown(MouseEvent event) {
        if (event.button == 1) {
            @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
            int x = mOwner.toVirtual((Point)new Point((int)event.x, (int)event.y)).x;
            this.mResizeColumn = mOwner.overColumnDivider(x);
            if (this.mResizeColumn != -1) {
                this.mResizeColumnBaseline = x;
                this.mResizeColumnSize = mOwner.getColumnWidth((Column)mOwner.getModel().getColumns().get(this.mResizeColumn));
            } else {
                this.mSortColumn = null;
                @Nullable C column = mOwner.overColumn(x);
                if (column != null && ((Column)column).getHeaderCell().isSortAllowed()) {
                    this.mSortColumn = column;
                }
            }
        }
    }

    public void mouseEnter(MouseEvent event) {
        this.mouseMove(event);
    }

    public void mouseExit(MouseEvent event) {
    }

    public void mouseHover(MouseEvent event) {
    }

    public void mouseMove(MouseEvent event) {
        Object column;
        Point point = new Point(event.x, event.y);
        @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
        int x = mOwner.toVirtual((Point)point).x;
        if (this.mResizeColumn != -1 || mOwner.overColumnDivider(x) != -1) {
            this.setCursor(this.getDisplay().getSystemCursor(9));
            if (this.mResizeColumn != -1) {
                int size = Math.max(this.mResizeColumnSize + x - this.mResizeColumnBaseline, 10);
                column = (Column)mOwner.getModel().getColumns().get(this.mResizeColumn);
                ((Column)column).setPreferredWidth(size);
                ((Column)column).setWidth(size);
                mOwner.adjustScrollBarsForContent();
                mOwner.redrawAll();
            }
        } else if (this.mSortColumn == null) {
            this.setCursor(this.getDisplay().getSystemCursor(0));
        }
        String tip = null;
        column = mOwner.overColumn(x);
        if (column != null) {
            tip = ((Column)column).getHeaderCell().getToolTipText(mOwner, point, null, column);
        }
        String oldTip = this.getToolTipText();
        if (tip == null ? oldTip != null : !tip.equals(oldTip)) {
            this.setToolTipText(SWTLabelFilter.filterForToolTip((String)tip));
        }
    }

    public void mouseUp(MouseEvent event) {
        if (event.button == 1) {
            this.mResizeColumn = -1;
            @Nullable C mSortColumn = this.mSortColumn;
            if (mSortColumn != null) {
                @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
                if (mSortColumn == mOwner.overColumn(mOwner.toVirtual((Point)new Point((int)event.x, (int)event.y)).x)) {
                    boolean sortAscending = ((Column)mSortColumn).isSortAscending();
                    if (((Column)mSortColumn).getSortSequence() != -1) {
                        sortAscending = !sortAscending;
                    }
                    mOwner.setSort(mSortColumn, sortAscending, (event.stateMask & 0x20000) != 0);
                }
                this.mSortColumn = null;
            }
        }
    }

    public void paintControl(PaintEvent event) {
        @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
        Rectangle bounds = this.getClientArea();
        Color dividerColor = Colors.getDivider();
        int left = event.x;
        int right = left + event.width;
        int bottom = bounds.y + bounds.height - 1;
        int origWidth = bounds.width;
        Point offset = mOwner.toVirtual(new Point(0, 0));
        GC gc = event.gc;
        bounds.x = -offset.x;
        --bounds.height;
        for (Column col : mOwner.getModel().getColumns()) {
            if (!col.isVisible()) continue;
            bounds.width = mOwner.getColumnWidth(col);
            if (bounds.x <= right && bounds.x + bounds.width >= left) {
                ++bounds.y;
                col.drawHeaderCell(gc, bounds);
                --bounds.y;
            }
            bounds.x += bounds.width;
            gc.setForeground(dividerColor);
            gc.drawLine(bounds.x, bounds.y, bounds.x, bottom);
            ++bounds.x;
        }
        gc.setForeground(dividerColor);
        gc.drawLine(0, bottom, origWidth, bottom);
    }

    @Override
    public void prepareMenu(ContextMenu cm) {
        assert (cm != null);
        @NonNull Outline mOwner = (Outline)NullChecking.neverNull(this.mOwner);
        OutlineModel model = mOwner.getModel();
        int count = model.getVisibleColumnCount();
        List<@NonNull C> columns = model.getColumns();
        Set<@NonNull T> parentColumns = StreamUtils.filterOutNull(columns.stream().map(Column::getHierarchicalParentColumn)).collect(Collectors.toSet());
        HashMap<@NonNull K, @NonNull V> allMenus = new HashMap();
        for (Column column : columns) {
            this.prepareMenu(cm, column, allMenus, count, parentColumns::contains);
        }
        cm.createSeparator();
        cm.createMenuItem(this, OutlineMessages.SHOW_ALL_COLUMNS, ID_SHOW_ALL_COLUMNS, count != model.getColumnCount());
        cm.createMenuItem(this, OutlineMessages.RESET_COLUMNS, ID_RESET_COLUMNS, !mOwner.getConfig().equals(mOwner.getDefaultConfig()));
    }

    private void prepareMenu(@NonNull ContextMenu cm, @NonNull C column, @NonNull Map<@NonNull C, @NonNull MenuItem> allMenus, int count, @NonNull Predicate<@NonNull C> isParent) {
        if (allMenus.containsKey(column)) {
            return;
        }
        if (!((Column)column).isHiddenFromUi()) {
            boolean primary = ((Column)column).isPrimary();
            boolean visible = ((Column)column).isVisible();
            boolean enabled = !primary && (!visible || count != 1);
            @Nullable C parentColumn = ((Column)column).getHierarchicalParentColumn();
            if (parentColumn != null) {
                this.prepareMenu(cm, parentColumn, allMenus, count, isParent);
            }
            MenuItem parentMenu = parentColumn != null ? allMenus.get(parentColumn) : null;
            boolean parent = isParent.test(column);
            if (parent && count > 1) {
                MenuItem m;
                if (parentMenu != null) {
                    assert (parentColumn != null);
                    m = cm.createCascadeMenu(((Column)column).getSanitizedName(), ID_PARENT_COLUMN + ((Column)parentColumn).getID(), ID_PARENT_COLUMN + ((Column)column).getID(), true);
                } else {
                    m = cm.createCascadeMenu(((Column)column).getSanitizedName(), ID_PARENT_COLUMN + ((Column)column).getID(), true);
                }
                allMenus.put(column, m);
                cm.createCascadeMenuItem(this, ID_PARENT_COLUMN + ((Column)column).getID(), ((Column)column).getSanitizedName(), ID_SHOW_COLUMN + ((Column)column).getID(), enabled, visible);
            } else if (parentMenu != null) {
                assert (parentColumn != null);
                cm.createCascadeMenuItem(this, ID_PARENT_COLUMN + ((Column)parentColumn).getID(), ((Column)column).getSanitizedName(), ID_SHOW_COLUMN + ((Column)column).getID(), enabled, visible);
            } else {
                cm.createMenuItem((IContextMenuContributor)this, ((Column)column).getSanitizedName(), ID_SHOW_COLUMN + ((Column)column).getID(), !((Column)column).isPrimary() && (!visible || count != 1), visible);
            }
        }
    }

    public void setOwner(@Nullable Outline<C> outline) {
        @Nullable Outline<C> mOwner = this.mOwner;
        if (mOwner != outline) {
            if (mOwner != null) {
                mOwner.removeControlListener(this);
            }
            this.mOwner = outline;
            if (outline != null) {
                outline.addControlListener(this);
                SafeUpdate.pack((Composite)this);
            }
        }
    }
}

