/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight.outline;

import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineModel;
import java.util.ArrayList;
import java.util.List;

public class BlockOutlineSortState {
    private int mId;
    private int mSequence;
    private boolean mAscending;

    public static List<BlockOutlineSortState> captureCurrentSortState(BlockOutlineModel model) {
        ArrayList<BlockOutlineSortState> list = new ArrayList<BlockOutlineSortState>();
        for (BlockColumn column : model.getColumns()) {
            int sequence = column.getSortSequence();
            if (sequence == -1) continue;
            list.add(new BlockOutlineSortState(column.getID(), sequence, column.isSortAscending()));
        }
        return list;
    }

    public static void restoreSortState(BlockOutlineModel model, List<BlockOutlineSortState> state) {
        for (BlockColumn column : model.getColumns()) {
            int id = column.getID();
            int sequence = -1;
            boolean ascending = true;
            for (BlockOutlineSortState one : state) {
                if (one.mId != id) continue;
                sequence = one.mSequence;
                ascending = one.mAscending;
                break;
            }
            column.setSortCriteria(sequence, ascending);
        }
        model.sort(true);
    }

    private BlockOutlineSortState(int id, int sequence, boolean ascending) {
        this.mId = id;
        this.mSequence = sequence;
        this.mAscending = ascending;
    }
}

