/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight.outline;

import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockOutline;
import com.arm.streamline.widget.lightweight.outline.BlockOutlineModel;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import com.arm.streamline.widget.lightweight.outline.BlockTextCell;
import com.arm.streamline.widget.lightweight.outline.IBlockColumnCompareType;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class BlockHeaderCell
extends BlockTextCell {
    public static final int SORTER_WIDTH = 12;
    private BlockOutlineModel mModel;
    private int mMinimumContentWidth;
    private int mSortSequence = -1;
    private boolean mSortAscending = true;
    private boolean mAllowSort = true;
    private boolean mDisplaySort = true;

    public BlockHeaderCell() {
        super(0x1000000, 1024, IBlockColumnCompareType.TEXT);
    }

    @Override
    public void drawCell(GC gc, Rectangle bounds, BlockRow row, BlockColumn column, boolean selected, boolean active) {
        if (this.mAllowSort && this.mDisplaySort) {
            bounds.height -= 2;
            if (this.mSortSequence != -1) {
                bounds.width -= 16;
            }
            super.drawCell(gc, bounds, row, column, selected, active);
            if (this.mSortSequence != -1) {
                int i;
                bounds.width += 16;
                gc.setForeground(Colors.getDarkBlue());
                int x = bounds.x + bounds.width - 4;
                int y = bounds.y + bounds.height - 1;
                if (this.shouldDisplaySequenceMarker()) {
                    i = 0;
                    while (i <= this.mSortSequence) {
                        gc.drawLine(x - (1 + i * 3), y, x - i * 3, y);
                        ++i;
                    }
                }
                x -= 6;
                y = bounds.y + bounds.height / 2 - 1;
                i = 0;
                while (i < 5) {
                    int x1 = this.mSortAscending ? x - i : x + i - 4;
                    int x2 = this.mSortAscending ? x + i : x + 4 - i;
                    gc.drawLine(x1, y + i, x2, y + i);
                    ++i;
                }
            }
            bounds.height += 2;
        } else {
            super.drawCell(gc, bounds, row, column, selected, active);
        }
    }

    @Override
    public int getMinimumContentWidth() {
        return this.mMinimumContentWidth;
    }

    @Override
    public Point getPreferredSize(GC gc, BlockRow row, BlockColumn column) {
        Point size = super.getPreferredSize(gc, row, column);
        if (this.mAllowSort && this.mDisplaySort) {
            size.x += 16;
            size.y += 2;
        }
        if (this.mMinimumContentWidth > size.x) {
            size.x = this.mMinimumContentWidth;
        }
        return size;
    }

    public int getSortSequence() {
        return this.mSortSequence;
    }

    @Override
    public String getToolTipText(BlockOutline outline, BlockRow row, BlockColumn column) {
        return column.getToolTipText();
    }

    public boolean isSortAllowed() {
        return this.mAllowSort;
    }

    public boolean isSortAscending() {
        return this.mSortAscending;
    }

    public boolean isSortDisplayAllowed() {
        return this.mAllowSort && this.mDisplaySort;
    }

    public void setAllowSort(boolean allow) {
        if (allow != this.mAllowSort) {
            this.mAllowSort = allow;
            if (!this.mAllowSort) {
                this.mSortSequence = -1;
            }
        }
    }

    public void setDisplaySort(boolean display) {
        this.mDisplaySort = display;
    }

    public void setMinimumContentWidth(int width) {
        this.mMinimumContentWidth = width;
    }

    public void setOutlineModel(BlockOutlineModel model) {
        this.mModel = model;
    }

    public void setSortCriteria(int sequence, boolean ascending) {
        if (this.mAllowSort) {
            this.mSortSequence = sequence;
            this.mSortAscending = ascending;
        }
    }

    private boolean shouldDisplaySequenceMarker() {
        if (this.mSortSequence > 0 || this.mModel == null) {
            return true;
        }
        if (this.mSortSequence == 0) {
            for (BlockColumn column : this.mModel.getColumns()) {
                if (column.getSortSequence() <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

