/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight.outline;

import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.outline.BlockColumn;
import com.arm.streamline.widget.lightweight.outline.BlockOutline;
import com.arm.streamline.widget.lightweight.outline.BlockRow;
import org.eclipse.swt.graphics.Rectangle;

public abstract class BlockCellEditor {
    private BlockOutline mOutline;
    private BlockRow mRow;
    private BlockColumn mColumn;
    private Block mControl;

    public BlockCellEditor(BlockOutline outline, BlockRow row, BlockColumn column) {
        this.mOutline = outline;
        this.mRow = row;
        this.mColumn = column;
    }

    public void adjustToOutline() {
        this.getControl().setBounds(this.getExpectedBounds());
    }

    public abstract void commit(boolean var1);

    public abstract Block createControl();

    public void dispose() {
    }

    public BlockColumn getColumn() {
        return this.mColumn;
    }

    public final Block getControl() {
        if (this.mControl == null) {
            this.mControl = this.createControl();
        }
        return this.mControl;
    }

    public Rectangle getExpectedBounds() {
        return this.mOutline.getCellBounds(this.mRow, this.mColumn);
    }

    public BlockOutline getOutline() {
        return this.mOutline;
    }

    public BlockRow getRow() {
        return this.mRow;
    }
}

