/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.utility.text.TextDrawingState;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockComposite;
import com.arm.streamline.widget.lightweight.BlockImageButton;
import com.arm.streamline.widget.lightweight.IBlockContentProposalProvider;
import com.arm.streamline.widget.lightweight.IBlockLayout;
import com.arm.streamline.widget.lightweight.LightweightMessages;
import com.arm.utils.Platform;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.ActionFactory;

public class BlockTextField
extends Block
implements IBlockLayout,
Runnable,
SelectionListener {
    private static final long BLINK_RATE = 560L;
    private static final int IMAGE_MARGIN = 1;
    private static final int H_MARGIN = 4;
    private static final int V_MARGIN = 1;
    private StringBuilder mBuffer = new StringBuilder();
    private TextLayout mTextLayout;
    private int mSelectionStart;
    private int mSelectionEnd;
    private int mSelectionAnchor;
    private boolean mExtendByWord;
    private Font mFont = Fonts.getNormal();
    private boolean mHasBorder = true;
    private BlockImageButton mImageButton;
    private Set<IClickListener> mClickListeners = new HashSet<IClickListener>();
    private Set<IFieldModifiedListener> mFieldModifiedListeners = new HashSet<IFieldModifiedListener>();
    private String mWatermark;
    private Color mForegroundColor = Colors.getListForeground();
    protected boolean mNotify = true;
    private boolean mShowCursor;
    private long mForceShowUntil;
    private IBlockContentProposalProvider mProposalProvider;
    private int mScrollOffset;
    private boolean mAllowAutoScrollDuringResize;
    private boolean mMultiLine;
    private int mWrapWidth;

    public BlockTextField() {
        this.setFocusable(true);
        this.setLayout(this);
        this.setBackgroundColor(Colors.getListBackground());
    }

    public BlockTextField(Image image) {
        this();
        this.mImageButton = new BlockImageButton(image);
        this.mImageButton.addClickListener((BlockImageButton button) -> {
            IClickListener[] listeners;
            BlockTextField blockTextField = this;
            synchronized (blockTextField) {
                listeners = this.mClickListeners.toArray(new IClickListener[this.mClickListeners.size()]);
            }
            IClickListener[] iClickListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IClickListener listener = iClickListenerArray[n2];
                listener.buttonClicked(this);
                ++n2;
            }
        });
    }

    public BlockTextField(String text) {
        this();
        this.setText(text);
        this.mScrollOffset = 0;
    }

    public BlockTextField(String text, Image image) {
        this(image);
        this.setText(text);
        this.mScrollOffset = 0;
    }

    public final synchronized void addClickListener(IClickListener listener) {
        this.mClickListeners.add(listener);
    }

    public final synchronized void addFieldModifiedListener(IFieldModifiedListener listener) {
        this.mFieldModifiedListeners.add(listener);
    }

    public final void copy() {
        if (this.hasSelectionRange()) {
            Clipboard clipboard = new Clipboard(this.getDisplay());
            clipboard.setContents(new Object[]{this.getSelectionText()}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
        }
    }

    public final void cut() {
        if (this.hasSelectionRange()) {
            this.copy();
            this.mBuffer.delete(this.mSelectionStart, this.mSelectionEnd);
            this.disposeTextLayout();
            this.setSelection(this.mSelectionStart, this.mSelectionStart);
            this.notifyOfModification();
        }
    }

    public final void deleteSelection() {
        if (this.hasSelectionRange()) {
            this.mBuffer.delete(this.mSelectionStart, this.mSelectionEnd);
            this.disposeTextLayout();
            this.setSelection(this.mSelectionStart);
            this.notifyOfModification();
        }
    }

    @Override
    public final void focusGained(boolean fromKeyboard) {
        super.focusGained(fromKeyboard);
        this.mShowCursor = true;
        this.scheduleBlink();
        if (fromKeyboard) {
            this.scrollIntoView();
            this.autoScroll();
        }
    }

    public final void forceScrollToBeginning() {
        if (this.mScrollOffset != 0) {
            this.mScrollOffset = 0;
            this.repaint();
        }
    }

    public final Point fromSelectionIndex(int selectionIndex) {
        Rectangle bounds = this.getLocalBounds();
        int x = bounds.x + 4 + this.mScrollOffset;
        if (this.mHasBorder) {
            ++x;
        }
        this.prepareTextLayout();
        int top = bounds.y;
        int height = bounds.height;
        if (this.mHasBorder) {
            ++top;
            height -= 2;
        }
        ++top;
        top += ((height -= 2) - this.mTextLayout.getBounds().height) / 2;
        if (selectionIndex > 0) {
            int length = this.mBuffer.length();
            if (selectionIndex > length) {
                selectionIndex = length;
            }
            this.prepareTextLayout();
            Point where = this.mTextLayout.getLocation(selectionIndex, false);
            where.x += x;
            where.y += top;
            return where;
        }
        return new Point(x, top);
    }

    @Override
    public final IBlockContentProposalProvider getContentProposalProvider() {
        return this.mProposalProvider;
    }

    @Override
    public final String getContentsForProposal() {
        return this.getText();
    }

    @Override
    public final int getCursorPositionForProposal() {
        return this.mSelectionStart;
    }

    @Override
    public final Point getCursorRangeForProposal() {
        return new Point(this.mSelectionStart, this.mSelectionEnd);
    }

    @Override
    public final Rectangle getFocusArea() {
        return this.getLocalBounds();
    }

    public final Font getFont() {
        return this.mFont;
    }

    public final Color getForegroundColor() {
        return this.mForegroundColor;
    }

    public final String getImageToolTip() {
        return this.mImageButton != null ? this.mImageButton.getToolTip() : null;
    }

    @Override
    public final Rectangle getInsertionBoundsForProposal() {
        IContentProposal[] proposals = this.mProposalProvider.getProposals(this.getContentsForProposal(), this.getCursorPositionForProposal());
        if (proposals != null) {
            int width = 0;
            FontInfo fi = FontInfo.get(JFaceResources.getDialogFont());
            IContentProposal[] iContentProposalArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                IContentProposal proposal = iContentProposalArray[n2];
                Point extent = fi.getExtent(proposal.getLabel());
                if (width < extent.x) {
                    width = extent.x;
                }
                ++n2;
            }
            if ((width += 26) < 300) {
                width = 300;
            }
            Point where = this.fromSelectionIndex(this.mSelectionStart);
            Rectangle bounds = this.getLocalBounds();
            bounds.x = where.x - width / 2;
            bounds.y += where.y + this.getLineHeightForOffset(this.mSelectionStart);
            bounds.width = width;
            bounds.height = 200;
            return this.toRoot(bounds);
        }
        return null;
    }

    @Override
    public final Point getMinimumSize(Block target, int widthHint, int heightHint) {
        return this.getSize(true);
    }

    @Override
    public final Point getPreferredSize(Block target, int widthHint, int heightHint) {
        return this.getSize(false);
    }

    public final Point getSelection() {
        return new Point(this.mSelectionStart, this.mSelectionEnd);
    }

    public final int getSelectionCount() {
        return this.mSelectionEnd - this.mSelectionStart;
    }

    public final String getSelectionText() {
        return this.mBuffer.substring(this.mSelectionStart, this.mSelectionEnd);
    }

    public final @NonNull String getText() {
        return this.mBuffer.toString();
    }

    @Override
    public final String getToolTip(Point where) {
        if (this.hasFocus() && this.mProposalProvider != null) {
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
            Rectangle bounds = fieldDecoration.getImage().getBounds();
            bounds.x = this.getX() + this.getWidth() - bounds.width - 1;
            ++bounds.y;
            if (this.mHasBorder) {
                --bounds.x;
                ++bounds.y;
            }
            if (bounds.contains(where)) {
                return String.format(LightweightMessages.CONTENT_PROPOSAL, fieldDecoration.getDescription(), KeyStroke.getInstance((int)262144, (int)32));
            }
        }
        return super.getToolTip(where);
    }

    public final String getWatermark() {
        return this.mWatermark;
    }

    public boolean handleCommand(String command) {
        if (this.hasFocus()) {
            if (command.equals(ActionFactory.SELECT_ALL.getId())) {
                this.selectAll();
                return true;
            }
            if (command.equals(ActionFactory.CUT.getId())) {
                this.cut();
                return true;
            }
            if (command.equals(ActionFactory.COPY.getId())) {
                this.copy();
                return true;
            }
            if (command.equals(ActionFactory.PASTE.getId())) {
                this.paste();
                return true;
            }
        }
        return false;
    }

    public final boolean hasBorder() {
        return this.mHasBorder;
    }

    public final boolean hasSelectionRange() {
        return this.mSelectionStart < this.mSelectionEnd;
    }

    @Override
    public final void insertProposalContents(String contents, int cursorPosition) {
        int[] range = this.mProposalProvider.findRange(this.getText(), this.mSelectionStart, this.mSelectionEnd);
        this.mBuffer.replace(range[0], range[1], contents);
        this.disposeTextLayout();
        this.setSelection(range[0] + contents.length());
        this.repaint();
        this.notifyOfModification();
    }

    public final boolean isMultiLine() {
        return this.mMultiLine;
    }

    @Override
    public final void layout(Block target) {
        if (this.mImageButton != null) {
            Rectangle bounds = this.getLocalBounds();
            Point imgSize = this.mImageButton.getPreferredSize(-1, -1);
            this.mImageButton.setBounds(bounds.x + bounds.width - (imgSize.x + 1 + (this.mHasBorder ? 1 : 0)), bounds.y + (bounds.height - imgSize.y) / 2, imgSize.x, imgSize.y);
        }
    }

    @Override
    public final boolean obeyCommand(CommandAction action) {
        String command = action.getCommand();
        if (ActionFactory.CUT.getId().equals(command)) {
            this.cut();
            return true;
        }
        if (ActionFactory.COPY.getId().equals(command)) {
            this.copy();
            return true;
        }
        if (ActionFactory.PASTE.getId().equals(command)) {
            this.paste();
            return true;
        }
        if (ActionFactory.SELECT_ALL.getId().equals(command)) {
            this.selectAll();
            return true;
        }
        if (ActionFactory.DELETE.getId().equals(command)) {
            this.deleteSelection();
            return true;
        }
        return super.obeyCommand(action);
    }

    public final void paste() {
        Clipboard clipboard = new Clipboard(this.getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        String text = this.sanitize((String)clipboard.getContents((Transfer)textTransfer));
        clipboard.dispose();
        this.mBuffer.replace(this.mSelectionStart, this.mSelectionEnd, text);
        this.disposeTextLayout();
        this.setSelection(this.mSelectionStart + text.length());
        this.repaint();
        this.notifyOfModification();
    }

    public final synchronized void removeClickListener(IClickListener listener) {
        this.mClickListeners.remove(listener);
    }

    public final synchronized void removeFieldModifiedListener(IFieldModifiedListener listener) {
        this.mFieldModifiedListeners.remove(listener);
    }

    @Override
    public final void run() {
        if (System.currentTimeMillis() > this.mForceShowUntil) {
            this.mShowCursor = !this.mShowCursor;
            this.repaint();
        }
        if (this.hasFocus()) {
            this.scheduleBlink();
        }
    }

    public final void selectAll() {
        this.setSelection(0, this.mBuffer.length());
    }

    @Override
    public final void setCursorPositionForProposal(int index) {
        this.setSelection(index);
    }

    @Override
    public final void setCursorRangeForProposal(Point range) {
        this.setSelection(range.x, range.y);
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.mImageButton != null) {
            this.mImageButton.setEnabled(enabled);
        }
        this.setBackgroundColor((Color)(enabled ? Colors.getWhite() : null));
    }

    public final void setFont(Font font) {
        if (!this.mFont.equals((Object)font)) {
            this.mFont = font;
            this.disposeTextLayout();
            this.repaint();
        }
    }

    public final void setForegroundColor(Color color) {
        if (!this.mForegroundColor.equals((Object)color)) {
            this.mForegroundColor = color;
            this.repaint();
        }
    }

    public final void setHasBorder(boolean hasBorder) {
        if (this.mHasBorder != hasBorder) {
            this.mHasBorder = hasBorder;
            this.layout();
        }
    }

    public final void setImageToolTip(String tooltip) {
        if (this.mImageButton != null) {
            this.mImageButton.setToolTip(tooltip);
        }
    }

    public final void setMultiLine(boolean multiLine) {
        this.mMultiLine = multiLine;
    }

    @Override
    public final void setProposalContents(String contents, int cursorPosition) {
        this.setText(contents);
    }

    public final void setProposalProvider(IBlockContentProposalProvider provider) {
        this.mProposalProvider = provider;
        this.repaint();
    }

    public final void setSelection(int start) {
        this.setSelection(start, start);
    }

    public final void setSelection(int start, int end) {
        this.setSelection(start, end, start);
    }

    public final void setSelection(Point selection) {
        this.setSelection(selection.x, selection.y);
    }

    public final void setSelectionToEnd() {
        this.setSelection(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public final void setSelectionToStart() {
        this.setSelection(0, 0);
    }

    public final boolean setText(String text) {
        text = this.sanitize(text);
        if (!this.mBuffer.toString().equals(text)) {
            this.mBuffer = new StringBuilder(text);
            this.disposeTextLayout();
            this.setSelectionToEnd();
            this.repaint();
            this.notifyOfModification();
            return true;
        }
        return false;
    }

    public final void setValid(boolean valid) {
        this.setForegroundColor(valid ? Colors.getBlack() : Colors.getRed());
    }

    public final void setWatermark(String watermark) {
        if (this.mWatermark != null ? !this.mWatermark.equals(watermark) : watermark != null) {
            this.mWatermark = watermark;
            this.repaint();
        }
    }

    public final void setWrapWidth(int width) {
        if (this.mWrapWidth != width) {
            this.mWrapWidth = width;
            this.disposeTextLayout();
        }
    }

    public final int toSelectionIndex(int x, int y) {
        Rectangle bounds = this.getLocalBounds();
        x -= bounds.x + 4 + this.mScrollOffset;
        if (this.mHasBorder) {
            --x;
        }
        this.prepareTextLayout();
        int top = bounds.y;
        int height = bounds.height;
        if (this.mHasBorder) {
            ++top;
            height -= 2;
        }
        ++top;
        int[] trailing = new int[1];
        int pos = this.mTextLayout.getOffset(x, y - (top += ((height -= 2) - this.mTextLayout.getBounds().height) / 2), trailing);
        if (this.mTextLayout.getLineIndex(pos) == this.mTextLayout.getLineIndex(pos + trailing[0])) {
            pos += trailing[0];
        }
        if (pos < 0) {
            pos = 0;
        } else if (pos > this.mBuffer.length()) {
            pos = this.mBuffer.length();
        }
        return pos;
    }

    public final void widgetDefaultSelected(SelectionEvent event) {
    }

    public final void widgetSelected(SelectionEvent event) {
        String title = ((MenuItem)event.widget).getText();
        if (LightweightMessages.CUT.equals(title)) {
            this.cut();
        } else if (LightweightMessages.COPY.equals(title)) {
            this.copy();
        } else if (LightweightMessages.PASTE.equals(title)) {
            this.paste();
        } else if (LightweightMessages.SELECT_ALL.equals(title)) {
            this.selectAll();
        }
    }

    @Override
    protected final boolean keyPressed(int code, char ch, int location, int stateMask) {
        boolean extend;
        boolean bl = extend = (stateMask & SWT.MOD2) == SWT.MOD2;
        if ((stateMask & SWT.MODIFIER_MASK & ~SWT.MOD2) == 0) {
            if (this.mMultiLine && (ch == '\r' || ch == '\n') || !Character.isISOControl(ch)) {
                if (this.hasSelectionRange()) {
                    this.mBuffer.delete(this.mSelectionStart, this.mSelectionEnd);
                }
                if (ch == '\r') {
                    ch = (char)10;
                }
                this.mBuffer.insert(this.mSelectionStart, ch);
                this.disposeTextLayout();
                this.setSelection(this.mSelectionStart + 1);
                this.notifyOfModification();
                return true;
            }
            switch (code) {
                case 8: {
                    if (this.hasSelectionRange()) {
                        this.deleteSelection();
                    } else if (this.mSelectionStart > 0) {
                        this.mBuffer.delete(this.mSelectionStart - 1, this.mSelectionStart);
                        this.disposeTextLayout();
                        this.setSelection(this.mSelectionStart - 1);
                        this.notifyOfModification();
                    }
                    return true;
                }
                case 127: {
                    if (this.hasSelectionRange()) {
                        this.deleteSelection();
                    } else if (this.mSelectionStart < this.mBuffer.length()) {
                        this.mBuffer.delete(this.mSelectionStart, this.mSelectionStart + 1);
                        this.disposeTextLayout();
                        this.repaint();
                        this.notifyOfModification();
                    }
                    return true;
                }
                case 0x1000003: {
                    this.handleArrowLeft(extend, false);
                    return true;
                }
                case 0x1000004: {
                    this.handleArrowRight(extend, false);
                    return true;
                }
                case 0x1000006: 
                case 0x1000008: {
                    this.handleEnd(extend);
                    return true;
                }
                case 0x1000002: {
                    this.handleArrowDown(extend);
                    return true;
                }
                case 0x1000005: 
                case 0x1000007: {
                    this.handleHome(extend);
                    return true;
                }
                case 0x1000001: {
                    this.handleArrowUp(extend);
                    return true;
                }
            }
            return super.keyPressed(code, ch, location, stateMask);
        }
        if ((stateMask & SWT.MOD1) == SWT.MOD1) {
            switch (code) {
                case 0x1000003: {
                    this.handleArrowLeft(extend, true);
                    return true;
                }
                case 0x1000004: {
                    this.handleArrowRight(extend, true);
                    return true;
                }
            }
            return super.keyPressed(code, ch, location, stateMask);
        }
        return false;
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        if (button == 1) {
            this.mExtendByWord = false;
            if (count == 2) {
                this.setSelection(this.findWordAt(this.toSelectionIndex(where.x, where.y)));
                this.mExtendByWord = true;
            } else if (count == 3) {
                this.selectAll();
            } else {
                int end;
                int start;
                boolean extend;
                int oldAnchor = this.mSelectionAnchor;
                this.mSelectionAnchor = this.toSelectionIndex(where.x, where.y);
                boolean bl = extend = (stateMask & SWT.MOD2) == SWT.MOD2;
                if (extend) {
                    if (oldAnchor > this.mSelectionAnchor) {
                        start = this.mSelectionAnchor;
                        end = oldAnchor;
                    } else {
                        start = oldAnchor;
                        end = this.mSelectionAnchor;
                    }
                } else {
                    start = this.mSelectionAnchor;
                    end = this.mSelectionAnchor;
                }
                this.setSelection(start, end, this.mSelectionAnchor);
            }
        } else if (button == 3) {
            Menu menu = new Menu((Control)this.getOwner());
            this.addMenuItem(menu, LightweightMessages.CUT, this.hasSelectionRange());
            this.addMenuItem(menu, LightweightMessages.COPY, this.hasSelectionRange());
            Clipboard clipboard = new Clipboard(this.getDisplay());
            TextTransfer textTransfer = TextTransfer.getInstance();
            String text = this.sanitize((String)clipboard.getContents((Transfer)textTransfer));
            clipboard.dispose();
            this.addMenuItem(menu, LightweightMessages.PASTE, !text.isEmpty());
            new MenuItem(menu, 2).setData(null);
            this.addMenuItem(menu, LightweightMessages.SELECT_ALL, this.mSelectionStart != 0 || this.mSelectionEnd != this.mBuffer.length());
            this.showContextMenu(menu, where);
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        Point range;
        int oldAnchor;
        block5: {
            oldAnchor = this.mSelectionAnchor;
            int pos = this.toSelectionIndex(where.x, where.y);
            if (this.mExtendByWord) {
                Point initialRange = this.findWordAt(oldAnchor);
                int dir = pos > initialRange.x ? -1 : 1;
                do {
                    range = this.findWordAt(pos);
                    if (range.x == range.y) continue;
                    if (range.x > initialRange.x) {
                        range.x = initialRange.x;
                    }
                    if (range.y < initialRange.y) {
                        range.y = initialRange.y;
                    }
                    break block5;
                } while ((dir <= 0 || (pos += dir) < initialRange.x) && (dir >= 0 || pos > initialRange.y));
                range.x = initialRange.x;
                range.y = initialRange.y;
            } else {
                range = pos > oldAnchor ? new Point(oldAnchor, pos) : new Point(pos, oldAnchor);
            }
        }
        this.setSelection(range.x, range.y, oldAnchor);
    }

    @Override
    protected final void paintSelf(GC gc) {
        this.mAllowAutoScrollDuringResize = true;
        super.paintSelf(gc);
        Rectangle clipBounds = gc.getClipping();
        int savedAA = gc.getAntialias();
        gc.setAntialias(0);
        Rectangle bounds = this.getLocalBounds();
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        boolean hasFocus = this.hasFocus();
        if (this.mHasBorder) {
            gc.setForeground(Colors.darken(hasFocus ? Colors.getListSelection() : Colors.getWidgetBackground(), 20));
            gc.drawRectangle(x, y, width - 1, height - 1);
            ++x;
            ++y;
            width -= 2;
            height -= 2;
        }
        if (this.mProposalProvider != null) {
            BlockComposite owner = this.getOwner();
            if (hasFocus || owner != null && owner.isProposalPopupOpen()) {
                FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
                Image img = fieldDecoration.getImage();
                gc.drawImage(img, x + width - img.getBounds().width - 1, y + 1);
            }
        }
        gc.setAntialias(savedAA);
        x += 4;
        width -= 8;
        if (this.mImageButton != null) {
            width -= this.mImageButton.getWidth() + 1;
        }
        gc.setClipping(new Rectangle(x, ++y, width, height -= 2).intersection(clipBounds));
        gc.setAntialias(1);
        TextDrawingState state = new TextDrawingState(gc);
        this.prepareTextLayout();
        int top = y + (height - this.mTextLayout.getBounds().height) / 2;
        int length = this.mBuffer.length();
        if (length == 0) {
            if (this.mWatermark != null) {
                gc.setForeground(Colors.getDarkGray());
                gc.setFont(this.getFont());
                TextDrawing.drawString(gc, this.mWatermark, x, y, width, height, 16384, 0x1000000);
            }
        } else {
            gc.setForeground(this.mForegroundColor);
            gc.setBackground(this.getLogicalBackgroundColor());
            if (this.hasSelectionRange()) {
                this.mTextLayout.draw(gc, x + this.mScrollOffset, top, this.mSelectionStart, this.mSelectionEnd - 1, Colors.getText(hasFocus), Colors.getSelection(hasFocus));
            } else {
                this.mTextLayout.draw(gc, x + this.mScrollOffset, top);
            }
        }
        if (!this.hasSelectionRange() && hasFocus) {
            if (this.mShowCursor) {
                this.prepareTextLayout();
                gc.setForeground(Colors.isDark(this.getBackgroundColor()) ? Colors.getWhite() : Colors.getBlack());
                gc.setAntialias(0);
                Rectangle lineBounds = this.mTextLayout.getLineBounds(this.mTextLayout.getLineIndex(this.mSelectionEnd));
                top += lineBounds.y;
                int left = x + this.mScrollOffset;
                if (Platform.isMacintosh() && length > 0 && length == this.mSelectionEnd && this.mBuffer.charAt(length - 1) == '\n') {
                    top += this.mTextLayout.getBounds((int)this.mSelectionEnd, (int)this.mSelectionEnd).height;
                } else {
                    left += this.mTextLayout.getLocation((int)this.mSelectionEnd, (boolean)false).x;
                }
                gc.drawLine(left, top, left, top + lineBounds.height - 1);
                gc.setAntialias(savedAA);
            }
            this.scheduleBlink();
        }
        state.restore();
        gc.setAntialias(savedAA);
        gc.setClipping(clipBounds);
    }

    @Override
    protected final void wasAdded(Block parent) {
        super.wasAdded(parent);
        this.setCursor(Display.getCurrent().getSystemCursor(19));
    }

    @Override
    protected final void wasRemoved(Block parent) {
        super.wasRemoved(parent);
        this.disposeTextLayout();
    }

    @Override
    protected final void wasResized() {
        super.wasResized();
        if (this.mAllowAutoScrollDuringResize) {
            this.autoScroll();
        }
    }

    private final void addMenuItem(Menu menu, String title, boolean enabled) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(title);
        item.setEnabled(enabled);
        item.addSelectionListener((SelectionListener)this);
    }

    private final int adjustDown(int index) {
        Point where = this.fromSelectionIndex(index);
        return this.toSelectionIndex(where.x, where.y + this.getLineHeightForOffset(index));
    }

    private final int adjustUp(int index) {
        Point where = this.fromSelectionIndex(index);
        return this.toSelectionIndex(where.x, where.y - this.getLineHeightForOffset(index));
    }

    private final void autoScroll() {
        Rectangle bounds = this.getLocalBounds();
        if (bounds.width > 0 && !this.mMultiLine) {
            int max;
            bounds.x += 4;
            bounds.width -= 8;
            if (this.mHasBorder) {
                ++bounds.x;
                bounds.width -= 2;
            }
            if (this.mImageButton != null) {
                bounds.width -= this.mImageButton.getWidth() + 1;
            }
            int original = this.mScrollOffset;
            if (this.mSelectionStart == this.mSelectionAnchor) {
                int right = this.fromSelectionIndex((int)this.mSelectionEnd).x;
                if (right < bounds.x) {
                    this.mScrollOffset = 0;
                    this.mScrollOffset = bounds.x - this.fromSelectionIndex((int)this.mSelectionEnd).x;
                } else if (right >= bounds.x + bounds.width) {
                    this.mScrollOffset = 0;
                    this.mScrollOffset = bounds.x + bounds.width - 1 - this.fromSelectionIndex((int)this.mSelectionEnd).x;
                }
            } else {
                int left = this.fromSelectionIndex((int)this.mSelectionStart).x;
                if (left < bounds.x) {
                    this.mScrollOffset = 0;
                    this.mScrollOffset = bounds.x - this.fromSelectionIndex((int)this.mSelectionStart).x;
                } else if (left >= bounds.x + bounds.width) {
                    this.mScrollOffset = 0;
                    this.mScrollOffset = bounds.x + bounds.width - 1 - this.fromSelectionIndex((int)this.mSelectionStart).x;
                }
            }
            int save = this.mScrollOffset;
            this.mScrollOffset = 0;
            int min = bounds.x + bounds.width - 1 - this.fromSelectionIndex((int)this.mBuffer.length()).x;
            if (min > 0) {
                min = 0;
            }
            if ((max = bounds.x - this.fromSelectionIndex((int)0).x) < 0) {
                max = 0;
            }
            if (save < min) {
                save = min;
            } else if (save > max) {
                save = max;
            }
            this.mScrollOffset = save;
            if (original != this.mScrollOffset) {
                this.repaint();
            }
        }
    }

    private final void disposeTextLayout() {
        if (this.mTextLayout != null) {
            this.mTextLayout.dispose();
            this.mTextLayout = null;
        }
    }

    private final Point findWordAt(int pos) {
        int length = this.mBuffer.length();
        if (pos < 0) {
            pos = 0;
        } else if (pos >= length) {
            pos = length - 1;
        }
        int start = pos;
        int end = pos;
        if (length > 0 && !Character.isWhitespace(this.mBuffer.charAt(start))) {
            while (start > 0 && !Character.isWhitespace(this.mBuffer.charAt(start - 1))) {
                --start;
            }
            while (end < length && !Character.isWhitespace(this.mBuffer.charAt(end))) {
                ++end;
            }
        }
        return new Point(start, end);
    }

    private int getLineHeightForOffset(int index) {
        return this.mTextLayout.getLineMetrics(this.mTextLayout.getLineIndex(index)).getHeight();
    }

    private final Point getSize(boolean minimum) {
        Rectangle bounds;
        Point size;
        if (this.mImageButton != null) {
            size = this.mImageButton.getPreferredSize(-1, -1);
            ++size.x;
            size.y += 2;
        } else {
            size = new Point(0, 0);
        }
        size.x += 8;
        if (minimum) {
            TextLayout layout = new TextLayout((Device)this.getDisplay());
            layout.setFont(this.mFont);
            layout.setText("\u2026");
            bounds = layout.getBounds();
            layout.dispose();
        } else {
            this.prepareTextLayout();
            bounds = this.mTextLayout.getBounds();
        }
        size.x += bounds.width;
        int height = bounds.height + 2;
        if (size.y < height) {
            size.y = height;
        }
        if (this.mHasBorder) {
            size.x += 2;
            size.y += 2;
        }
        return size;
    }

    private final void handleArrowDown(boolean extend) {
        if (this.mMultiLine) {
            this.prepareTextLayout();
            if (this.hasSelectionRange()) {
                if (extend) {
                    int anchor = this.mSelectionAnchor;
                    if (this.mSelectionEnd == anchor) {
                        this.setSelection(this.adjustDown(this.mSelectionStart), anchor, anchor);
                    } else {
                        this.setSelection(anchor, this.adjustDown(this.mSelectionEnd), anchor);
                    }
                } else {
                    this.setSelection(this.adjustDown(this.mSelectionEnd));
                }
            } else if (extend) {
                this.setSelection(this.mSelectionStart, this.adjustDown(this.mSelectionEnd));
            } else {
                this.setSelection(this.adjustDown(this.mSelectionEnd));
            }
        } else {
            this.handleEnd(extend);
        }
    }

    private final void handleArrowLeft(boolean extend, boolean byWord) {
        if (this.hasSelectionRange()) {
            if (extend) {
                int anchor = this.mSelectionAnchor;
                if (this.mSelectionStart == anchor) {
                    int pos = this.mSelectionEnd - 1;
                    if (byWord) {
                        pos = Math.min(Math.max(this.findWordAt((int)pos).x, anchor), pos);
                    }
                    this.setSelection(anchor, this.mSelectionEnd - 1, anchor);
                } else {
                    int pos = this.mSelectionStart - 1;
                    if (byWord) {
                        pos = Math.min(this.findWordAt((int)pos).x, pos);
                    }
                    this.setSelection(pos, anchor, anchor);
                }
            } else {
                this.setSelection(this.mSelectionStart);
            }
        } else {
            int pos = this.mSelectionStart - 1;
            if (byWord) {
                pos = Math.min(this.findWordAt((int)pos).x, pos);
            }
            if (extend) {
                this.setSelection(pos, this.mSelectionStart, this.mSelectionEnd);
            } else {
                this.setSelection(pos);
            }
        }
    }

    private final void handleArrowRight(boolean extend, boolean byWord) {
        if (this.hasSelectionRange()) {
            if (extend) {
                int anchor = this.mSelectionAnchor;
                if (this.mSelectionEnd == anchor) {
                    int pos = this.mSelectionStart + 1;
                    if (byWord) {
                        pos = Math.max(Math.min(this.findWordAt((int)pos).y, anchor), pos);
                    }
                    this.setSelection(pos, anchor, anchor);
                } else {
                    int pos = this.mSelectionEnd + 1;
                    if (byWord) {
                        pos = Math.max(this.findWordAt((int)pos).y, pos);
                    }
                    this.setSelection(anchor, pos, anchor);
                }
            } else {
                this.setSelection(this.mSelectionEnd);
            }
        } else {
            int pos = this.mSelectionEnd + 1;
            if (byWord) {
                pos = Math.max(this.findWordAt((int)pos).y, pos);
            }
            if (extend) {
                this.setSelection(this.mSelectionStart, pos);
            } else {
                this.setSelection(pos);
            }
        }
    }

    private final void handleArrowUp(boolean extend) {
        if (this.mMultiLine) {
            this.prepareTextLayout();
            if (this.hasSelectionRange()) {
                if (extend) {
                    int anchor = this.mSelectionAnchor;
                    if (this.mSelectionStart == anchor) {
                        this.setSelection(anchor, this.adjustUp(this.mSelectionEnd), anchor);
                    } else {
                        this.setSelection(this.adjustUp(this.mSelectionStart), anchor, anchor);
                    }
                } else {
                    this.setSelection(this.mSelectionStart);
                }
            } else if (extend) {
                this.setSelection(this.adjustUp(this.mSelectionStart), this.mSelectionStart, this.mSelectionEnd);
            } else {
                this.setSelection(this.adjustUp(this.mSelectionStart));
            }
        } else {
            this.handleHome(extend);
        }
    }

    private final void handleEnd(boolean extend) {
        if (extend) {
            this.setSelection(this.mSelectionStart, Integer.MAX_VALUE);
        } else {
            this.setSelectionToEnd();
        }
    }

    private final void handleHome(boolean extend) {
        if (extend) {
            this.setSelection(0, this.mSelectionEnd, this.mSelectionEnd);
        } else {
            this.setSelectionToStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyOfModification() {
        if (this.mNotify) {
            IFieldModifiedListener[] listeners;
            BlockTextField blockTextField = this;
            synchronized (blockTextField) {
                listeners = this.mFieldModifiedListeners.toArray(new IFieldModifiedListener[this.mFieldModifiedListeners.size()]);
            }
            IFieldModifiedListener[] iFieldModifiedListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IFieldModifiedListener listener = iFieldModifiedListenerArray[n2];
                listener.fieldModified(this);
                ++n2;
            }
        }
    }

    private final void prepareTextLayout() {
        if (this.mTextLayout == null) {
            this.mTextLayout = new TextLayout((Device)this.getDisplay());
            this.mTextLayout.setFont(this.mFont);
            this.mTextLayout.setWidth(this.mWrapWidth > 0 ? this.mWrapWidth : -1);
            this.mTextLayout.setText(this.mBuffer.toString());
        }
    }

    private final String sanitize(String text) {
        if (text == null) {
            text = "";
        }
        if (!this.mMultiLine) {
            text = text.replace("\n", "").replace("\r", "");
        }
        return text;
    }

    private final void scheduleBlink() {
        Task.scheduleOnUIThread((Runnable)this, (String)String.valueOf(this.hashCode()), (long)560L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private final void setSelection(int start, int end, int anchor) {
        int length = this.mBuffer.length();
        if (start < 0) {
            start = 0;
        } else if (start > length) {
            start = length;
        }
        if (end < start) {
            end = start;
        } else if (end > length) {
            end = length;
        }
        if (anchor < start) {
            anchor = start;
        } else if (anchor > end) {
            anchor = end;
        }
        if (this.mSelectionStart != start || this.mSelectionEnd != end || this.mSelectionAnchor != anchor) {
            this.mSelectionStart = start;
            this.mSelectionEnd = end;
            this.mSelectionAnchor = anchor;
            this.mForceShowUntil = System.currentTimeMillis() + 560L;
            this.mShowCursor = true;
            this.repaint();
            this.scrollIntoView();
            this.autoScroll();
        }
    }

    public static interface IClickListener {
        public void buttonClicked(BlockTextField var1);
    }

    public static interface IFieldModifiedListener {
        public void fieldModified(BlockTextField var1);
    }
}

