/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.lightweight.Block;
import com.arm.streamline.widget.lightweight.BlockComposite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class BlockPopupMenu
extends Block
implements MenuListener,
SelectionListener {
    private static final int H_MARGIN = 3;
    private static final int V_MARGIN = 2;
    private static final int CORNER_RADIUS = 4;
    private static final int MENU_GAP = 2;
    private Map<Image, Image> mDisabledMenuImages = new HashMap<Image, Image>();
    protected boolean mDrawBorder;
    protected boolean mPressed;
    private int mCurrentIndex = -1;
    private Set<IPopupMenuItemSelectionListener> mPopupMenuItemSelectionListeners = new HashSet<IPopupMenuItemSelectionListener>();
    private List<MenuItemData> mMenuItems = new ArrayList<MenuItemData>();
    private Font mFont = Fonts.getNormal();
    private Menu mMenu;

    public final void addMenuItem(Image img, String title, Object data) {
        this.mMenuItems.add(new MenuItemData(img, title, data));
    }

    public final void addMenuItem(String title) {
        this.mMenuItems.add(new MenuItemData(null, title, null));
    }

    public final void addMenuItem(String title, Object data) {
        this.mMenuItems.add(new MenuItemData(null, title, data));
    }

    public final void addMenuSeparator() {
        this.mMenuItems.add(null);
    }

    public synchronized void addPopupMenuItemSelectionListener(IPopupMenuItemSelectionListener listener) {
        this.mPopupMenuItemSelectionListeners.add(listener);
    }

    public final Font getFont() {
        return this.mFont;
    }

    public final int getItemIndex(Object data) {
        int count = this.mMenuItems.size();
        int i = 0;
        while (i < count) {
            MenuItemData item = this.mMenuItems.get(i);
            if (item != null) {
                Object itemData = item.getData();
                if (data == null ? itemData == null : data.equals(itemData)) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    @Override
    public final Point getMinimumSize(int widthHint, int heightHint) {
        return this.getSize(true);
    }

    @Override
    public final Point getPreferredSize(int widthHint, int heightHint) {
        return this.getSize(false);
    }

    public final int getSelectedIndex() {
        return this.mCurrentIndex >= 0 && this.mCurrentIndex < this.mMenuItems.size() ? this.mCurrentIndex : -1;
    }

    public final void menuHidden(MenuEvent menuEvent) {
        this.mPressed = false;
        this.mDrawBorder = false;
        this.repaint();
        Menu menu = this.mMenu;
        this.mMenu = null;
        Task.scheduleOnUIThread(() -> menu.dispose());
        this.releaseCapturedMouse();
    }

    public final void menuShown(MenuEvent event) {
    }

    public synchronized void removePopupMenuItemSelectionListener(IPopupMenuItemSelectionListener listener) {
        this.mPopupMenuItemSelectionListeners.remove(listener);
    }

    public void selectItemWithData(Object data) {
        int index = this.getItemIndex(data);
        if (index != -1) {
            this.setSelectedIndex(index);
        }
    }

    public void setEnabledByItemIndex(int index, boolean enabled) {
        MenuItemData item;
        if (index >= 0 && index < this.mMenuItems.size() && (item = this.mMenuItems.get(index)) != null) {
            item.setEnabled(enabled);
            if (this.getSelectedIndex() == index) {
                this.repaint();
            }
        }
    }

    public void setEnabledByItemWithData(Object data, boolean enabled) {
        this.setEnabledByItemIndex(this.getItemIndex(data), enabled);
    }

    public final void setFont(Font font) {
        if (!this.mFont.equals((Object)font)) {
            this.mFont = font;
            this.repaint();
        }
    }

    public void setSelectedIndex(int index) {
        if (index != this.mCurrentIndex && index >= 0 && index < this.mMenuItems.size() && this.mMenuItems.get(index) != null) {
            this.mCurrentIndex = index;
            this.repaint();
        }
    }

    public final void widgetDefaultSelected(SelectionEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void widgetSelected(SelectionEvent event) {
        IPopupMenuItemSelectionListener[] listeners;
        int i = this.mMenuItems.indexOf(event.widget.getData());
        this.setSelectedIndex(i);
        BlockPopupMenu blockPopupMenu = this;
        synchronized (blockPopupMenu) {
            listeners = this.mPopupMenuItemSelectionListeners.toArray(new IPopupMenuItemSelectionListener[this.mPopupMenuItemSelectionListeners.size()]);
        }
        Object data = this.mMenuItems.get(i).getData();
        IPopupMenuItemSelectionListener[] iPopupMenuItemSelectionListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPopupMenuItemSelectionListener listener = iPopupMenuItemSelectionListenerArray[n2];
            listener.popupMenuItemSelected(this, i, data);
            ++n2;
        }
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        if (button == 1) {
            Rectangle bounds = this.getLocalBounds();
            BlockComposite owner = this.getOwner();
            where = this.toDisplay(0, bounds.y + bounds.height);
            if (!owner.getMonitor().getClientArea().contains(where)) {
                where.y -= bounds.height;
            }
            this.mMenu = new Menu((Control)owner);
            int i = 0;
            for (MenuItemData one : this.mMenuItems) {
                if (one == null) {
                    new MenuItem(this.mMenu, 2).setData(null);
                } else {
                    one.create(this.mMenu, i == this.mCurrentIndex);
                }
                ++i;
            }
            this.mMenu.addMenuListener((MenuListener)this);
            this.mMenu.setLocation(where);
            this.mMenu.setVisible(true);
            this.mPressed = true;
            this.repaint();
        }
    }

    @Override
    protected final void mouseEnter(Point where, int stateMask) {
        this.mDrawBorder = true;
        this.repaint();
    }

    @Override
    protected final void mouseExit() {
        this.mDrawBorder = false;
        this.repaint();
    }

    @Override
    protected final void paintSelf(GC gc) {
        super.paintSelf(gc);
        boolean enabled = this.isEnabled();
        Rectangle bounds = this.getLocalBounds();
        Color color = this.getLogicalBackgroundColor();
        int savedAA = gc.getAntialias();
        gc.setAntialias(1);
        if (this.mPressed || enabled && this.mDrawBorder) {
            Color lightColor = Colors.lighten(color, 15);
            Color darkColor = Colors.darken(color, 20);
            Color topColor = this.mPressed ? darkColor : lightColor;
            Color bottomColor = this.mPressed ? lightColor : darkColor;
            Pattern pattern = new Pattern(gc.getDevice(), (float)bounds.x, (float)bounds.y, (float)bounds.x, (float)(bounds.y + bounds.height - 1), topColor, bottomColor);
            gc.setBackgroundPattern(pattern);
            gc.fillRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, 4, 4);
            pattern.dispose();
        } else {
            gc.setBackground(Colors.darken(color, 5));
            gc.fillRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, 4, 4);
            gc.setForeground(Colors.darken(color, 10));
            gc.drawRoundRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 4, 4);
        }
        Image menuImage = StreamlinePlugin.getImage(StreamlineImages.MENU_DROP_ARROW);
        Rectangle menuImageBounds = menuImage.getBounds();
        int index = this.getSelectedIndex();
        if (index >= 0) {
            int available = bounds.width - (menuImageBounds.width + 2 + 6);
            int left = bounds.x + 3;
            MenuItemData item = this.mMenuItems.get(index);
            boolean itemEnabled = item.isEnabled();
            Image img = item.getImage();
            if (img != null) {
                Rectangle imgBounds = img.getBounds();
                gc.drawImage(enabled && itemEnabled ? img : this.getDisabledImage(img), left, bounds.y + (bounds.height - imgBounds.height) / 2);
                left += imgBounds.width + 3;
                available -= imgBounds.width + 3;
            }
            gc.setFont(this.mFont);
            gc.setForeground(enabled && itemEnabled ? Colors.getWidgetForeground() : Colors.getWidgetNormalShadow());
            gc.setAntialias(savedAA);
            String text = TextDrawing.truncateString(gc, item.getTitle(), available, 131072);
            TextDrawing.drawString(gc, text, left, bounds.y + (bounds.height - FontInfo.get(this.mFont).getHeight()) / 2, 16384);
            gc.setAntialias(1);
        }
        gc.drawImage(enabled ? menuImage : this.getDisabledImage(menuImage), bounds.x + bounds.width - (menuImageBounds.width + 3), bounds.y + (bounds.height - menuImageBounds.height) / 2);
        if (this.mPressed || enabled && this.mDrawBorder) {
            gc.setForeground(Colors.darken(color, 30));
            gc.drawRoundRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 4, 4);
        }
        gc.setAntialias(savedAA);
    }

    @Override
    protected final void wasRemoved(Block parent) {
        super.wasRemoved(parent);
        for (Image img : this.mDisabledMenuImages.values()) {
            img.dispose();
        }
        this.mDisabledMenuImages.clear();
    }

    private final Image getDisabledImage(Image img) {
        Image image = this.mDisabledMenuImages.get(img);
        if (image == null) {
            image = new Image(img.getDevice(), img, 1);
            this.mDisabledMenuImages.put(img, image);
        }
        return image;
    }

    private final Point getSize(boolean minimum) {
        GC gc = this.createTemporaryGC();
        gc.setFont(this.mFont);
        int width = 0;
        int height = 0;
        for (MenuItemData item : this.mMenuItems) {
            int oneWidth = 0;
            Image img = item.getImage();
            if (img != null) {
                Rectangle bounds = img.getBounds();
                oneWidth = bounds.width + 3;
                if (height < bounds.height) {
                    height = bounds.height;
                }
            }
            Point extent = gc.stringExtent(minimum ? "\u2026" : item.getTitle());
            extent.x += 1 + oneWidth;
            if (width < extent.x) {
                width = extent.x;
            }
            if (height >= extent.y) continue;
            height = extent.y;
        }
        Point size = new Point(width, height);
        Rectangle bounds = StreamlinePlugin.getImage(StreamlineImages.MENU_DROP_ARROW).getBounds();
        size.x += 2 + bounds.width;
        if (size.y < bounds.height) {
            size.y = bounds.height;
        }
        size.x += 6;
        size.y += 4;
        gc.dispose();
        return size;
    }

    public static interface IPopupMenuItemSelectionListener {
        public void popupMenuItemSelected(BlockPopupMenu var1, int var2, Object var3);
    }

    private class MenuItemData {
        private Image mImage;
        private String mTitle;
        private Object mData;
        private boolean mEnabled;

        MenuItemData(Image image, String title, Object data) {
            this.mImage = image;
            this.mTitle = title;
            this.mData = data;
            this.mEnabled = true;
        }

        final MenuItem create(Menu menu, boolean checked) {
            MenuItem item = new MenuItem(menu, 32);
            item.setData((Object)this);
            if (this.mImage != null) {
                item.setImage(this.mImage);
            }
            item.setText(this.mTitle);
            if (checked) {
                item.setSelection(true);
            }
            if (this.mEnabled) {
                item.addSelectionListener((SelectionListener)BlockPopupMenu.this);
            } else {
                item.setEnabled(false);
            }
            return item;
        }

        final Object getData() {
            return this.mData;
        }

        final Image getImage() {
            return this.mImage;
        }

        final String getTitle() {
            return this.mTitle;
        }

        final boolean isEnabled() {
            return this.mEnabled;
        }

        final void setEnabled(boolean enabled) {
            this.mEnabled = enabled;
        }
    }
}

