/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.lightweight;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.lightweight.Block;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class BlockImageButton
extends Block
implements IPropertyChangeListener {
    private static final int MARGIN = 3;
    private static final int CORNER_RADIUS = 4;
    private static final int MENU_GAP = 2;
    private Action mAction;
    private Image mImage;
    private Image mDisabledImage;
    private Image mDisabledMenuImage;
    private int mPreferredImageWidth;
    private int mPreferredImageHeight;
    protected boolean mDrawBorder;
    private boolean mInMouseDown;
    protected boolean mPressed;
    private boolean mHasDropDown;
    private boolean mToggle;
    private boolean mSelected;
    private Set<IClickListener> mClickListeners = new HashSet<IClickListener>();
    private Object mData;

    public BlockImageButton(Action action) {
        this(action.getImageDescriptor().createImage(), action.getStyle() == 2);
        this.mAction = action;
        this.mHasDropDown = this.mAction.getMenuCreator() != null;
        this.mAction.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setSelected(this.mAction.isChecked());
        this.setEnabled(this.mAction.isEnabled());
        this.adjustTooltipFromAction();
    }

    public BlockImageButton(Image image) {
        this(image, false, image.getBounds().width, image.getBounds().height);
    }

    public BlockImageButton(Image image, boolean toggle) {
        this(image, toggle, image.getBounds().width, image.getBounds().height);
    }

    public BlockImageButton(Image image, boolean toggle, int preferredImageWidth, int preferredImageHeight) {
        this.mToggle = toggle;
        this.mImage = image;
        this.setPreferredImageSize(preferredImageWidth, preferredImageHeight);
    }

    public final synchronized void addClickListener(IClickListener listener) {
        this.mClickListeners.add(listener);
    }

    public final Object getData() {
        return this.mData;
    }

    @Override
    public final Point getMinimumSize(int widthHint, int heightHint) {
        int margins = 6;
        Point size = new Point(this.mPreferredImageWidth, this.mPreferredImageHeight);
        if (this.mHasDropDown) {
            Rectangle bounds = StreamlinePlugin.getImage(StreamlineImages.MENU_DROP_ARROW).getBounds();
            size.x += 2 + bounds.width;
            if (size.y < bounds.height) {
                size.y = bounds.height;
            }
        }
        size.x += margins;
        size.y += margins;
        return size;
    }

    public final int getPreferredImageHeight() {
        return this.mPreferredImageHeight;
    }

    public final int getPreferredImageWidth() {
        return this.mPreferredImageWidth;
    }

    @Override
    public final Point getPreferredSize(int widthHint, int heightHint) {
        return this.getMinimumSize(widthHint, heightHint);
    }

    public final boolean isSelected() {
        return this.mSelected;
    }

    public final void propertyChange(PropertyChangeEvent event) {
        switch (event.getProperty()) {
            case "enabled": {
                this.setEnabled((Boolean)event.getNewValue());
                this.repaint();
                break;
            }
            case "toolTipText": 
            case "text": {
                this.adjustTooltipFromAction();
                break;
            }
        }
    }

    public final synchronized void removeClickListener(IClickListener listener) {
        this.mClickListeners.remove(listener);
    }

    public final void setData(Object data) {
        this.mData = data;
    }

    public final void setPreferredImageSize(int width, int height) {
        this.mPreferredImageWidth = width;
        this.mPreferredImageHeight = height;
    }

    public final void setSelected(boolean selected) {
        if (this.mToggle && this.mSelected != selected) {
            this.mSelected = selected;
            this.repaint();
        }
    }

    @Override
    protected final void mouseDown(Point where, int button, int stateMask, int count) {
        if (button == 1) {
            if (this.mHasDropDown) {
                final IMenuCreator menuCreator = this.mAction.getMenuCreator();
                Menu menu = menuCreator.getMenu((Control)this.getOwner());
                menu.setLocation(this.toDisplay(this.getSize().x - (2 + StreamlinePlugin.getImage((String)StreamlineImages.MENU_DROP_ARROW).getBounds().width + 3), 0));
                menu.addMenuListener((MenuListener)new MenuAdapter(){

                    public final void menuHidden(MenuEvent menuEvent) {
                        Task.callOnUIThread((Runnable)new Runnable(){

                            @Override
                            public final void run() {
                                menuCreator.dispose();
                                (this).BlockImageButton.this.mPressed = false;
                                (this).BlockImageButton.this.mDrawBorder = false;
                                BlockImageButton.this.repaint();
                            }
                        });
                    }
                });
                menu.setVisible(true);
            } else {
                this.mInMouseDown = true;
            }
            this.mPressed = true;
            this.repaint();
        }
    }

    @Override
    protected final void mouseDrag(Point where, int button, int stateMask) {
        if (this.mInMouseDown) {
            boolean wasPressed = this.mPressed;
            this.mPressed = this.getLocalBounds().contains(where);
            if (this.mPressed != wasPressed) {
                this.repaint();
            }
        }
    }

    @Override
    protected final void mouseEnter(Point where, int stateMask) {
        this.mDrawBorder = true;
        this.repaint();
    }

    @Override
    protected final void mouseExit() {
        this.mDrawBorder = false;
        this.repaint();
    }

    @Override
    protected final void mouseUp(Point where, int button, int stateMask, int count) {
        if (this.mInMouseDown) {
            this.mInMouseDown = false;
            this.mPressed = false;
            if (this.mToggle) {
                this.mSelected = !this.mSelected;
            }
            this.repaint();
            if (this.getLocalBounds().contains(where)) {
                this.notifyListeners();
                if (this.mAction != null) {
                    this.mAction.run();
                }
            }
        }
    }

    @Override
    protected void paintSelf(GC gc) {
        super.paintSelf(gc);
        boolean enabled = this.isEnabled();
        Rectangle bounds = this.getLocalBounds();
        gc.setAntialias(1);
        Color color = this.getLogicalBackgroundColor();
        if (this.mToggle && this.mSelected) {
            color = Colors.blend(color, Colors.getCyan(), 10);
        }
        if (this.mPressed || enabled && this.mDrawBorder || this.mToggle && this.mSelected) {
            Color lightColor = Colors.lighten(color, 15);
            Color darkColor = Colors.darken(color, 20);
            Color topColor = this.mPressed ? darkColor : lightColor;
            Color bottomColor = this.mPressed ? lightColor : darkColor;
            Pattern pattern = new Pattern(gc.getDevice(), (float)bounds.x, (float)bounds.y, (float)bounds.x, (float)(bounds.y + bounds.height - 1), topColor, bottomColor);
            gc.setBackgroundPattern(pattern);
            gc.fillRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, 4, 4);
            pattern.dispose();
        }
        Rectangle imageBounds = this.mImage.getBounds();
        if (!enabled && this.mDisabledImage == null) {
            this.mDisabledImage = new Image(gc.getDevice(), this.mImage, 1);
        }
        if (this.mHasDropDown) {
            Image menuImage = StreamlinePlugin.getImage(StreamlineImages.MENU_DROP_ARROW);
            Rectangle menuImageBounds = menuImage.getBounds();
            if (!enabled && this.mDisabledMenuImage == null) {
                this.mDisabledMenuImage = new Image(gc.getDevice(), menuImage, 1);
            }
            int x = bounds.x + (bounds.width - (imageBounds.width + 2 + menuImageBounds.width)) / 2;
            gc.drawImage(enabled ? this.mImage : this.mDisabledImage, x, bounds.y + (bounds.height - imageBounds.height) / 2);
            gc.drawImage(enabled ? menuImage : this.mDisabledMenuImage, x + imageBounds.width + 2, bounds.y + (bounds.height - menuImageBounds.height) / 2);
        } else {
            gc.drawImage(enabled ? this.mImage : this.mDisabledImage, bounds.x + (bounds.width - imageBounds.width) / 2, bounds.y + (bounds.height - imageBounds.height) / 2);
        }
        if (this.mPressed || enabled && this.mDrawBorder || this.mToggle && this.mSelected) {
            gc.setForeground(Colors.darken(color, 30));
            gc.drawRoundRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, 4, 4);
        }
        gc.setAntialias(0);
    }

    @Override
    protected final void wasRemoved(Block parent) {
        super.wasRemoved(parent);
        if (this.mDisabledImage != null) {
            this.mDisabledImage.dispose();
            this.mDisabledImage = null;
        }
        if (this.mDisabledMenuImage != null) {
            this.mDisabledMenuImage.dispose();
            this.mDisabledMenuImage = null;
        }
        if (this.mAction != null) {
            this.mImage.dispose();
            this.mImage = null;
            this.mAction.removePropertyChangeListener((IPropertyChangeListener)this);
            this.mAction = null;
        }
    }

    private final void adjustTooltipFromAction() {
        String tooltip = this.mAction.getToolTipText();
        if (tooltip == null || tooltip.isEmpty()) {
            tooltip = this.mAction.getText();
        }
        this.setToolTip(tooltip);
    }

    public final void selectAndFireEvent() {
        this.setSelected(true);
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        IClickListener[] listeners;
        BlockImageButton blockImageButton = this;
        synchronized (blockImageButton) {
            listeners = this.mClickListeners.toArray(new IClickListener[this.mClickListeners.size()]);
        }
        IClickListener[] iClickListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IClickListener listener = iClickListenerArray[n2];
            listener.buttonClicked(this);
            ++n2;
        }
    }

    public static interface IClickListener {
        public void buttonClicked(BlockImageButton var1);
    }
}

