/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget.categorybrowser;

import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.categorybrowser.CategoryRow;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class ConnectionOutline
extends Outline<SimpleColumn> {
    public ConnectionOutline(Composite parent, @NonNull OutlineModel<SimpleColumn> model) {
        super(parent, model, true, true);
        model.setShowOutline(false);
        this.setPermitDragSelect(false);
        this.setAllowColumnResize(false);
        this.setShowColumnLines(false);
    }

    @Override
    public int overRowIndex(int y) {
        Point panelZeroPt = this.toVirtual(new Point(0, 0));
        int index = super.overRowIndex(panelZeroPt.y);
        OutlineModel model = this.getModel();
        if (index >= 0) {
            Row row = model.getRowAtIndex(index);
            int upcomingRowIndex = index + 1;
            if (!(row instanceof CategoryRow) && (row = row.getParent()) instanceof CategoryRow) {
                index = model.getIndexOfRow(row);
            }
            if (row instanceof CategoryRow) {
                Row upcomingRow;
                SimpleColumn column = (SimpleColumn)model.getColumnAtIndex(0);
                if (upcomingRowIndex < model.getRowCount() && (upcomingRow = model.getRowAtIndex(upcomingRowIndex)) instanceof CategoryRow) {
                    Rectangle cellBounds = this.getCellBounds(upcomingRow, column);
                    panelZeroPt.y = cellBounds.y - (cellBounds.height + 1);
                }
                Rectangle cellBounds = this.getCellBounds(row, column);
                if (y >= panelZeroPt.y && y < panelZeroPt.y + cellBounds.height) {
                    return index;
                }
            }
        }
        return super.overRowIndex(y);
    }

    public void sizeToFit() {
        this.sizeColumnsToFit();
        this.adjustScrollBarsForContent();
    }

    @Override
    protected void drawMore(GC gc, boolean up, int amt) {
    }

    @Override
    protected void drawRowBackground(GC gc, Rectangle bounds, Row<SimpleColumn> row, boolean selected, boolean active) {
        if (row instanceof CategoryRow) {
            Pattern pattern = new Pattern(gc.getDevice(), 0.0f, (float)bounds.y, 0.0f, (float)(bounds.y + bounds.height), Colors.getDarkGray(), Colors.getBlack());
            gc.setBackgroundPattern(pattern);
            gc.fillRectangle(bounds);
            pattern.dispose();
        } else {
            super.drawRowBackground(gc, bounds, row, selected, active);
        }
    }

    @Override
    protected void paintCanvas(GC gc) {
        super.paintCanvas(gc);
        Point panelZeroPt = this.toVirtual(new Point(0, 0));
        int index = super.overRowIndex(panelZeroPt.y);
        OutlineModel<SimpleColumn> model = this.getModel();
        if (index >= 0) {
            Row<SimpleColumn> row = model.getRowAtIndex(index);
            int upcomingRowIndex = index + 1;
            if (!(row instanceof CategoryRow) && (row = row.getParent()) instanceof CategoryRow) {
                index = model.getIndexOfRow(row);
            }
            if (row instanceof CategoryRow) {
                Row upcomingRow;
                if (upcomingRowIndex < model.getRowCount() && (upcomingRow = model.getRowAtIndex(upcomingRowIndex)) instanceof CategoryRow) {
                    Rectangle cellBounds = this.getCellBounds(upcomingRow, (SimpleColumn)model.getColumnAtIndex(0));
                    panelZeroPt.y = cellBounds.y - (cellBounds.height + 1);
                }
                this.overdraw(gc, row, index, panelZeroPt);
            }
        }
    }

    @Override
    protected Rectangle repaintSelectionInternal() {
        Rectangle bounds = this.getClientArea();
        this.redraw(bounds.x, bounds.y, bounds.width, this.getModel().getRowHeight() + 1, false);
        return super.repaintSelectionInternal();
    }

    private void overdraw(GC gc, @NonNull Row<SimpleColumn> row, int index, Point panelZeroPt) {
        OutlineModel<SimpleColumn> model = this.getModel();
        boolean rowSelected = model.isRowSelected(row);
        boolean active = this.isFocusControl();
        Rectangle bounds = this.getRowBounds(row);
        bounds.x = panelZeroPt.x;
        bounds.y = panelZeroPt.y;
        gc.setBackground(this.getBackground(index, rowSelected, active));
        gc.fillRectangle(bounds);
        ((SimpleColumn)model.getColumnAtIndex(0)).drawRowCell(gc, bounds, row, rowSelected, active);
        gc.setForeground(this.getRowDividerColor(index));
        gc.drawLine(bounds.x, bounds.y - 1, bounds.width, bounds.y - 1);
        gc.drawLine(bounds.x, bounds.y + bounds.height, bounds.width, bounds.y + bounds.height);
    }
}

