/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.utility.text.TextFilter;
import com.arm.streamline.widget.TextField;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Composite;

public class FilterField
extends TextField {
    private IFilterMatcher mMatcher;
    private String mLastPattern = "";
    private Pattern mPattern = Pattern.compile(this.mLastPattern);
    private boolean mUsePattern;

    public FilterField(Composite parent, IFilterMatcher matcher, String watermark, String tooltip) {
        this(parent, matcher, watermark, tooltip, true);
    }

    public FilterField(Composite parent, IFilterMatcher matcher, String watermark, String tooltip, boolean usePattern) {
        super(parent);
        this.mMatcher = matcher;
        this.mUsePattern = usePattern;
        this.setWatermark(watermark);
        this.setToolTipText(tooltip);
    }

    public Pattern getPattern() {
        return this.mPattern;
    }

    @Override
    public void modifyText(ModifyEvent event) {
        super.modifyText(event);
        String text = this.getText().trim();
        if (this.mUsePattern) {
            if (!(text = TextFilter.enableCaseInsensitivityIfNoDirectivesPresent(text)).equals(this.mLastPattern)) {
                boolean valid;
                this.mLastPattern = text;
                try {
                    this.mPattern = Pattern.compile(text);
                    valid = true;
                    this.mMatcher.findMatches(this);
                }
                catch (PatternSyntaxException exception) {
                    valid = false;
                }
                catch (Exception exception) {
                    CommonPlugin.error((Throwable)exception);
                    valid = false;
                }
                this.setValid(valid);
            }
        } else if (!text.equals(this.mLastPattern)) {
            this.mLastPattern = text;
            this.mMatcher.findMatches(this);
        }
    }

    public static interface IFilterMatcher {
        public void findMatches(FilterField var1);
    }
}

