/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.widget;

import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class BorderedComposite
extends Composite
implements PaintListener {
    private final int TITLE_PADDING = 2;
    private Color mBorderColor;
    private int mHPadding;
    private int mVPadding;
    private int mHCornerRadius;
    private int mVCornerRadius;
    private String mTitle;

    public BorderedComposite(Composite parent) {
        this(parent, 5, 8);
    }

    public BorderedComposite(Composite parent, int padding, int cornerRadius) {
        this(parent, padding, padding, cornerRadius, cornerRadius);
    }

    public BorderedComposite(Composite parent, int hPadding, int vPadding, int hCornerRadius, int vCornerRadius) {
        this(parent, null, hPadding, vPadding, hCornerRadius, vCornerRadius);
    }

    public BorderedComposite(Composite parent, String title) {
        this(parent, title, 5, 8);
    }

    public BorderedComposite(Composite parent, String title, int padding, int cornerRadius) {
        this(parent, title, padding, padding, cornerRadius, cornerRadius);
    }

    public BorderedComposite(Composite parent, String title, int hPadding, int vPadding, int hCornerRadius, int vCornerRadius) {
        super(parent, 0x20000000);
        this.mTitle = title;
        this.mHPadding = hPadding;
        this.mVPadding = vPadding;
        this.mHCornerRadius = hCornerRadius;
        this.mVCornerRadius = vCornerRadius;
        this.mBorderColor = Colors.getWidgetNormalShadow();
        this.setFont(Fonts.getNormal());
        this.addPaintListener(this);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle bounds = super.computeTrim(x, y, width, height);
        bounds.x -= this.mHPadding;
        bounds.y -= this.mVPadding;
        bounds.width += this.mHPadding * 2;
        bounds.height += this.mVPadding * 2;
        if (this.mTitle != null && !this.mTitle.isEmpty()) {
            int fontHeight = FontInfo.get(this.getFont()).getHeight();
            bounds.y -= fontHeight;
            bounds.height += fontHeight;
        }
        return bounds;
    }

    public Color getBorderColor() {
        return this.mBorderColor;
    }

    public Rectangle getClientArea() {
        Rectangle bounds = super.getClientArea();
        bounds.x += this.mHPadding;
        bounds.y += this.mVPadding;
        bounds.width -= this.mHPadding * 2;
        bounds.height -= this.mVPadding * 2;
        if (this.mTitle != null && !this.mTitle.isEmpty()) {
            int fontHeight = FontInfo.get(this.getFont()).getHeight();
            bounds.y += fontHeight;
            bounds.height -= fontHeight;
        }
        return bounds;
    }

    public int getHCornerRadius() {
        return this.mHCornerRadius;
    }

    public int getHPadding() {
        return this.mHPadding;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public int getVCornerRadius() {
        return this.mVCornerRadius;
    }

    public int getVPadding() {
        return this.mVPadding;
    }

    public boolean hasTitle() {
        return this.mTitle != null && !this.mTitle.isEmpty();
    }

    public void paintControl(PaintEvent event) {
        Rectangle bounds = this.getClientArea();
        int x = bounds.x - this.mHPadding;
        int y = bounds.y - this.mVPadding;
        int width = bounds.width + this.mHPadding * 2 - 1;
        int height = bounds.height + this.mVPadding * 2 - 1;
        Font font = this.getFont();
        GC gc = event.gc;
        int savedAA = gc.getAntialias();
        gc.setAntialias(1);
        gc.setForeground(this.mBorderColor);
        if (this.mHCornerRadius > 0 && this.mVCornerRadius > 0) {
            gc.drawRoundRectangle(x, y, width, height, this.mHCornerRadius, this.mVCornerRadius);
            int indent = this.mHCornerRadius / 2;
            x += indent;
            width -= indent * 2;
        } else {
            gc.drawRectangle(x, y, width, height);
        }
        gc.setAntialias(savedAA);
        if (this.hasTitle()) {
            gc.setForeground(Colors.getWidgetForeground());
            TextDrawing.drawString(gc, TextDrawing.truncateString(font, this.mTitle, width - 2, 131072), x + 1, y - FontInfo.get(font).getHeight() - 2, 16384, true);
        }
    }

    public void setBorderColor(Color borderColor) {
        this.mBorderColor = borderColor;
    }

    public void setHCornerRadius(int cornerRadius) {
        this.mHCornerRadius = cornerRadius;
    }

    public void setHPadding(int hPadding) {
        this.mHPadding = hPadding;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setVCornerRadius(int cornerRadius) {
        this.mVCornerRadius = cornerRadius;
    }

    public void setVPadding(int vPadding) {
        this.mVPadding = vPadding;
    }
}

