/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.text;

import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.widget.FontInfo;
import com.arm.utils.Platform;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.swt.graphics.GC;

public class TextFilter {
    private static final String ESCAPE_SET = " \t\\\"'";

    public static final String enableCaseInsensitivityIfNoDirectivesPresent(String regex) {
        if (regex != null && !((String)regex).isEmpty() && !((String)regex).startsWith("(?")) {
            regex = "(?i)" + (String)regex;
        }
        return regex;
    }

    public static String escapeCommandLine(String[] args) {
        StringBuilder buffer = new StringBuilder();
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (buffer.length() > 0) {
                    buffer.append(' ');
                }
                if (Platform.isWindows()) {
                    length = ESCAPE_SET.length();
                    boolean needQuoting = false;
                    int i = 0;
                    while (i < length) {
                        if (arg.indexOf(ESCAPE_SET.charAt(i)) != -1) {
                            needQuoting = true;
                            break;
                        }
                        ++i;
                    }
                    if (needQuoting) {
                        if (arg.indexOf(34) == -1) {
                            buffer.append('\"');
                            buffer.append(arg);
                            buffer.append('\"');
                        } else if (arg.indexOf(39) == -1) {
                            buffer.append('\'');
                            buffer.append(arg);
                            buffer.append('\'');
                        } else {
                            buffer.append('\"');
                            length = arg.length();
                            i = 0;
                            while (i < length) {
                                char ch = arg.charAt(i);
                                if (ch == '\"') {
                                    buffer.append("\"'\"'\"");
                                } else {
                                    buffer.append(ch);
                                }
                                ++i;
                            }
                            buffer.append('\"');
                        }
                    } else {
                        buffer.append(arg);
                    }
                } else {
                    length = arg.length();
                    int i = 0;
                    while (i < length) {
                        char ch = arg.charAt(i);
                        if (ESCAPE_SET.indexOf(ch) != -1) {
                            buffer.append('\\');
                        }
                        buffer.append(ch);
                        ++i;
                    }
                }
                ++n2;
            }
        }
        return buffer.toString();
    }

    public static String[] extractCommandLine(String text) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        String line = text != null ? text.trim() : "";
        int size = line.length();
        boolean inEscape = false;
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        boolean canEscape = !Platform.isWindows();
        int i = 0;
        while (i < size) {
            char ch = line.charAt(i);
            if (inEscape) {
                inEscape = false;
                buffer.append(ch);
            } else if (canEscape && ch == '\\') {
                inEscape = true;
            } else if (inDoubleQuote) {
                if (ch == '\"') {
                    inDoubleQuote = false;
                } else {
                    buffer.append(ch);
                }
            } else if (inSingleQuote) {
                if (ch == '\'') {
                    inSingleQuote = false;
                } else {
                    buffer.append(ch);
                }
            } else if (ch == '\"') {
                inDoubleQuote = true;
            } else if (ch == '\'') {
                inSingleQuote = true;
            } else if (ch == ' ' || ch == '\t') {
                if (buffer.length() > 0) {
                    TextFilter.addArg(args, buffer.toString());
                    buffer.setLength(0);
                }
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        if (inEscape) {
            buffer.append('\\');
        } else if (inDoubleQuote) {
            buffer.insert(0, '\"');
        } else if (inSingleQuote) {
            buffer.insert(0, '\'');
        }
        if (buffer.length() > 0) {
            TextFilter.addArg(args, buffer.toString());
        }
        return args.toArray(new String[0]);
    }

    public static final String wrap(String text, int width, GC gc) {
        if (text == null) {
            return null;
        }
        FontInfo fontInfo = FontInfo.get(gc.getFont());
        StringBuilder all = new StringBuilder();
        StringBuilder line = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(text, "\r\n\t \\/", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.startsWith("\n")) {
                all.append(line.toString());
                all.append('\n');
                line.setLength(0);
                continue;
            }
            if (token.startsWith("\r")) continue;
            int stringLength = fontInfo.getWidth(line.toString());
            if (stringLength != 0 && stringLength + fontInfo.getWidth(token.toString()) > width) {
                all.append(line.toString());
                all.append('\n');
                line.setLength(0);
                if (" ".equals(token)) {
                    token = "";
                }
            }
            line.append(token);
        }
        all.append(line.toString());
        return all.toString();
    }

    private static void addArg(ArrayList<String> args, String arg) {
        if (args.isEmpty()) {
            args.add(FilePath.getPathForPlatform((String)FilePath.getFullPath(null, (String)arg)));
        } else {
            args.add(arg);
        }
    }
}

