/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.text;

import com.arm.eclipse.cdt.asmlib.AsmTextStyle;
import com.arm.eclipse.cdt.asmlib.model.AssemblerModel;
import com.arm.eclipse.cdt.asmlib.rules.AsmToken;
import com.arm.eclipse.cdt.asmlib.rules.LineTokenizer;
import com.arm.eclipse.cdt.asmlib.rules.TokenType;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;

public class DisassemblyRenderer {
    public static final int draw(GC gc, Font font, int x, int y, String disassembly, boolean isSelected, boolean isFocus, IInstructionsFile.IInstructionsFileInstructionEntry.Type type) {
        AssemblerModel.InstSet instSet = DisassemblyRenderer.map(type);
        List tokens = LineTokenizer.tokeniseLine((String)disassembly, (AssemblerModel.InstSet)instSet, (AssemblerModel.AsmMode)AssemblerModel.AsmMode.ARMASM, (boolean)true);
        if (tokens.size() > 0) {
            Font savedFont = gc.getFont();
            Color savedColor = gc.getForeground();
            int baseline = FontInfo.get(font).getBaseline();
            for (AsmToken token : tokens) {
                AsmTextStyle style = AsmTextStyle.fromTokenType((TokenType)token.getType());
                if (!isSelected && style != null) {
                    gc.setForeground(Colors.create(style.red, style.green, style.blue));
                } else {
                    gc.setForeground(Colors.getText(isFocus && isSelected));
                }
                Font currentFont = style != null ? Fonts.getFontWithStyle(font, style.defaultTextStyle) : font;
                gc.setFont(currentFont);
                FontInfo fontInfo = FontInfo.get(currentFont);
                String text = token.getText();
                TextDrawing.drawString(gc, text, x, y + baseline - fontInfo.getBaseline(), 16384);
                x += gc.stringExtent((String)text).x;
            }
            gc.setForeground(savedColor);
            gc.setFont(savedFont);
        }
        return x;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AssemblerModel.InstSet map(IInstructionsFile.IInstructionsFileInstructionEntry.Type type) {
        switch (type) {
            case A32: 
            case T32_16BIT: 
            case T32_32BIT: 
            case T32EE_16BIT: 
            case T32EE_32BIT: {
                return AssemblerModel.InstSet.AARCH32;
            }
            case A64: {
                return AssemblerModel.InstSet.AARCH64;
            }
        }
        return AssemblerModel.InstSet.UNKNOWN;
    }
}

