/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.io;

import com.arm.streamline.common.utility.io.IProgressProvider;
import com.arm.streamline.common.utility.io.IProgressTracker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ProgressTracker
implements IProgressTracker {
    private long bytesPerWorkUnit;
    private long lastReported;
    private final @NonNull IProgressMonitor monitor;
    private @Nullable IProgressProvider progressProvider;
    private int remainingWorkUnits;
    private @NonNull String title;

    public ProgressTracker() {
        this("", (IProgressMonitor)new NullProgressMonitor());
    }

    public ProgressTracker(@NonNull String title, @NonNull IProgressMonitor monitor) {
        this.title = title;
        this.monitor = monitor;
        this.monitor.beginTask(title, 0);
    }

    public void finish() {
        this.monitor.worked(this.remainingWorkUnits);
        this.monitor.done();
    }

    public void setProgressProvider(@Nullable IProgressProvider progressProvider) {
        this.progressProvider = progressProvider;
        if (progressProvider != null) {
            long totalWorkUnits = progressProvider.getTotalLength();
            if (totalWorkUnits > 10000L) {
                this.remainingWorkUnits = 10000;
                this.bytesPerWorkUnit = Math.max(totalWorkUnits / (long)this.remainingWorkUnits, 1L);
                this.lastReported = 0L;
            } else {
                this.remainingWorkUnits = (int)totalWorkUnits;
                this.bytesPerWorkUnit = 1L;
                this.lastReported = 0L;
            }
            this.monitor.beginTask(this.title, this.remainingWorkUnits);
        } else {
            this.remainingWorkUnits = 0;
            this.bytesPerWorkUnit = 0L;
            this.lastReported = 0L;
            this.monitor.beginTask(this.title, this.remainingWorkUnits);
        }
    }

    public void setSubTaskTitle(@NonNull String title) {
        this.monitor.subTask(title);
    }

    public void setTaskTitle(@NonNull String title) {
        this.title = title;
        this.monitor.setTaskName(title);
    }

    public void update() throws InterruptedException {
        long delta;
        @Nullable IProgressProvider progressProvider = this.progressProvider;
        if (progressProvider != null && (delta = progressProvider.getCurrentProgress() - this.lastReported) >= this.bytesPerWorkUnit) {
            int work = (int)(delta / this.bytesPerWorkUnit);
            if (work > this.remainingWorkUnits) {
                work = this.remainingWorkUnits;
            }
            if (work > 0) {
                this.monitor.worked(work);
                this.remainingWorkUnits -= work;
            }
            delta /= this.bytesPerWorkUnit;
            this.lastReported += (delta *= this.bytesPerWorkUnit);
        }
        if (this.monitor.isCanceled()) {
            throw new InterruptedException("Operation Canceled - this is probably ok.");
        }
    }
}

