/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.io;

import com.arm.streamline.utility.io.GPUImageDescriptor;
import com.arm.streamline.utility.io.PpmImageDescriptor;
import com.arm.utils.Platform;
import java.io.RandomAccessFile;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ImageUtils {
    public static final String BMP = ".bmp";
    public static final String GIF = ".gif";
    public static final String JPEG = ".jpg";
    public static final String PNG = ".png";
    public static final String PPM = ".ppm";
    public static final String TIFF = ".tif";
    public static final String GPU_RGBA = ".gpu";
    public static final String GZIP = ".bmp.gz";

    public static final String getImageDataExtension(byte[] data) {
        return ImageUtils.getImageDataExtension(data, BMP);
    }

    public static final String getImageDataExtension(byte[] data, String defaultExtension) {
        if (data.length > 10) {
            if (data[0] == 71 && data[1] == 73 && data[2] == 70) {
                return GIF;
            }
            if ((data[0] & 0xFF) == 137 && data[1] == 80 && data[2] == 78 && data[3] == 71 && data[4] == 13 && data[5] == 10 && data[6] == 26 && data[7] == 10) {
                return PNG;
            }
            if ((data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 216 && (data[2] & 0xFF) == 255 && (data[3] & 0xFF) == 224 && data[6] == 74 && data[7] == 70 && data[8] == 73 && data[9] == 70 && data[10] == 0) {
                return JPEG;
            }
            if (data[0] == 73 && data[1] == 73 && data[2] == 42 && data[3] == 0 || data[0] == 77 && data[1] == 77 && data[2] == 0 && data[3] == 42) {
                return TIFF;
            }
            if (data[0] == 66 && data[1] == 77) {
                return BMP;
            }
            if (data[0] == 80 && data[1] == 54) {
                return PPM;
            }
            if (data[0] == 71 && data[1] == 80 && data[2] == 85 && data[3] == 49) {
                return GPU_RGBA;
            }
            if (data[0] == 31 && data[1] == -117 && data[2] == 8) {
                return GZIP;
            }
        }
        return defaultExtension;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Image load(Device device, String path) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
                byte[] buffer = new byte[11];
                raf.readFully(buffer);
                String type = ImageUtils.getImageDataExtension(buffer);
                if (PPM.equals(type)) {
                    return new PpmImageDescriptor(path).createImage(device);
                }
                if (GPU_RGBA.equals(type)) {
                    return new GPUImageDescriptor(path).createImage(device);
                }
                if (!Platform.isMacintosh() || !BMP.equals(type)) return new Image(device, path);
                try {
                    return new Image(device, new ImageData(path));
                }
                catch (Exception exception) {
                    return new Image(device, path);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                } else {
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final Image load(String path) {
        return ImageUtils.load(null, path);
    }
}

