/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.expression.operator;

import com.arm.streamline.utility.expression.EvaluationException;

public abstract class Operator {
    private String mSymbol;
    private int mPrecedence;
    private boolean mUnary;

    protected Operator(String symbol, int precedence) {
        this.mSymbol = symbol;
        this.mPrecedence = precedence;
    }

    protected Operator(String symbol, int precedence, boolean unary) {
        this.mSymbol = symbol;
        this.mPrecedence = precedence;
        this.mUnary = unary;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return object instanceof Operator && this.mSymbol.equals(((Operator)object).getSymbol());
    }

    public abstract Object evaluate(Object var1) throws EvaluationException;

    public abstract Object evaluate(Object var1, Object var2) throws EvaluationException;

    public final int getLength() {
        return this.mSymbol.length();
    }

    public final int getPrecedence() {
        return this.mPrecedence;
    }

    public final String getSymbol() {
        return this.mSymbol;
    }

    public final int hashCode() {
        return this.mSymbol.hashCode();
    }

    public final boolean isUnary() {
        return this.mUnary;
    }

    public final String toString() {
        return this.getSymbol();
    }
}

