/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.expression.function;

import com.arm.streamline.utility.expression.ArgumentTokenizer;
import com.arm.streamline.utility.expression.EvaluationException;
import com.arm.streamline.utility.expression.Evaluator;
import com.arm.streamline.utility.expression.function.IExpressionFunction;

public class If
implements IExpressionFunction {
    @Override
    public final Object execute(Evaluator evaluator, String arguments) throws EvaluationException {
        Evaluator ev = new Evaluator(evaluator);
        ArgumentTokenizer tokenizer = new ArgumentTokenizer(arguments);
        Object result = ev.evaluate(tokenizer.nextToken());
        if (result instanceof Double) {
            if ((Double)result == 0.0) {
                tokenizer.nextToken();
            }
        } else {
            String str = result.toString();
            if (str.isEmpty()) {
                tokenizer.nextToken();
            } else {
                try {
                    if (Double.parseDouble(str) == 0.0) {
                        tokenizer.nextToken();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return ev.evaluate(tokenizer.nextToken());
    }

    @Override
    public final String getName() {
        return "if";
    }
}

