/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.expression;

import com.arm.streamline.utility.expression.ArgumentTokenizer;
import com.arm.streamline.utility.expression.EvaluationException;
import com.arm.streamline.utility.expression.ExpressionMessages;
import com.arm.streamline.utility.expression.ExpressionOperand;
import com.arm.streamline.utility.expression.ExpressionOperator;
import com.arm.streamline.utility.expression.ExpressionTree;
import com.arm.streamline.utility.expression.IVariableResolver;
import com.arm.streamline.utility.expression.NextOperator;
import com.arm.streamline.utility.expression.ParsedFunction;
import com.arm.streamline.utility.expression.function.Abs;
import com.arm.streamline.utility.expression.function.Ceil;
import com.arm.streamline.utility.expression.function.Floor;
import com.arm.streamline.utility.expression.function.IExpressionFunction;
import com.arm.streamline.utility.expression.function.If;
import com.arm.streamline.utility.expression.function.Max;
import com.arm.streamline.utility.expression.function.Min;
import com.arm.streamline.utility.expression.function.Round;
import com.arm.streamline.utility.expression.operator.Add;
import com.arm.streamline.utility.expression.operator.And;
import com.arm.streamline.utility.expression.operator.CloseParen;
import com.arm.streamline.utility.expression.operator.Divide;
import com.arm.streamline.utility.expression.operator.Equal;
import com.arm.streamline.utility.expression.operator.GreaterThan;
import com.arm.streamline.utility.expression.operator.GreaterThanOrEqual;
import com.arm.streamline.utility.expression.operator.LessThan;
import com.arm.streamline.utility.expression.operator.LessThanOrEqual;
import com.arm.streamline.utility.expression.operator.Mod;
import com.arm.streamline.utility.expression.operator.Multiply;
import com.arm.streamline.utility.expression.operator.Not;
import com.arm.streamline.utility.expression.operator.NotEqual;
import com.arm.streamline.utility.expression.operator.OpenParen;
import com.arm.streamline.utility.expression.operator.Operator;
import com.arm.streamline.utility.expression.operator.Or;
import com.arm.streamline.utility.expression.operator.Subtract;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class Evaluator {
    private IVariableResolver mVariableResolver;
    private ArrayList<Operator> mOperators = new ArrayList();
    private HashMap<String, IExpressionFunction> mFunctions = new HashMap();
    private Stack<ExpressionOperator> mOperatorStack;
    private Stack<Object> mOperandStack;

    private static final NextOperator nextOperator(String expression, int start, int max, Operator operator) {
        int length = operator.getLength();
        String symbol = operator.getSymbol();
        if (length == 1) {
            char symbolChar = symbol.charAt(0);
            if (expression.charAt(start) == symbolChar) {
                if (symbolChar == '-' && start > 1 && expression.charAt(start - 1) == 'e' && Character.isDigit(expression.charAt(start - 2))) {
                    return null;
                }
                return new NextOperator(operator, start);
            }
        } else if (expression.regionMatches(start, symbol, 0, start + length <= max ? length : max - start)) {
            return new NextOperator(operator, start);
        }
        return null;
    }

    private static final int processOperand(String expression, int start, int operatorIndex, Stack<Object> operandStack, Operator unaryOperator) throws EvaluationException {
        int result;
        String text;
        if (operatorIndex == -1) {
            text = expression.substring(start).trim();
            result = expression.length();
        } else {
            text = expression.substring(start, operatorIndex).trim();
            result = operatorIndex;
        }
        if (text.length() == 0) {
            throw new EvaluationException(ExpressionMessages.INVALID_EXPRESSION);
        }
        operandStack.push(new ExpressionOperand(text, unaryOperator));
        return result;
    }

    public Evaluator() {
        this((IVariableResolver)null);
    }

    public Evaluator(Evaluator other) {
        this.mVariableResolver = other.mVariableResolver;
        this.mOperators = (ArrayList)other.mOperators.clone();
        this.mFunctions = (HashMap)other.mFunctions.clone();
    }

    public Evaluator(IVariableResolver variableResolver) {
        this.mVariableResolver = variableResolver;
        this.mOperators.add(new OpenParen());
        this.mOperators.add(new CloseParen());
        this.mOperators.add(new Add());
        this.mOperators.add(new Subtract());
        this.mOperators.add(new Multiply());
        this.mOperators.add(new Divide());
        this.mOperators.add(new Equal());
        this.mOperators.add(new NotEqual());
        this.mOperators.add(new LessThanOrEqual());
        this.mOperators.add(new LessThan());
        this.mOperators.add(new GreaterThanOrEqual());
        this.mOperators.add(new GreaterThan());
        this.mOperators.add(new And());
        this.mOperators.add(new Or());
        this.mOperators.add(new Not());
        this.mOperators.add(new Mod());
        this.addFunction(new Abs());
        this.addFunction(new Ceil());
        this.addFunction(new Floor());
        this.addFunction(new If());
        this.addFunction(new Max());
        this.addFunction(new Min());
        this.addFunction(new Round());
    }

    public void addFunction(IExpressionFunction function) {
        this.mFunctions.put(function.getName(), function);
    }

    public final Object evaluate(String expression) throws EvaluationException {
        this.parse(expression);
        while (this.mOperatorStack.size() > 0) {
            this.processTree(this.mOperandStack, this.mOperatorStack);
        }
        if (this.mOperandStack.isEmpty()) {
            return "";
        }
        return this.evaluateOperand(this.mOperandStack.pop());
    }

    public final double evaluateToNumber(String expression) throws EvaluationException {
        try {
            return ArgumentTokenizer.getDouble(this.evaluate(expression));
        }
        catch (Exception exception) {
            throw new EvaluationException(exception);
        }
    }

    public IVariableResolver getVariableResolver() {
        return this.mVariableResolver;
    }

    private final NextOperator nextOperator(String expression, int start, Operator match) {
        int length = expression.length();
        int i = start;
        while (i < length) {
            char c = expression.charAt(i);
            switch (c) {
                case '!': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '|': {
                    if (match != null) {
                        NextOperator next = Evaluator.nextOperator(expression, i, length, match);
                        if (next == null) break;
                        return next;
                    }
                    int opCount = this.mOperators.size();
                    int j = 0;
                    while (j < opCount) {
                        NextOperator next = Evaluator.nextOperator(expression, i, length, this.mOperators.get(j));
                        if (next != null) {
                            return next;
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parse(String expression) throws EvaluationException {
        try {
            this.mOperandStack = new Stack();
            this.mOperatorStack = new Stack();
            boolean haveOperand = false;
            boolean haveOperator = false;
            Operator unaryOperator = null;
            int max = expression.length();
            int i = 0;
            while (i < max) {
                if (Character.isWhitespace(expression.charAt(i))) {
                    ++i;
                    continue;
                }
                Operator operator = null;
                int opIndex = -1;
                NextOperator nextOperator = this.nextOperator(expression, i, null);
                if (nextOperator != null) {
                    operator = nextOperator.mOperator;
                    opIndex = nextOperator.mIndex;
                }
                if (opIndex > i || opIndex == -1) {
                    i = Evaluator.processOperand(expression, i, opIndex, this.mOperandStack, unaryOperator);
                    haveOperand = true;
                    haveOperator = false;
                    unaryOperator = null;
                }
                if (opIndex != i) continue;
                if (nextOperator != null && nextOperator.mOperator.isUnary() && (haveOperator || i == 0)) {
                    i = opIndex + nextOperator.mOperator.getSymbol().length();
                    if (unaryOperator != null) throw new EvaluationException(String.format(ExpressionMessages.CONSECUTIVE_UNARY_OPS, i));
                    unaryOperator = nextOperator.mOperator;
                } else {
                    i = this.processOperator(expression, opIndex, operator, this.mOperatorStack, this.mOperandStack, haveOperand, unaryOperator);
                    unaryOperator = null;
                }
                if (nextOperator != null && nextOperator.mOperator instanceof CloseParen) continue;
                haveOperand = false;
                haveOperator = true;
            }
            return;
        }
        catch (EvaluationException evalEx) {
            throw evalEx;
        }
        catch (Exception exception) {
            throw new EvaluationException(exception.getMessage(), exception);
        }
    }

    private final NextOperator processFunction(String expression, int operatorIndex, Stack<Object> operandStack) throws EvaluationException {
        int parens = 1;
        NextOperator nextOperator = null;
        int next = operatorIndex;
        while (parens > 0) {
            nextOperator = this.nextOperator(expression, next + 1, null);
            if (nextOperator == null) {
                throw new EvaluationException(ExpressionMessages.FUNCTION_NOT_CLOSED);
            }
            if (nextOperator.mOperator instanceof OpenParen) {
                ++parens;
            } else if (nextOperator.mOperator instanceof CloseParen) {
                --parens;
            }
            next = nextOperator.mIndex;
        }
        ExpressionOperand operand = (ExpressionOperand)operandStack.pop();
        IExpressionFunction function = this.mFunctions.get(operand.mValue);
        if (function == null) {
            throw new EvaluationException(MessageFormat.format(ExpressionMessages.FUNCTION_NOT_DEFINED, operand.mValue));
        }
        operandStack.push(new ParsedFunction(function, expression.substring(operatorIndex + 1, next), operand.mUnaryOperator));
        return nextOperator;
    }

    private final int processOperator(String expression, int index, Operator operator, Stack<ExpressionOperator> operatorStack, Stack<Object> operandStack, boolean haveOperand, Operator unaryOperator) throws EvaluationException {
        if (haveOperand && operator instanceof OpenParen) {
            NextOperator nextOperator = this.processFunction(expression, index, operandStack);
            operator = nextOperator.mOperator;
            index = nextOperator.mIndex + operator.getLength();
            nextOperator = this.nextOperator(expression, index, null);
            if (nextOperator == null) {
                return index;
            }
            operator = nextOperator.mOperator;
            index = nextOperator.mIndex;
        }
        if (operator instanceof OpenParen) {
            operatorStack.push(new ExpressionOperator(operator, unaryOperator));
        } else if (operator instanceof CloseParen) {
            stackOp = operatorStack.size() > 0 ? operatorStack.peek() : null;
            while (stackOp != null && !(stackOp.mOperator instanceof OpenParen)) {
                this.processTree(operandStack, operatorStack);
                ExpressionOperator expressionOperator = stackOp = operatorStack.size() > 0 ? operatorStack.peek() : null;
            }
            if (operatorStack.isEmpty()) {
                throw new EvaluationException(ExpressionMessages.INVALID_EXPRESSION);
            }
            ExpressionOperator exop = operatorStack.pop();
            if (!(exop.mOperator instanceof OpenParen)) {
                throw new EvaluationException(ExpressionMessages.INVALID_EXPRESSION);
            }
            if (exop.mUnaryOperator != null) {
                operandStack.push(new ExpressionTree(this, operandStack.pop(), null, null, exop.mUnaryOperator));
            }
        } else {
            if (operatorStack.size() > 0) {
                stackOp = operatorStack.peek();
                while (stackOp != null && stackOp.mOperator.getPrecedence() >= operator.getPrecedence()) {
                    this.processTree(operandStack, operatorStack);
                    ExpressionOperator expressionOperator = stackOp = operatorStack.size() > 0 ? operatorStack.peek() : null;
                }
            }
            operatorStack.push(new ExpressionOperator(operator, unaryOperator));
        }
        return index + operator.getLength();
    }

    private final void processTree(Stack<Object> operandStack, Stack<ExpressionOperator> operatorStack) {
        Object rightOperand = operandStack.size() > 0 ? operandStack.pop() : null;
        Object leftOperand = operandStack.size() > 0 ? operandStack.pop() : null;
        operandStack.push(new ExpressionTree(this, leftOperand, rightOperand, operatorStack.pop().mOperator, null));
    }

    private final String replaceVariables(String expression) throws EvaluationException {
        int dollar = expression.indexOf(36);
        while (dollar >= 0) {
            StringBuilder buffer;
            int last = dollar;
            int max = expression.length();
            int i = dollar + 1;
            while (i < max) {
                char ch = expression.charAt(i);
                if (!(ch == '_' || ch == '.' || ch == '#' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') && (i == dollar + 1 || ch < '0' || ch > '9')) break;
                last = i++;
            }
            if (dollar != last) {
                String name = expression.substring(dollar + 1, last + 1);
                String value = null;
                if (this.mVariableResolver != null) {
                    value = this.mVariableResolver.resolveVariable(name);
                }
                if (value == null || value.trim().length() == 0) {
                    throw new EvaluationException(MessageFormat.format(ExpressionMessages.UNABLE_TO_RESOLVE, name));
                }
                buffer = new StringBuilder();
                if (dollar > 0) {
                    buffer.append(expression.substring(0, dollar));
                }
                buffer.append(value);
                if (last + 1 < max) {
                    buffer.append(expression.substring(last + 1));
                }
            } else {
                throw new EvaluationException(MessageFormat.format(ExpressionMessages.INVALID_VARIABLE, dollar));
            }
            expression = buffer.toString();
            dollar = expression.indexOf(36);
        }
        return expression;
    }

    final Object evaluateOperand(Object operand) throws EvaluationException {
        if (operand instanceof ExpressionTree) {
            return ((ExpressionTree)operand).evaluate();
        }
        if (operand instanceof ExpressionOperand) {
            ExpressionOperand exop = (ExpressionOperand)operand;
            String value = this.replaceVariables(exop.mValue);
            Operator unary = exop.mUnaryOperator;
            return unary != null ? unary.evaluate(value) : value;
        }
        if (operand instanceof ParsedFunction) {
            ParsedFunction function = (ParsedFunction)operand;
            Object value = function.mFunction.execute(this, this.replaceVariables(function.mArguments));
            if (function.mUnaryOperator != null) {
                value = function.mUnaryOperator.evaluate(value);
            }
            return value;
        }
        if (operand != null) {
            throw new EvaluationException(ExpressionMessages.INVALID_EXPRESSION);
        }
        return null;
    }
}

