/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.utility.expression;

import com.arm.streamline.utility.expression.EvaluationException;
import com.arm.streamline.utility.expression.Evaluator;
import com.arm.streamline.utility.expression.ExpressionMessages;
import java.util.Enumeration;

public class ArgumentTokenizer
implements Enumeration<String> {
    private String mArguments = null;

    public static final double getDouble(Object arg) {
        if (arg instanceof Double) {
            return (Double)arg;
        }
        return Double.parseDouble(arg.toString());
    }

    public static final double getDoubleArgument(Evaluator evaluator, String arguments) throws EvaluationException {
        try {
            return ArgumentTokenizer.getDouble(new Evaluator(evaluator).evaluate(arguments));
        }
        catch (Exception exception) {
            throw new EvaluationException(ExpressionMessages.INVALID_ARGUMENT + arguments, exception);
        }
    }

    public static final double getDoubleOperand(Object arg) throws EvaluationException {
        try {
            return ArgumentTokenizer.getDouble(arg);
        }
        catch (Exception exception) {
            throw new EvaluationException(ExpressionMessages.INVALID_OPERAND + String.valueOf(arg), exception);
        }
    }

    public ArgumentTokenizer(String arguments) {
        this.mArguments = arguments;
    }

    @Override
    public final boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public final boolean hasMoreTokens() {
        return this.mArguments.length() > 0;
    }

    @Override
    public final String nextElement() {
        return this.nextToken();
    }

    public final String nextToken() {
        int length = this.mArguments.length();
        int parens = 0;
        int i = 0;
        while (i < length) {
            char ch = this.mArguments.charAt(i);
            if (ch == '(') {
                ++parens;
            } else if (ch == ')') {
                --parens;
            } else if (ch == ',' && parens == 0) {
                String token = this.mArguments.substring(0, i);
                this.mArguments = this.mArguments.substring(i + 1);
                return token;
            }
            ++i;
        }
        String token = this.mArguments;
        this.mArguments = "";
        return token;
    }
}

