/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part.lpv;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.ui.part.lpv.AndroidDeviceDetector;
import com.arm.streamline.ui.part.lpv.AndroidGatordKiller;
import com.arm.streamline.ui.part.lpv.AndroidPackageDetector;
import com.arm.streamline.ui.vm.IAndroidDeviceModel;
import com.arm.streamline.ui.vm.IAndroidPackage;
import com.arm.streamline.ui.vm.IAndroidTargetDevice;
import com.arm.streamline.ui.vm.IPackageDetector;
import com.arm.streamline.ui.vm.RunAsInfo;
import com.arm.streamline.utility.AndroidPackageUtility;
import com.arm.streamline.utility.IAdbRunnerCache;
import com.arm.streamline.utility.IAdbRunnerFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.services.IDisposable;

public class AndroidDeviceModel
implements IAndroidDeviceModel {
    private static final @NonNull IDisposable NULL_DISPOSABLE = () -> {};
    private final @NonNull IAdbRunnerFactory adbRunnerFactory;
    private final @NonNull AndroidDeviceDetector deviceDetector;
    private final @NonNull AndroidGatordKiller gatordKiller;
    private @NonNull IDisposable lastDeviceDetectedFuture = NULL_DISPOSABLE;
    private final @NonNull Map<@NonNull String, @NonNull PackageCacheEntry> packageCache = new HashMap<String, PackageCacheEntry>();
    private final @NonNull IPackageDetector packageDetector;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IPackageDetector.IPackageDetectorTask packageRequestActiveTask;
    private final @NonNull Map<@NonNull String, @NonNull Supplier<// Could not load outer class - annotation placement on inner may be incorrect
    IPackageDetector.IPackageDetectorTask>> packageRequestPendingTasks = new LinkedHashMap<String, Supplier<IPackageDetector.IPackageDetectorTask>>();

    public AndroidDeviceModel(@NonNull IAdbRunnerFactory adbRunnerFactory, @NonNull IAdbRunnerCache adbRunnerCache) {
        this.adbRunnerFactory = adbRunnerFactory;
        @NonNull Consumer<@NonNull Exception> exceptionConsumer = e -> this.targetBrowserExceptionProperty().set(e);
        this.deviceDetector = new AndroidDeviceDetector(adbRunnerCache, exceptionConsumer);
        this.packageDetector = new AndroidPackageDetector(d -> this.deviceDetector.getCommandRunnerForDevice(d.getSerialNumber()));
        this.gatordKiller = new AndroidGatordKiller();
    }

    public <T extends IAdbRunnerFactory & IAdbRunnerCache> AndroidDeviceModel(@NonNull T adbRunnerFactoryCache) {
        this(adbRunnerFactoryCache, adbRunnerFactoryCache);
    }

    AndroidDeviceModel(@NonNull IAdbRunnerFactory adbRunnerFactory, @NonNull AndroidDeviceDetector deviceDetector, @NonNull IPackageDetector packageDetector, @NonNull AndroidGatordKiller gatordKiller) {
        this.adbRunnerFactory = adbRunnerFactory;
        this.deviceDetector = deviceDetector;
        this.packageDetector = packageDetector;
        this.gatordKiller = gatordKiller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPackageListing() {
        Map<String, PackageCacheEntry> map = this.packageCache;
        synchronized (map) {
            this.packageRequestPendingTasks.clear();
            IPackageDetector.IPackageDetectorTask packageRequestActiveTask = this.packageRequestActiveTask;
            if (packageRequestActiveTask != null) {
                packageRequestActiveTask.dispose();
            }
            this.packageRequestActiveTask = null;
        }
    }

    public void dispose() {
        this.lastDeviceDetectedFuture.dispose();
        this.cancelPackageListing();
    }

    public boolean doKillGatordOnDevice(@NonNull IAndroidTargetDevice device) {
        return this.gatordKiller.doKillGatordOnDevice(device);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAndroidDeviceModel.ADBPathChangeOutcome handleADBPathChange(@Nullable File newPath) {
        IAdbProcessRunner adbProcessRunner = null;
        if (newPath == null) {
            this.deviceDetector.setAdbProcessRunner(null);
            this.gatordKiller.setAdbProcessRunner(null);
            return IAndroidDeviceModel.ADBPathChangeOutcome.NULL_PATH;
        }
        try {
            adbProcessRunner = this.adbRunnerFactory.create(newPath);
            IAndroidDeviceModel.ADBPathChangeOutcome aDBPathChangeOutcome = IAndroidDeviceModel.ADBPathChangeOutcome.SUCCESS;
            return aDBPathChangeOutcome;
        }
        catch (IOException e) {
            StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)("Could not execute 'adb' executable " + String.valueOf(newPath)), (Throwable)e);
            this.deviceDetector.setAdbProcessRunner(null);
            this.gatordKiller.setAdbProcessRunner(null);
            IAndroidDeviceModel.ADBPathChangeOutcome aDBPathChangeOutcome = IAndroidDeviceModel.ADBPathChangeOutcome.FAILURE;
            return aDBPathChangeOutcome;
        }
        finally {
            this.deviceDetector.setAdbProcessRunner(adbProcessRunner);
            this.gatordKiller.setAdbProcessRunner(adbProcessRunner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDevicePackageListingCached(@NonNull IAndroidTargetDevice device) {
        Map<String, PackageCacheEntry> map = this.packageCache;
        synchronized (map) {
            return this.packageCache.containsKey(device.getSerialNumber());
        }
    }

    public boolean isPackageInstalled(@NonNull String deviceSerialNumber, @NonNull RunAsInfo runAsInfo) {
        IAdbCommandRunner commandRunner = this.deviceDetector.getCommandRunnerForDevice(deviceSerialNumber);
        if (commandRunner == null) {
            return false;
        }
        return AndroidPackageUtility.isPackageInstalled(commandRunner, runAsInfo);
    }

    public void requestDevices(@NonNull Consumer<@NonNull List<@NonNull IAndroidTargetDevice>> consumer) {
        this.lastDeviceDetectedFuture.dispose();
        this.lastDeviceDetectedFuture = this.deviceDetector.requestDevices(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPackageList(boolean refresh, boolean onlyDebuggable, @NonNull IAndroidTargetDevice selectedDevice, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IPackageDetector.IPackageTaskProgressConsumer consumer) {
        Map<String, PackageCacheEntry> map = this.packageCache;
        synchronized (map) {
            String mapKey = selectedDevice.getSerialNumber();
            PackageCacheEntry cacheEntry = this.packageCache.get(mapKey);
            if (!(refresh || cacheEntry == null || onlyDebuggable != cacheEntry.onlyDebuggable && cacheEntry.onlyDebuggable)) {
                consumer.complete(selectedDevice, cacheEntry.onlyDebuggable, cacheEntry.packages);
                return;
            }
            this.packageCache.remove(mapKey);
            IPackageDetector.IPackageDetectorTask packageRequestActiveTask = this.packageRequestActiveTask;
            if (packageRequestActiveTask != null) {
                if (packageRequestActiveTask.getSelectedDevice().getSerialNumber().contentEquals(mapKey)) {
                    packageRequestActiveTask.requestProgress();
                } else {
                    this.packageRequestPendingTasks.computeIfAbsent(mapKey, k -> () -> this.createPackageRequestTask(selectedDevice, onlyDebuggable, consumer));
                    consumer.progress(selectedDevice, 0, 0);
                }
            } else {
                this.packageRequestActiveTask = this.createPackageRequestTask(selectedDevice, onlyDebuggable, consumer);
            }
        }
    }

    public @NonNull ReadOnlyBooleanProperty scanActiveProperty() {
        return this.deviceDetector.scanActiveProperty();
    }

    public @NonNull SimpleObjectProperty<@Nullable Exception> targetBrowserExceptionProperty() {
        return this.deviceDetector.targetBrowserExceptionProperty();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IPackageDetector.IPackageDetectorTask createPackageRequestTask(@NonNull IAndroidTargetDevice sd, final boolean onlyDebuggable, final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IPackageDetector.IPackageTaskProgressConsumer consumer) {
        return this.packageDetector.requestPackageList(sd, onlyDebuggable, new IPackageDetector.IPackageTaskProgressConsumer(){
            private final @NonNull AtomicBoolean cancelled = new AtomicBoolean(false);
            private int percentProgress = Integer.MIN_VALUE;

            public void cancelled(@NonNull IAndroidTargetDevice selectedDevice) {
                if (!this.cancelled.getAndSet(true)) {
                    this.updateCacheState(selectedDevice, onlyDebuggable, null);
                    consumer.cancelled(selectedDevice);
                }
            }

            public void complete(@NonNull IAndroidTargetDevice selectedDevice, boolean onlyDebuggable2, @NonNull List<@NonNull IAndroidPackage> results) {
                if (!this.cancelled.getAndSet(true)) {
                    this.updateCacheState(selectedDevice, onlyDebuggable2, results);
                    consumer.complete(selectedDevice, onlyDebuggable2, results);
                }
            }

            public void progress(@NonNull IAndroidTargetDevice selectedDevice, int num, int total) {
                if (!this.cancelled.get()) {
                    int newProgress;
                    int n = newProgress = total > 0 ? (int)((long)num * 100L / (long)total) : 0;
                    if (this.percentProgress != newProgress) {
                        this.percentProgress = newProgress;
                        consumer.progress(selectedDevice, num, total);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateCacheState(@NonNull IAndroidTargetDevice selectedDevice, boolean onlyDebuggable2, @Nullable List<@NonNull IAndroidPackage> results) {
                Map<String, PackageCacheEntry> map = AndroidDeviceModel.this.packageCache;
                synchronized (map) {
                    String mapKey = selectedDevice.getSerialNumber();
                    if (results != null) {
                        AndroidDeviceModel.this.packageCache.put(mapKey, new PackageCacheEntry(onlyDebuggable2, results));
                    } else {
                        AndroidDeviceModel.this.packageCache.remove(mapKey);
                    }
                    AndroidDeviceModel.this.packageRequestActiveTask = null;
                    Iterator<Supplier<IPackageDetector.IPackageDetectorTask>> it = AndroidDeviceModel.this.packageRequestPendingTasks.values().iterator();
                    if (it.hasNext()) {
                        Supplier<IPackageDetector.IPackageDetectorTask> newRequest = it.next();
                        it.remove();
                        AndroidDeviceModel.this.packageRequestActiveTask = newRequest.get();
                    }
                }
            }
        });
    }

    private static final class PackageCacheEntry {
        public final boolean onlyDebuggable;
        public final @NonNull List<@NonNull IAndroidPackage> packages;

        public PackageCacheEntry(boolean onlyDebuggable, @NonNull List<@NonNull IAndroidPackage> packages) {
            this.onlyDebuggable = onlyDebuggable;
            this.packages = packages;
        }
    }
}

