/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ui.part.lpv;

import com.arm.streamline.analysis.gator.GatorProtocolVerifier;
import com.arm.streamline.analysis.gator.GatorProtocolVersion;
import com.arm.streamline.analysis.gator.GatorProtocolVersionConstants;
import com.arm.streamline.common.xml.gatorConfig.GatorCurrentConfig;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.databrowser.browser.AdbTargetBrowser;
import com.arm.streamline.databrowser.browser.BrowseResult;
import com.arm.streamline.databrowser.browser.ConnectionType;
import com.arm.streamline.databrowser.browser.ITargetBrowser;
import com.arm.streamline.databrowser.browser.ITargetBrowserClient;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.adb.utils.AdbDevice;
import com.arm.streamline.ui.part.lpv.AndroidTargetDevice;
import com.arm.streamline.ui.vm.IAndroidDeviceDetector;
import com.arm.streamline.ui.vm.IAndroidTargetDevice;
import com.arm.streamline.ui.vm.RunAsInfo;
import com.arm.streamline.utility.IAdbRunnerCache;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.services.IDisposable;

public class AndroidDeviceDetector
implements IAndroidDeviceDetector {
    private static final int POLL_INTERVAL_SECONDS = 1;
    private final @NonNull AtomicReference<@Nullable IAdbProcessRunner> adbProcessRunner = new AtomicReference();
    private final @NonNull IAdbRunnerCache adbRunnerCache;
    private @NonNull ITargetBrowser browser = new NullTargetBrowser();
    private final @NonNull Function<@Nullable IAdbProcessRunner, @NonNull ITargetBrowser> browserCreator;
    private final @NonNull AtomicReference<@NonNull Consumer<@NonNull List<@NonNull IAndroidTargetDevice>>> lastConsumer = new AtomicReference<Consumer<List>>(list -> {});
    private final @NonNull LinkedHashMap<@NonNull String, @NonNull IAndroidTargetDevice> mapByAddress = new LinkedHashMap();
    private final @NonNull SimpleBooleanProperty scanActive = new SimpleBooleanProperty();
    private final @NonNull SimpleObjectProperty<@Nullable Exception> targetBrowserException = new SimpleObjectProperty();

    protected static boolean calculateAdbRunnerCacheState(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable AdbDevice.AdbDeviceState adbDeviceState) {
        if (adbDeviceState == null) {
            return false;
        }
        switch (adbDeviceState) {
            case AVAILABLE: {
                return true;
            }
            case NOT_SUPPORTED: 
            case UNAUTHORIZED: {
                return false;
            }
        }
        throw new AssertionError(adbDeviceState);
    }

    private static @NonNull ITargetBrowser createAdbTargetBrowser(@Nullable IAdbProcessRunner adbProcessRunner, @Nullable Consumer<@NonNull Exception> exceptionConsumer) {
        if (adbProcessRunner == null) {
            return new NullTargetBrowser();
        }
        return new AdbTargetBrowser(adbProcessRunner, exceptionConsumer, true);
    }

    private static @NonNull BrowseResult ensureUdsAddress(@NonNull BrowseResult newHardware) {
        TargetAddressString udsAddress = TargetAddressString.makeAndroid(newHardware.getTargetAddressString().getAndroidSerialNumber(), false);
        return newHardware.withTargetAddress(udsAddress);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAndroidTargetDevice.Status evaluateStatusForGatordRunning(@NonNull BrowseResult device) {
        GatorCurrentConfig gatorCurrentConfig;
        try {
            GatorProtocolVersion version = AndroidDeviceDetector.parseVersion(device.getVersion());
            if (!GatorProtocolVerifier.isSuitableForLive(version)) {
                return version.supportsExitOk() ? IAndroidTargetDevice.Status.UNAVAILABLE_INVALID_VERSION_KILLABLE : IAndroidTargetDevice.Status.UNAVAILABLE_INVALID_VERSION_UNKILLABLE;
            }
        }
        catch (NumberFormatException e) {
            return IAndroidTargetDevice.Status.UNAVAILABLE_GATORD_RUNNING;
        }
        if (device.getGatorCurrentConfig().isPresent() && (gatorCurrentConfig = device.getGatorCurrentConfig().get()).getWaitForProcessCommand().isPresent()) {
            return IAndroidTargetDevice.Status.AVAILABLE_GATORD_RUNNING_PACKAGE;
        }
        return IAndroidTargetDevice.Status.UNAVAILABLE_GATORD_RUNNING;
    }

    private static @NonNull Optional<@NonNull RunAsInfo> getRunAsInfo(@NonNull Optional<@NonNull GatorCurrentConfig> optionalGatorConfig) {
        GatorCurrentConfig gatorCurrentConfig;
        Optional waitForProcessCommand;
        if (optionalGatorConfig.isPresent() && (waitForProcessCommand = (gatorCurrentConfig = optionalGatorConfig.get()).getWaitForProcessCommand()).isPresent()) {
            return Optional.of(new RunAsInfo(gatorCurrentConfig.getUid(), (String)waitForProcessCommand.get()));
        }
        return Optional.empty();
    }

    private static @NonNull GatorProtocolVersion parseVersion(String version) {
        return new GatorProtocolVersion(Integer.parseInt(version));
    }

    public AndroidDeviceDetector(@NonNull IAdbRunnerCache adbRunnerCache, @Nullable Consumer<@NonNull Exception> exceptionConsumer) {
        this(adbRunnerCache, (IAdbProcessRunner adb) -> AndroidDeviceDetector.createAdbTargetBrowser(adb, exceptionConsumer));
    }

    AndroidDeviceDetector(@NonNull IAdbRunnerCache adbRunnerCache, @NonNull Function<@Nullable IAdbProcessRunner, @NonNull ITargetBrowser> creationFunction) {
        this.adbRunnerCache = adbRunnerCache;
        this.browserCreator = creationFunction;
    }

    public void dispose() {
        this.browser.closeBrowser();
    }

    public @Nullable IAdbCommandRunner getCommandRunnerForDevice(@NonNull String serialNumber) {
        IAdbProcessRunner adbProcessRunner = this.adbProcessRunner.get();
        return adbProcessRunner != null ? this.adbRunnerCache.getCommandRunnerForDevice(adbProcessRunner, serialNumber) : null;
    }

    public @NonNull IDisposable requestDevices(@NonNull Consumer<@NonNull List<@NonNull IAndroidTargetDevice>> consumer) {
        this.lastConsumer.set(consumer);
        return () -> {};
    }

    public @NonNull ReadOnlyBooleanProperty scanActiveProperty() {
        return this.scanActive;
    }

    public @NonNull SimpleObjectProperty<@Nullable Exception> targetBrowserExceptionProperty() {
        return this.targetBrowserException;
    }

    public void setAdbProcessRunner(final @Nullable IAdbProcessRunner adbProcessRunner) {
        this.browser.closeBrowser();
        this.adbProcessRunner.set(adbProcessRunner);
        ITargetBrowser nextBrowser = this.browserCreator.apply(adbProcessRunner);
        nextBrowser.addClient(new ITargetBrowserClient(){

            @Override
            public void beginBrowse(@NonNull ConnectionType connectionType) {
                if (connectionType == ConnectionType.ADB) {
                    AndroidDeviceDetector.this.scanActive.set(true);
                }
            }

            @Override
            public void debugHardwareSearchFailed(@NonNull String reason) {
            }

            @Override
            public void endBrowse(@NonNull ConnectionType connectionType) {
                if (connectionType == ConnectionType.ADB) {
                    AndroidDeviceDetector.this.scanActive.set(false);
                }
            }

            @Override
            public void foundNewDebugHardware(@NonNull BrowseResult newHardware) {
                if (!$assertionsDisabled && adbProcessRunner == null) {
                    throw new AssertionError();
                }
                TargetAddressString targetAddress = newHardware.getTargetAddressString();
                if (!$assertionsDisabled && !targetAddress.isAndroid()) {
                    throw new AssertionError();
                }
                Optional<AdbDevice.AdbDeviceState> deviceState = newHardware.getAdbDeviceState();
                if (targetAddress.isAndroidOverTcp()) {
                    newHardware = AndroidDeviceDetector.ensureUdsAddress(newHardware);
                    targetAddress = newHardware.getTargetAddressString();
                }
                boolean retainOrCreateCacheItem = AndroidDeviceDetector.calculateAdbRunnerCacheState(deviceState.orElse(null));
                AndroidDeviceDetector.this.adbRunnerCache.updateCacheStateOnDeviceChange(adbProcessRunner, targetAddress.getAndroidSerialNumber(), retainOrCreateCacheItem);
                IAndroidTargetDevice previousTargetDevice = AndroidDeviceDetector.this.mapByAddress.get(targetAddress.getAndroidSerialNumber());
                if (previousTargetDevice != null) {
                    AdbDeviceRootMode rootMode = previousTargetDevice.getDeviceRootMode();
                    AndroidDeviceDetector.this.mapByAddress.put(targetAddress.getAndroidSerialNumber(), AndroidDeviceDetector.adaptToAndroidTargetDevice(newHardware, rootMode));
                } else {
                    IAdbCommandRunner commandrunner = AndroidDeviceDetector.this.getCommandRunnerForDevice(targetAddress.getAndroidSerialNumber());
                    AdbDeviceRootMode rootMode = AndroidDeviceDetector.detectRootMode(commandrunner);
                    AndroidDeviceDetector.this.mapByAddress.put(targetAddress.getAndroidSerialNumber(), AndroidDeviceDetector.adaptToAndroidTargetDevice(newHardware, rootMode));
                }
                AndroidDeviceDetector.this.passCurrentValuesToConsumer();
            }

            @Override
            public void removeDebugHardware(@NonNull BrowseResult removeHardware) {
                if (!$assertionsDisabled && adbProcessRunner == null) {
                    throw new AssertionError();
                }
                TargetAddressString targetAddress = removeHardware.getTargetAddressString();
                if (!$assertionsDisabled && !targetAddress.isAndroid()) {
                    throw new AssertionError();
                }
                AndroidDeviceDetector.this.adbRunnerCache.updateCacheStateOnDeviceChange(adbProcessRunner, targetAddress.getAndroidSerialNumber(), false);
                AndroidDeviceDetector.this.mapByAddress.remove(targetAddress.getAndroidSerialNumber());
                AndroidDeviceDetector.this.passCurrentValuesToConsumer();
            }
        });
        nextBrowser.startBrowsing(1, true);
        if (nextBrowser instanceof NullTargetBrowser) {
            this.mapByAddress.clear();
            this.passCurrentValuesToConsumer();
            this.scanActive.set(false);
        }
        this.browser = nextBrowser;
    }

    private void passCurrentValuesToConsumer() {
        this.lastConsumer.get().accept(this.mapByAddress.values().stream().collect(Collectors.toList()));
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAndroidTargetDevice.Status adaptStatus(@NonNull BrowseResult device) {
        if (device.getAdbDeviceState().isEmpty()) {
            return IAndroidTargetDevice.Status.UNAVAILABLE_OTHER;
        }
        AdbDevice.AdbDeviceState deviceState = device.getAdbDeviceState().get();
        switch (deviceState) {
            case AVAILABLE: {
                GatorProtocolVersion xmlVersion;
                Integer configurationSlVersion = device.getConfigurationStreamlineVersion();
                if (configurationSlVersion != null && (GatorProtocolVersionConstants.CURRENT_RELEASED_VERSION.compareMajorMinor(xmlVersion = new GatorProtocolVersion(configurationSlVersion)) > 0 || GatorProtocolVersionConstants.NEXT_DEVELOPMENT_VERSION.compareMajorMinor(xmlVersion) <= 0)) {
                    return IAndroidTargetDevice.Status.AVAILABLE_BUT_OUTDATED_CONFIGURATION_XML;
                }
                return device.isGatorRunning() ? AndroidDeviceDetector.evaluateStatusForGatordRunning(device) : IAndroidTargetDevice.Status.AVAILABLE;
            }
            case UNAUTHORIZED: {
                return IAndroidTargetDevice.Status.UNAUTHORIZED;
            }
            case NOT_SUPPORTED: {
                return IAndroidTargetDevice.Status.UNAVAILABLE_OTHER;
            }
        }
        throw new AssertionError((Object)("Unexpected AdbDeviceState " + String.valueOf(deviceState)));
    }

    private static @NonNull IAndroidTargetDevice adaptToAndroidTargetDevice(@NonNull BrowseResult device, @NonNull AdbDeviceRootMode rootMode) {
        IAndroidTargetDevice.Status status = AndroidDeviceDetector.adaptStatus(device);
        Optional<RunAsInfo> runAsInfo = AndroidDeviceDetector.getRunAsInfo(device.getGatorCurrentConfig());
        return new AndroidTargetDevice(status, device.getTargetAddressString(), (String)NullChecking.neverNullOr((Object)device.getDetails(), (Object)""), runAsInfo, rootMode, device.isMaliGpuDetected());
    }

    private static @NonNull AdbDeviceRootMode detectRootMode(@Nullable IAdbCommandRunner commandrunner) {
        if (commandrunner == null) {
            return AdbDeviceRootMode.NONE;
        }
        try {
            return commandrunner.detectRootMode();
        }
        catch (IOException e) {
            return AdbDeviceRootMode.NONE;
        }
    }

    private static class NullTargetBrowser
    implements ITargetBrowser {
        private NullTargetBrowser() {
        }

        @Override
        public void addClient(ITargetBrowserClient client) {
        }

        @Override
        public void closeBrowser() {
        }

        @Override
        public void startBrowsing(int browseTimeoutInSeconds, boolean browseContinuously) {
        }

        @Override
        public void stopBrowsing() {
        }
    }
}

