/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.section;

import com.arm.streamline.performanceadvisor.section.JsonLineMetric;
import java.util.Arrays;
import java.util.Objects;

public class JsonLineMetricWithThreshold
extends JsonLineMetric {
    private double percentageOverThreshold;

    public JsonLineMetricWithThreshold(double[] data, int[] centilesToCalculate, double threshold) {
        super(data, centilesToCalculate);
        this.percentageOverThreshold = 100.0 * (double)Arrays.stream(data).filter(a -> a > threshold).count() / (double)data.length;
    }

    public double getPercentageOverThreshold() {
        return this.percentageOverThreshold;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.percentageOverThreshold);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof JsonLineMetricWithThreshold)) {
            return false;
        }
        JsonLineMetricWithThreshold other = (JsonLineMetricWithThreshold)obj;
        return Double.doubleToLongBits(this.percentageOverThreshold) == Double.doubleToLongBits(other.percentageOverThreshold);
    }
}

