/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.section;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.common.LogUtils;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.renderer.GsonExclude;
import com.arm.streamline.performanceadvisor.section.ChartThreshold;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.ElementType;
import com.arm.streamline.performanceadvisor.section.JsonLineMetric;
import com.arm.streamline.performanceadvisor.section.JsonLineMetricWithThreshold;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DualAxisLineChart
extends Element {
    public static final String NO_SERIES_COLOUR = "";
    public static final int SIMILARITY_THRESHOLD = 95;
    static final List<String> DEFAULT_COLOURS = List.of("#fa7171", "#2ad0ff", "#7294ce", "#e3e448", "#cc7e6e", "#fb6ccf", "#c98dff", "#7d7d7d");
    private String xlabel;
    private double xdataStart;
    private int xdataLength;
    private double xdataStep;
    private List<String> ylabel;
    private List<String> ycolours;
    private List<double[]> ydata;
    @GsonExclude
    private List<double[]> ydataUnscaled;
    private static final String y2colour = "#00c73c";
    private String y2axislabel;
    private double[] y2data;
    private double ymax;
    @GsonExclude
    private double ymaxUnscaled;
    private double y2max;
    private String yaxislabel;
    private int y2tickcount;
    private ChartThreshold threshold;
    private String scaleLabel;
    private String group;

    public DualAxisLineChart(String xlabel, double xdataStart, int xdataLength, double xdataStep, String y2axislabel, double[] y2data, String group) {
        super(ElementType.DUAL_AXIS);
        DoubleSummaryStatistics stats = Arrays.stream(y2data).summaryStatistics();
        if (Double.isNaN(stats.getSum())) {
            throw new LogicError("Attempt to plot NaN values in dual-axis line chart");
        }
        if (y2data.length != xdataLength) {
            throw new LogicError(String.format("Series %s length is %d. Expected %d.", y2axislabel, y2data.length, xdataLength));
        }
        this.xlabel = xlabel;
        this.xdataStart = xdataStart;
        this.xdataLength = xdataLength;
        this.xdataStep = xdataStep;
        this.y2axislabel = y2axislabel;
        this.y2data = y2data;
        this.ymax = 0.0;
        this.ymaxUnscaled = 0.0;
        this.y2max = 0.0;
        this.yaxislabel = NO_SERIES_COLOUR;
        this.y2tickcount = 0;
        this.scaleLabel = NO_SERIES_COLOUR;
        this.ylabel = new ArrayList<String>();
        this.ycolours = new ArrayList<String>();
        this.ydata = new ArrayList<double[]>();
        this.ydataUnscaled = new ArrayList<double[]>();
        this.group = group;
        this.threshold = new ChartThreshold();
    }

    public void setYAxisLabel(String yaxislabel) {
        this.yaxislabel = yaxislabel;
    }

    public void setYAxisLimit(double ymax) {
        this.ymax = ymax;
        this.ymaxUnscaled = ymax;
    }

    public void setY2AxisLimit(double y2max) {
        this.y2max = y2max;
    }

    public void setY2TickCount(int y2tickcount) {
        this.y2tickcount = y2tickcount;
    }

    public void setThreshold(double value, String label) {
        this.threshold = new ChartThreshold(true, value, label);
    }

    public void addSeries(String label, double[] data) {
        this.addSeries(label, data, NO_SERIES_COLOUR);
    }

    public void addSeries(String label, double[] data, String colour) {
        Application.LOG.fine(() -> String.format("Dual-axis line chart, series %d: %s, size %d.", this.ydataUnscaled.size(), label, data.length));
        if (this.ylabel.contains(label)) {
            throw new LogicError(String.format("Each series in a chart must have a unique name (%s)", label));
        }
        DoubleSummaryStatistics stats = Arrays.stream(data).summaryStatistics();
        if (Double.isNaN(stats.getSum())) {
            throw new LogicError(String.format("Found NaN values in chart series %s", label));
        }
        if (data.length != this.xdataLength) {
            throw new LogicError(String.format("Series %s length is %d. Expected %d.", label, data.length, this.xdataLength));
        }
        this.ydata.add(data);
        this.ydataUnscaled.add(data);
        this.ylabel.add(label);
        this.ycolours.add(colour);
    }

    public void setColours(boolean needsStreamlineColours) {
        boolean containsEmptyColour = this.ycolours.contains(NO_SERIES_COLOUR);
        if ((containsEmptyColour || this.coloursTooSimilar()) && !needsStreamlineColours) {
            this.useDefaultColourList();
        }
    }

    public void setColours() {
        this.setColours(false);
    }

    private boolean coloursTooSimilar() {
        int i = 0;
        while (i < this.ycolours.size()) {
            int j = 0;
            while (j < this.ycolours.size()) {
                String colour2;
                String colour1;
                long colourDiff;
                if (j != i && (colourDiff = DualAxisLineChart.getColourDifference(colour1 = this.ycolours.get(i), colour2 = this.ycolours.get(j))) < 95L) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private void useDefaultColourList() {
        int i = 0;
        while (i < this.ycolours.size()) {
            this.ycolours.set(i, DEFAULT_COLOURS.get(i % DEFAULT_COLOURS.size()));
            ++i;
        }
    }

    private static long getColourDifference(String colour1, String colour2) {
        Color rgb1 = Color.decode(colour1);
        Color rgb2 = Color.decode(colour2);
        long rmean = (rgb1.getRed() + rgb2.getRed()) / 2;
        long r = rgb1.getRed() - rgb2.getRed();
        long g = rgb1.getGreen() - rgb2.getGreen();
        long b = rgb1.getBlue() - rgb1.getBlue();
        return (long)Math.sqrt(((512L + rmean) * r * r >> 8) + 4L * g * g + ((767L - rmean) * b * b >> 8));
    }

    public void scaleForSiPrefix() {
        Application.LOG.fine("scaleForSiPrefix: before scale:");
        LogUtils.seriesStats(this.ydataUnscaled, this.ylabel);
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        for (double[] data : this.ydataUnscaled) {
            stats.combine(Arrays.stream(data).summaryStatistics());
        }
        double overallMax = stats.getMax();
        if (overallMax > 0.0) {
            this.ydata = new ArrayList<double[]>();
            SiPrefixHelper prefixHelper = new SiPrefixHelper(overallMax);
            Application.LOG.fine(() -> String.format("Prefix is %s, divisor is %.1f", prefixHelper.getPrefix(), prefixHelper.getDivisor()));
            double divisor = prefixHelper.getDivisor();
            int i = 0;
            while (i < this.ydataUnscaled.size()) {
                double[] data = this.ydataUnscaled.get(i);
                double[] dataScaled = Arrays.copyOf(data, data.length);
                int j = 0;
                while (j < dataScaled.length) {
                    int n = j++;
                    dataScaled[n] = dataScaled[n] / divisor;
                }
                this.ydata.add(dataScaled);
                ++i;
            }
            this.ymax = this.ymaxUnscaled / divisor;
            this.threshold.setScalingDivisor(divisor);
            Application.LOG.fine("scaleForSiPrefix: after scale:");
            LogUtils.seriesStats(this.ydata, this.ylabel);
            this.scaleLabel = prefixHelper.getPrefix();
            if (this.scaleLabel.length() > 0) {
                this.yaxislabel = this.scaleLabel + " " + this.yaxislabel;
            }
        } else {
            this.ydata = this.ydataUnscaled;
        }
    }

    public String getXLabel() {
        return this.xlabel;
    }

    public double getXDataStart() {
        return this.xdataStart;
    }

    public int getXDataLength() {
        return this.xdataLength;
    }

    public double getXDataStep() {
        return this.xdataStep;
    }

    public List<String> getYLabel() {
        return this.ylabel;
    }

    public List<double[]> getYData() {
        return this.ydata;
    }

    public String getY2AxisLabel() {
        return this.y2axislabel;
    }

    public double[] getY2Data() {
        return this.y2data;
    }

    public double getYAxisLimit() {
        return this.ymax;
    }

    public double getY2AxisLimit() {
        return this.y2max;
    }

    public String getYAxisLabel() {
        return this.yaxislabel;
    }

    public int getY2TickCount() {
        return this.y2tickcount;
    }

    public String getScaleLabel() {
        return this.scaleLabel;
    }

    public String getGroup() {
        return this.group;
    }

    public List<double[]> getYDataUnscaled() {
        return this.ydataUnscaled;
    }

    public ChartThreshold getThreshold() {
        return this.threshold;
    }

    public Map<String, Object> asMap(int[] centiles) {
        LinkedHashMap<String, Object> jsonObj = new LinkedHashMap<String, Object>();
        int i = 0;
        while (i < this.ydataUnscaled.size()) {
            JsonLineMetric lineChartJson = this.threshold.getIsEnabled() ? new JsonLineMetricWithThreshold(this.ydataUnscaled.get(i), centiles, this.threshold.getUnscaled()) : new JsonLineMetric(this.ydataUnscaled.get(i), centiles);
            jsonObj.put(DualAxisLineChart.formatPropertyName(this.ylabel.get(i)), lineChartJson);
            ++i;
        }
        if (this.threshold.getIsEnabled()) {
            jsonObj.put("threshold", this.threshold.getUnscaled());
        }
        return jsonObj;
    }

    List<String> getColours() {
        return Collections.unmodifiableList(this.ycolours);
    }

    private static class SiPrefixHelper {
        private double divisor;
        private String prefix;
        private static final String[] siPrefix = new String[]{"", "k", "M", "G", "T"};

        public SiPrefixHelper(double value) {
            int digits = (int)Math.ceil(Math.log10(value));
            int multiplier = (digits - 2) / 3;
            multiplier = Math.max(Math.min(multiplier, 4), 0);
            this.divisor = Math.pow(10.0, 3.0 * (double)multiplier);
            this.prefix = siPrefix[multiplier];
        }

        public double getDivisor() {
            return this.divisor;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

