/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.renderer;

public class RendererOptions {
    private int[] centiles;
    private boolean prettyPrintJson;

    public RendererOptions(int[] centiles, boolean prettyPrintJson) {
        this.centiles = this.validateCentiles(centiles);
        this.prettyPrintJson = prettyPrintJson;
    }

    public RendererOptions(int[] centiles) {
        this(centiles, false);
    }

    public int[] validateCentiles(int[] inputCentiles) {
        int[] nArray = inputCentiles;
        int n = inputCentiles.length;
        int n2 = 0;
        while (n2 < n) {
            int centile = nArray[n2];
            if (centile < 1 || centile > 100) {
                throw new IllegalArgumentException(centile + " is not a valid percentile - must be between 0 and 100.");
            }
            ++n2;
        }
        return inputCentiles;
    }

    public int[] getCentiles() {
        return this.centiles;
    }

    public boolean prettyPrintJson() {
        return this.prettyPrintJson;
    }
}

