/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.json;

import com.arm.streamline.performanceadvisor.json.JsonDiffReport;
import com.arm.streamline.performanceadvisor.json.JsonDoubleSerialiser;
import com.arm.streamline.performanceadvisor.json.JsonRegionSection;
import com.arm.streamline.performanceadvisor.json.JsonSection;
import com.arm.streamline.performanceadvisor.json.JsonSectionSerialiser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

public class JsonDiffReportSerialiser
implements JsonSerializer<JsonDiffReport> {
    Gson gson;
    private static final String REGIONS_KEY = "regions";
    private static final String NAME_KEY = "name";

    public JsonDiffReportSerialiser() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(JsonSection.class, (Object)new JsonSectionSerialiser());
        gsonBuilder.registerTypeAdapter(Double.class, (Object)new JsonDoubleSerialiser());
        this.gson = gsonBuilder.create();
    }

    public JsonElement serialize(JsonDiffReport jsonDiffReport, Type type, JsonSerializationContext context) {
        JsonArray reportSectionsArray = new JsonArray();
        for (JsonSection jsonSection : jsonDiffReport.getSections()) {
            reportSectionsArray.add(this.gson.toJsonTree((Object)jsonSection));
        }
        JsonObject reportJsonObject = new JsonObject();
        reportJsonObject.add("captureInfo", this.gson.toJsonTree((Object)jsonDiffReport.getCaptureInfoDiff()));
        for (JsonElement reportSectionJsonElement : reportSectionsArray) {
            Set keys = reportSectionJsonElement.getAsJsonObject().keySet();
            for (String key : keys) {
                JsonObject sectionElementJsonObject = reportSectionJsonElement.getAsJsonObject().get(key).getAsJsonObject();
                reportJsonObject.add(key, (JsonElement)sectionElementJsonObject);
            }
        }
        if (jsonDiffReport.getRegions() != null) {
            reportJsonObject.add(REGIONS_KEY, (JsonElement)this.generateFormattedRegionSections(jsonDiffReport.getRegions()));
        }
        return reportJsonObject;
    }

    private JsonArray generateFormattedRegionSections(List<JsonRegionSection> regions) {
        JsonArray regionsSectionsArrayUnformatted = new JsonArray();
        JsonArray regionsSectionsArrayFormatted = new JsonArray();
        for (JsonRegionSection region : regions) {
            for (JsonSection jsonSection : region.getSections()) {
                regionsSectionsArrayUnformatted.add(this.gson.toJsonTree((Object)jsonSection));
            }
            JsonObject regionJsonObj = new JsonObject();
            regionJsonObj.addProperty(NAME_KEY, region.getName());
            for (JsonElement je : regionsSectionsArrayUnformatted) {
                Set keys = je.getAsJsonObject().keySet();
                for (String key : keys) {
                    if (!je.getAsJsonObject().get(key).isJsonObject()) continue;
                    regionJsonObj.add(key, (JsonElement)je.getAsJsonObject().get(key).getAsJsonObject());
                }
            }
            regionsSectionsArrayFormatted.add((JsonElement)regionJsonObj);
        }
        return regionsSectionsArrayFormatted;
    }
}

