/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.io;

import com.arm.streamline.performanceadvisor.io.PathValidator;
import com.arm.streamline.performanceadvisor.io.UserProvidedPath;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;

public class ReadPathValidator
extends PathValidator {
    public ReadPathValidator(UserProvidedPath path) {
        super(path);
    }

    @Override
    Optional<String> validate(UserProvidedPath path) {
        Path adjustedPath = path.getAdjustedPath();
        Path userPath = path.getUserProvidedPath();
        if (!Files.exists(adjustedPath, new LinkOption[0])) {
            return Optional.of(String.format("\"%s\" does not exist", userPath));
        }
        if (!Files.isReadable(adjustedPath)) {
            return Optional.of(String.format("No permission to read %s", userPath));
        }
        return Optional.empty();
    }
}

