/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.developer;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.analyser.Analyser;
import com.arm.streamline.performanceadvisor.analyser.AnalyserFactory;
import com.arm.streamline.performanceadvisor.analyser.PerFrameChartData;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.capturedata.FpsProvider;
import com.arm.streamline.performanceadvisor.capturedata.FrameProvider;
import com.arm.streamline.performanceadvisor.counterseries.FrameMetricSeries;
import com.arm.streamline.performanceadvisor.section.Element;
import com.arm.streamline.performanceadvisor.section.LineChart;
import com.arm.streamline.performanceadvisor.section.Section;
import com.arm.streamline.performanceadvisor.section.TextBlock;
import com.arm.streamline.performanceadvisor.section.TextStyle;
import java.util.ArrayList;
import java.util.List;

public class PerFrameScalingTestAnalyserFactory
extends AnalyserFactory {
    @Override
    public Analyser create(CaptureData captureData) {
        return new PerFrameScalingTestAnalyser(captureData);
    }

    public class PerFrameScalingTestAnalyser
    extends Analyser {
        private double[] fpsData;

        public PerFrameScalingTestAnalyser(CaptureData captureData) {
            super(captureData);
        }

        @Override
        public Section execute(int userRegion) {
            FrameProvider frameProvider = this.captureData.getFrameProvider();
            int endIndex = frameProvider.getLastFrame().getEnd();
            Application.LOG.fine(String.format("FrameProvider reports last frame end is at index %d", endIndex - 1));
            assert (endIndex <= this.captureData.getBinCount());
            FpsProvider fpsProvider = this.captureData.getFpsProvider();
            this.fpsData = fpsProvider.getPerBin().toArray(0, endIndex);
            Application.LOG.fine(String.format("fpsData has %d values", this.fpsData.length));
            ArrayList<Element> elements = new ArrayList<Element>();
            Object heading = "Per-frame chart binning and scaling test";
            if (userRegion != 0) {
                heading = (String)heading + " (region " + Integer.toString(userRegion) + ")";
            }
            elements.add(new TextBlock(TextStyle.H2_HIDDEN, (String)heading, "This chart shows the distribution of GPU cycles across JS1 (vertex/tiler/compute) and JS0 (fragment) work queues. It can serve two purposes. Firstly you can identify the dominant workload, so you know whether to focus on optimizing non-fragment workloads or fragment workloads. Secondly you can see, for regions below target frame rate, whether you are getting overlap across the two work queues. Overlap helps to load balance the shader core resources, and lack of overlap can indicate scheduling bubbles caused by e.g. bad barriers or stage dependencies in Vulkan. Note that overlap is not always possible in regions which are hitting target frame rate."));
            elements.add(new TextBlock(TextStyle.DESCRIPTION, "FPS per frame"));
            elements.add(new LineChart("Time (s)", "FPS", frameProvider.getFrameStarts(), fpsProvider.getPerFrame().toArray(), "overall"));
            int binSize = 200;
            int samplesPerSecond = this.captureData.getSamplesPerSecond();
            elements.addAll(this.binnedUnscaled(binSize, samplesPerSecond));
            elements.addAll(this.binnedScaled(binSize, samplesPerSecond));
            return new Section("perFrameScalingTest", elements);
        }

        private List<Element> binnedUnscaled(int binSize, int samplesPerSecond) {
            Application.LOG.fine("Test binning without FPS scaling");
            FrameMetricSeries frameMetricSeries = new FrameMetricSeries("FPS", this.fpsData, false);
            PerFrameChartData chartData = new PerFrameChartData(binSize, samplesPerSecond, frameMetricSeries, 0, frameMetricSeries.getLength(), false, "overall");
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(new TextBlock(TextStyle.DESCRIPTION, String.format("%dms binned", binSize)));
            elements.add(chartData.getChart());
            return elements;
        }

        private List<Element> binnedScaled(int binSize, int samplesPerSecond) {
            Application.LOG.fine("Test binning with FPS scaling");
            FrameMetricSeries frameMetricSeries = new FrameMetricSeries("FPS", this.fpsData, false);
            PerFrameChartData chartData = new PerFrameChartData(binSize, samplesPerSecond, frameMetricSeries, 0, frameMetricSeries.getLength(), true, "overall");
            ArrayList<Element> elements = new ArrayList<Element>();
            elements.add(new TextBlock(TextStyle.DESCRIPTION, String.format("%dms binned and scaled against FPS", binSize)));
            elements.add(chartData.getChart());
            return elements;
        }
    }
}

