/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import java.util.Iterator;
import java.util.function.UnaryOperator;

public class UnaryOpSeries
extends BasicSeries {
    private CounterSeries series;
    private UnaryOperator<Double> fn;

    public UnaryOpSeries(CounterSeries series, String name, UnaryOperator<Double> fn) {
        super(name);
        this.series = series;
        this.fn = fn;
        Application.LOG.fine(() -> String.format("New UnaryOpSeries %s containing CounterSeries \"%s\"", name, series.getName()));
    }

    public UnaryOpSeries(CounterSeries series, UnaryOperator<Double> fn) {
        this(series, series.getName(), fn);
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        return this.series.initialise(captureData);
    }

    @Override
    public boolean isPresent() {
        return this.series.isPresent();
    }

    @Override
    public boolean isPerFrame() {
        return this.series.isPerFrame();
    }

    @Override
    public int getLength() {
        return this.series.getLength();
    }

    @Override
    public Iterator<Double> iterator(int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex > endIndex || endIndex > this.getLength() || this.getLength() != 0 && startIndex >= this.getLength()) {
            throw new LogicError("invalid iterator index for series " + this.getName());
        }
        if (!this.isPresent()) {
            throw new LogicError(String.format("No data for series %s", this.getName()));
        }
        return new UnaryOpIterator(this.series.iterator(startIndex, endIndex));
    }

    private class UnaryOpIterator
    implements Iterator<Double> {
        private Iterator<Double> it;

        public UnaryOpIterator(Iterator<Double> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Double next() {
            return (Double)UnaryOpSeries.this.fn.apply(this.it.next());
        }
    }
}

