/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.performanceadvisor.counterseries;

import com.arm.streamline.performanceadvisor.Application;
import com.arm.streamline.performanceadvisor.capturedata.CaptureData;
import com.arm.streamline.performanceadvisor.common.LogicError;
import com.arm.streamline.performanceadvisor.common.ProblemList;
import com.arm.streamline.performanceadvisor.counterseries.BasicSeries;
import com.arm.streamline.performanceadvisor.counterseries.CounterDescriptor;
import com.arm.streamline.performanceadvisor.counterseries.CounterSeries;
import com.arm.streamline.performanceadvisor.counterseries.StreamlineSeries;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SummationSeries
extends BasicSeries {
    private List<CounterSeries> counters;
    private int numSamples;
    private boolean initialised;

    public SummationSeries(String name, List<CounterSeries> counters) {
        super(name);
        this.counters = counters;
        this.numSamples = 0;
        this.initialised = false;
    }

    public SummationSeries(String name) {
        this(name, new ArrayList<CounterSeries>());
    }

    public void addComponent(CounterSeries source) {
        if (this.initialised) {
            throw new LogicError("SummationSeries: add all components before initialisation");
        }
        this.counters.add(source);
    }

    public void addComponent(CounterDescriptor counter) {
        this.addComponent(new StreamlineSeries(counter));
    }

    public void addOptionalComponent(CounterDescriptor counter) {
        this.addComponent(new StreamlineSeries(counter, true, false));
    }

    @Override
    public ProblemList initialise(CaptureData captureData) {
        ProblemList problems = new ProblemList();
        for (CounterSeries i : this.counters) {
            problems.addAll(i.initialise(captureData));
        }
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (CounterSeries i : this.counters) {
            if (!i.isPresent()) continue;
            lengths.add(i.getLength());
        }
        if (!lengths.isEmpty()) {
            this.numSamples = (Integer)lengths.get(0);
            Application.LOG.finest(() -> String.format("SummationSeries.initialise: numSamples=%d", this.numSamples));
            int i = 1;
            while (i < lengths.size()) {
                if ((Integer)lengths.get(i) != this.numSamples) {
                    throw new LogicError("SummationSeries: all series must be the same length");
                }
                ++i;
            }
        }
        this.initialised = true;
        return problems;
    }

    @Override
    public int getLength() {
        return this.numSamples;
    }

    @Override
    public boolean isPresent() {
        boolean found = false;
        for (CounterSeries i : this.counters) {
            found = i.isPresent();
            if (found) break;
        }
        return found;
    }

    @Override
    public Iterator<Double> iterator(int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex > endIndex || endIndex > this.getLength() || this.getLength() != 0 && startIndex >= this.getLength()) {
            throw new LogicError("invalid iterator index for series " + this.getName());
        }
        ArrayList<Iterator<Double>> itList = new ArrayList<Iterator<Double>>();
        for (CounterSeries i : this.counters) {
            if (!i.isPresent()) continue;
            itList.add(i.iterator(startIndex, endIndex));
        }
        return new SumIterator(itList);
    }

    private class SumIterator
    implements Iterator<Double> {
        private List<Iterator<Double>> itList;

        public SumIterator(List<Iterator<Double>> itList) {
            this.itList = itList;
        }

        @Override
        public boolean hasNext() {
            return !this.itList.isEmpty() && this.itList.get(0).hasNext();
        }

        @Override
        public Double next() {
            double sum = 0.0;
            for (Iterator<Double> i : this.itList) {
                sum += i.next().doubleValue();
            }
            return sum;
        }
    }
}

